var suivi_etude_geotechnique_table = undefined;
var suivi_etude_geotechnique_table_per_filters = [];

$(document).ready(function () {
    suivi_etude_geotechnique_table_per_filters.push({ column: "geometry", table: "", value: 1 });
    suivi_etude_geotechnique_table_per_filters.push({ column: "etude_geotechnique_geometry_exists", table: "", value: 1 });

    //suivi_etude_geotechnique_table_per_filters.push({ column: "constructibilite", table: "", value: "constructible,constructible_conditions,constructible_conditions_strictes,non_constructible,non_couvert"});

    suivi_etude_geotechnique_table = $('#suivi_etude_geotechnique_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: true,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'dossiers_datatable?referer=suivi&filters=' + JSON.stringify(suivi_etude_geotechnique_table_per_filters),
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Dossiers-' + current_date.replaceAll("/", "-"),
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3, 4, 5, 6, 7, 8, 9] }
        ],
        columns: [
            {
                data: 'numero',
            },
            {
                data: 'petitionnaires',
            },
            {
                data: 'cin',
            },
            {
                data: 'architecte',
            },
            {
                data: 'igt',
            },
            {
                data: 'bet',
            },
            {
                data: 'etat_avancement',
            },
            {
                data: 'aide_frontale',
            },
            {
                data: 'province',
            },
            {
                data: 'commune',
            },
            {
                data: 'douar',
            },
            {
                data: 'etude_geotechnique_area_constructible',
            },
            {
                data: 'etude_geotechnique_area_constructible_conditions',
            },
            {
                data: 'etude_geotechnique_area_constructible_conditions_strictes',
            },
            {
                data: 'etude_geotechnique_area_non_constructible',
            },
            {
                data: 'etude_geotechnique_area_non_couvert',
            },

        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }


    }).on("xhr.dt", function (e, settings, json, xhr) {

        $(".total_etude_geotechnique_area_constructible").text(json.total_etude_geotechnique_area_constructible);
        $(".total_etude_geotechnique_area_constructible_conditions").text(json.total_etude_geotechnique_area_constructible_conditions);
        $(".total_etude_geotechnique_area_constructible_conditions_strictes").text(json.total_etude_geotechnique_area_constructible_conditions_strictes);
        $(".total_etude_geotechnique_area_non_constructible").text(json.total_etude_geotechnique_area_non_constructible);
        $(".total_etude_geotechnique_area_non_couvert").text(json.total_etude_geotechnique_area_non_couvert);

        $("#dt_dossiers_count").text(json.recordsFiltered);
    });


    suivi_etude_geotechnique_table.on('draw', function () {
        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });
    });
});

$(".dossiers_table_export_excel").click(function () {
    suivi_etude_geotechnique_table.buttons(0).trigger();
});


$(".dt4_filter").change(function () {
    filter_suivi_etude_geo_table();
});

$(".dt4_filter").keyup(function () {
    filter_suivi_etude_geo_table();
});


function filter_suivi_etude_geo_table() {
    var filters = [];
    $(".dt4_filter").each(function () {
        var column = $(this).attr('column');
        var table = $(this).attr('table');
        var value = $(this).val();
        var params = $(this).attr('params');
        if (value != 'all' && value.trim().length > 0) {
            filters.push({ column: column, table: table, value: value, params: params });
        }
    });

    suivi_etude_geotechnique_table_per_filters.forEach(per_filters => {
        filters.push(per_filters);
    });

    if ($("#etude_geo_tab_etat_avancement_filter").val() != 'all') {
        var column = "etat_avancement";
        var table = "";
        var value = $("#etude_geo_tab_etat_avancement_filter").val();
        filters.push({ column: column, table: table, value: value });
    }
    if ($("#aide_frontale_filter").val() != 'all') {
        var column = "aide_frontale";
        var table = "";
        var value = parseInt($("#aide_frontale_filter").val());
        filters.push({ column: column, table: table, value: value });
    }

    if ($("#constructibilite_filter").val() != "all") {
        var column = "constructibilite";
        var table = "";
        var value = $("#constructibilite_filter").val();
        filters.push({ column: column, table: table, value: value });
    }
    suivi_etude_geotechnique_table.ajax.url(assetBaseUrl + 'dossiers_datatable?referer=suivi&filters=' + JSON.stringify(filters)).load();
}

$("#constructibilite_filter").change(function () {
    filter_suivi_etude_geo_table();
});
$("#aide_frontale_filter").change(function () {
    filter_suivi_etude_geo_table();
});

$(".etude_geo_tab_custom_filter").change(function () {
    filter_suivi_etude_geo_table();
});

$("#etude_geo_tab_provinces_filter").change(function () {
    etude_geo_tab_refresh_situation_filters('province');
});
$("#etude_geo_tab_cercles_filter").change(function () {
    etude_geo_tab_refresh_situation_filters('cercle');
});
$("#etude_geo_tab_communes_filter").change(function () {
    etude_geo_tab_refresh_situation_filters('commune');
});
$("#etude_geo_tab_douars_filter").change(function () {
    etude_geo_tab_refresh_situation_filters('douar');
});

function etude_geo_tab_fill_situation_filter_cercle(province_id) {
    $("#etude_geo_tab_cercles_filter").empty();
    $("#etude_geo_tab_cercles_filter").append(new Option('Indifferent', 'all'));
    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                $("#etude_geo_tab_cercles_filter").append(new Option(cercle.nom, cercle.id));
            }
        }
        else {
            $("#etude_geo_tab_cercles_filter").append(new Option(cercle.nom, cercle.id));
        }
    });
}

function etude_geo_tab_fill_situation_filter_commune(province_id, cercle_id) {
    $("#etude_geo_tab_communes_filter").empty();
    $("#etude_geo_tab_communes_filter").append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });

    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        $("#etude_geo_tab_communes_filter").append(new Option(commune.nom, commune.id));
                    }
                }
                else {
                    $("#etude_geo_tab_communes_filter").append(new Option(commune.nom, commune.id));
                }
            }
        });
    });

}


function etude_geo_tab_fill_situation_filter_douar(province_id, cercle_id, commune_id) {
    $("#etude_geo_tab_douars_filter").empty();
    $("#etude_geo_tab_douars_filter").append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });

    var filtred_communes = [];
    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        filtred_communes.push(commune);
                    }
                }
                else {
                    filtred_communes.push(commune);
                }
            }
        });
    });

    filtred_communes.forEach(commune => {
        douars.forEach(douar => {
            if (douar.commune_id == commune.id) {
                if (commune_id != 'all') {
                    if (commune.id == commune_id) {
                        $("#etude_geo_tab_douars_filter").append(new Option(douar.nom, douar.id));
                    }
                }
                else {
                    $("#etude_geo_tab_douars_filter").append(new Option(douar.nom, douar.id));
                }
            }
        });
    });

}

function etude_geo_tab_refresh_situation_filters(trigger_source) {
    if (trigger_source == 'province') {
        etude_geo_tab_fill_situation_filter_cercle($("#etude_geo_tab_provinces_filter").val(), 'all');
        etude_geo_tab_fill_situation_filter_commune($("#etude_geo_tab_provinces_filter").val(), 'all');
        etude_geo_tab_fill_situation_filter_douar($("#etude_geo_tab_provinces_filter").val(), 'all', 'all');
    }
    if (trigger_source == 'cercle') {
        var province_id = undefined;

        if ($("#etude_geo_tab_cercles_filter").val() == 'all') {
            etude_geo_tab_refresh_situation_filters('province');
            return;
        }

        cercles.forEach(cercle => {
            if (cercle.id == $("#etude_geo_tab_cercles_filter").val()) {
                province_id = cercle.province_id;
            }
        });

        $("#etude_geo_tab_provinces_filter").val(province_id);
        $('#etude_geo_tab_provinces_filter').trigger('change.select2');

        etude_geo_tab_fill_situation_filter_commune(province_id, $("#etude_geo_tab_cercles_filter").val());
        etude_geo_tab_fill_situation_filter_douar(province_id, $("#etude_geo_tab_cercles_filter").val(), 'all');
    }

    if (trigger_source == 'commune') {
        var province_id = undefined;
        var cercle_id = undefined;

        if ($("#etude_geo_tab_communes_filter").val() == 'all') {
            etude_geo_tab_refresh_situation_filters('cercle');
            return;
        }

        communes.forEach(commune => {
            if (commune.id == $("#etude_geo_tab_communes_filter").val()) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#etude_geo_tab_provinces_filter").val(province_id);
        $('#etude_geo_tab_provinces_filter').trigger('change.select2');

        $("#etude_geo_tab_cercles_filter").val(cercle_id);
        $('#etude_geo_tab_cercles_filter').trigger('change.select2');

        etude_geo_tab_fill_situation_filter_douar(province_id, $("#etude_geo_tab_cercles_filter").val(), $("#etude_geo_tab_communes_filter").val(), 'all');
    }

    if (trigger_source == 'douar') {
        var province_id = undefined;
        var cercle_id = undefined;
        var commune_id = undefined;

        if ($("#etude_geo_tab_douars_filter").val() == 'all') {
            etude_geo_tab_refresh_situation_filters('commune');
            return;
        }

        douars.forEach(douar => {
            if (douar.id == $("#etude_geo_tab_douars_filter").val()) {
                commune_id = douar.commune_id;
            }
        });

        communes.forEach(commune => {
            if (commune.id == commune_id) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#etude_geo_tab_provinces_filter").val(province_id);
        $('#etude_geo_tab_provinces_filter').trigger('change.select2');

        $("#etude_geo_tab_cercles_filter").val(cercle_id);
        $('#etude_geo_tab_cercles_filter').trigger('change.select2');

        $("#etude_geo_tab_communes_filter").val(commune_id);
        $('#etude_geo_tab_communes_filter').trigger('change.select2');


    }
}
