var suivi_verification_table = undefined;

$(document).ready(function () {
    suivi_verification_table = $('#suivi_verification_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: true,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'dossiers_datatable?referer=suivi&filters=[]',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '<button class="btn"><i class="fa fa-file-excel-o" ></i>  Exporter Excel</button>',
                "titleAttr": 'excel',
                'title': '',
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3, 4, 5] }
        ],
        columns: [
            {
                data: 'numero',
            },
            {
                data: 'petitionnaires',
            },
           
            {
                data: 'cin',
            },
            {
                data: 'province',
            },
            {
                data: 'commune',
            },
            {
                data: 'douar',
            },
            {
                data: 'architecte',
            },
            {
                data: 'DEMANDE_AUTORISATION_v',
            },
            {
                data: 'AUTORISATION_CONSTRUIRE_v',
            },
            {
                data: 'OVERTURE_CHANTIER_v',
            },
            {
                data: 'RECPTION_FONDATIONS_v',
            },
            {
                data: 'RECEPTION_STRUCTURE_v',
            },
            {
                data: 'RECEPTION_PLANCHER_v',
            },
            {
                data: 'PV_RECEPTION_FINITION_v',
            },
            {
                data: 'PV_FIN_TRAVAUX_v',
            },
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }


    }).on("xhr.dt", function (e, settings, json, xhr) {


    });;



});



$(".dt3_filter").change(function () {
    filter_suivi_verification_table();
});

$(".dt3_filter").keyup(function () {
    filter_suivi_verification_table();
});

function filter_suivi_verification_table() {
    var filters = [];
    $(".dt3_filter").each(function () {
        var column = $(this).attr('column');
        var table = $(this).attr('table');
        var value = $(this).val();
        var params = $(this).attr('params');
        if (value != 'all' && value.trim().length > 0) {
            filters.push({ column: column, table: table, value: value, params: params });
        }
    });

    $(".document_filter").each(function () {


        var value = $(this).val();
        if (value != 'all') {
            filters.push({ column: "document_filter", etat: $("#document_etat_filter").val(), value: value });
        }
    });

    var verificateur = $("#suivi_par_douars_filter_verificateur").val();




    suivi_verification_table.ajax.url(assetBaseUrl + 'dossiers_datatable?verificateur=' + verificateur + '&filters=' + JSON.stringify(filters)).load();
}


$("#document_etat_filter").change(function () {
    filter_suivi_verification_table();
});
$("#type_document_filter").change(function () {
    filter_suivi_verification_table();
});

$("#suivi_par_douars_filter_verificateur").change(function () {
    filter_suivi_verification_table();
});

$("#type_document_filter").change(function () {
    $("#document_etat_filter").removeAttr('disabled');

    $("#document_etat_filter").empty();
    $("#document_etat_filter").append(new Option('Déposé', 'all'));
    $("#document_etat_filter").append(new Option('Non déposé', 'NO_DEPOT'));
    $("#document_etat_filter").append(new Option('En attente', 'En attente'));
    $("#document_etat_filter").append(new Option('Validé', 'Validé'));
    $("#document_etat_filter").append(new Option('Rejeté', 'Rejeté'));

    $("#document_etat_filter").append(new Option('CIN introuvable', 'CIN introuvable'));

    if ($("#type_document_filter").val() == "all") {
        $("#document_etat_filter").attr('disabled', 'disabled');
    }

    if ($("#type_document_filter").val() == "NO_DOCUMENTS") {
        $("#document_etat_filter").attr('disabled', 'disabled');
    }
    if ($("#type_document_filter").val() == "PLAN_COTE_PDF") {
        $("#document_etat_filter option[value='En attente']").remove();
        $("#document_etat_filter option[value='Validé']").remove();
        $("#document_etat_filter option[value='Rejeté']").remove();

    }
    if ($("#type_document_filter").val() == "PLAN_ARCHITECTE_PDF") {
        $("#document_etat_filter option[value='En attente']").remove();
        $("#document_etat_filter option[value='Validé']").remove();
        $("#document_etat_filter option[value='Rejeté']").remove();

    }
    if ($("#type_document_filter").val() == "PLAN_BETON_ARME_PDF") {

        $("#document_etat_filter option[value='En attente']").remove();
        $("#document_etat_filter option[value='Validé']").remove();
        $("#document_etat_filter option[value='Rejeté']").remove();
    }
});


$("#verification_tab_provinces_filter").change(function () {
    verification_tab_refresh_situation_filters('province');
});
$("#verification_tab_cercles_filter").change(function () {
    verification_tab_refresh_situation_filters('cercle');
});
$("#verification_tab_communes_filter").change(function () {
    verification_tab_refresh_situation_filters('commune');
});
$("#verification_tab_douars_filter").change(function () {
    verification_tab_refresh_situation_filters('douar');
});



function verification_tab_fill_situation_filter_cercle(province_id) {
    $("#verification_tab_cercles_filter").empty();
    $("#verification_tab_cercles_filter").append(new Option('Indifferent', 'all'));
    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                $("#verification_tab_cercles_filter").append(new Option(cercle.nom, cercle.id));
            }
        }
        else {
            $("#verification_tab_cercles_filter").append(new Option(cercle.nom, cercle.id));
        }
    });
}

function verification_tab_fill_situation_filter_commune(province_id, cercle_id) {
    $("#verification_tab_communes_filter").empty();
    $("#verification_tab_communes_filter").append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });

    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        $("#verification_tab_communes_filter").append(new Option(commune.nom, commune.id));
                    }
                }
                else {
                    $("#verification_tab_communes_filter").append(new Option(commune.nom, commune.id));
                }
            }
        });
    });

}


function verification_tab_fill_situation_filter_douar(province_id, cercle_id, commune_id) {
    $("#verification_tab_douars_filter").empty();
    $("#verification_tab_douars_filter").append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });

    var filtred_communes = [];
    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        filtred_communes.push(commune);
                    }
                }
                else {
                    filtred_communes.push(commune);
                }
            }
        });
    });

    filtred_communes.forEach(commune => {
        douars.forEach(douar => {
            if (douar.commune_id == commune.id) {
                if (commune_id != 'all') {
                    if (commune.id == commune_id) {
                        $("#verification_tab_douars_filter").append(new Option(douar.nom, douar.id));
                    }
                }
                else {
                    $("#verification_tab_douars_filter").append(new Option(douar.nom, douar.id));
                }
            }
        });
    });

}
function verification_tab_refresh_situation_filters(trigger_source) {
    if (trigger_source == 'province') {
        verification_tab_fill_situation_filter_cercle($("#verification_tab_provinces_filter").val(), 'all');
        verification_tab_fill_situation_filter_commune($("#verification_tab_provinces_filter").val(), 'all');
        verification_tab_fill_situation_filter_douar($("#verification_tab_provinces_filter").val(), 'all', 'all');
    }
    if (trigger_source == 'cercle') {
        var province_id = undefined;

        if ($("#verification_tab_cercles_filter").val() == 'all') {
            verification_tab_refresh_situation_filters('province');
            return;
        }

        cercles.forEach(cercle => {
            if (cercle.id == $("#verification_tab_cercles_filter").val()) {
                province_id = cercle.province_id;
            }
        });

        $("#verification_tab_provinces_filter").val(province_id);
        $('#verification_tab_provinces_filter').trigger('change.select2');

        verification_tab_fill_situation_filter_commune(province_id, $("#verification_tab_cercles_filter").val());
        verification_tab_fill_situation_filter_douar(province_id, $("#verification_tab_cercles_filter").val(), 'all');
    }

    if (trigger_source == 'commune') {
        var province_id = undefined;
        var cercle_id = undefined;

        if ($("#verification_tab_communes_filter").val() == 'all') {
            verification_tab_refresh_situation_filters('cercle');
            return;
        }

        communes.forEach(commune => {
            if (commune.id == $("#verification_tab_communes_filter").val()) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#verification_tab_provinces_filter").val(province_id);
        $('#verification_tab_provinces_filter').trigger('change.select2');

        $("#verification_tab_cercles_filter").val(cercle_id);
        $('#verification_tab_cercles_filter').trigger('change.select2');

        verification_tab_fill_situation_filter_douar(province_id, $("#verification_tab_cercles_filter").val(), $("#verification_tab_communes_filter").val(), 'all');
    }

    if (trigger_source == 'douar') {
        var province_id = undefined;
        var cercle_id = undefined;
        var commune_id = undefined;

        if ($("#verification_tab_douars_filter").val() == 'all') {
            verification_tab_refresh_situation_filters('commune');
            return;
        }

        douars.forEach(douar => {
            if (douar.id == $("#verification_tab_douars_filter").val()) {
                commune_id = douar.commune_id;
            }
        });

        communes.forEach(commune => {
            if (commune.id == commune_id) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#verification_tab_provinces_filter").val(province_id);
        $('#verification_tab_provinces_filter').trigger('change.select2');

        $("#verification_tab_cercles_filter").val(cercle_id);
        $('#verification_tab_cercles_filter').trigger('change.select2');

        $("#verification_tab_communes_filter").val(commune_id);
        $('#verification_tab_communes_filter').trigger('change.select2');


    }
}
