var suivi_al_dossiers_table = undefined;
var import_etat_al_modal_file_events = undefined;
var import_etat_al_last_wrong_cin_error_list = [];

$(document).ready(function () {
    suivi_al_dossiers_table = $('#suivi_al_dossiers_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: true,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'dossiers_datatable?referer=suivi&filters=[]',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '<button class="btn"><i class="fa fa-file-excel-o" ></i>  Exporter Excel</button>',
                "titleAttr": 'excel',
                'title': '',
                "action": newexportaction,
                exportOptions: {
                    columns: ':visible',
                    format: {
                        body: function (data, row, column, node) {
                            // Strip HTML tags using regex
                            

                            var tempDiv = document.createElement("div");
                            tempDiv.innerHTML = data;
                            return tempDiv.textContent || tempDiv.innerText || "";
                        }
                    }
                }
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3, 4, 5] }
        ],
        columns: [
            {
                data: 'numero',
            },

            {
                data: 'province',
            },
            {
                data: 'commune',
            },
            {
                data: 'douar',
            },
            {
                data: 'petitionnaires',
            },
            {
                data: 'cin',
            },
            {
                data: 'dernier_etat',
            },
            {
                data: 'etat_al',
            },

        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }


    }).on("xhr.dt", function (e, settings, json, xhr) {
        $("#dt4_dossiers_count").text(json.recordsFiltered);



    });;


    suivi_al_dossiers_table.on('draw', function () {

        $(".tooltip").tooltip("hide");
        $('a[data-toggle="tooltip"]').tooltip({
            animated: 'fade',
            placement: 'bottom',
            html: true
        });
    });

    import_etat_al_modal_file_events = $('#import_etat_al_modal_file').dropify({
        messages: {
            'default': 'Faites glisser et déposez un fichier ici',
            'replace': 'Glisser-déposer ou cliquer pour remplacer',
            'remove': 'Supprimer',
            'error': 'Ooops, something wrong happended.'
        },
        error: {
            'fileSize': 'The file size is too big ({{ value }} max).',
            'imageFormat': 'The image format is not allowed ({{ value }} only).'
        }
    });
});


$("#import_etat_al_modal_form").submit(function (event) {
    import_etat_al_last_wrong_cin_error_list = [];

    event.preventDefault();
    showLoading('HMR', 'Chargement...');
    var formData = new FormData(this);

    formData.append("etat_al", $("#import_etat_al_modal_etat").val());
    $.ajax({
        url: assetBaseUrl + "dossiers/upload_etat_al",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            closeLoading();

            if (response.success == 1) {
                $("#import_etat_al_modal").modal('hide');
                location.reload();
            }
            else {
                if (response.error == "NO_XLSX_FILE") {
                    gl_alert('error', 'HMR', "Veuillez charger le fichier excel.");
                }

                if (response.error == "CIN_NOT_FOUND") {
                    import_etat_al_last_wrong_cin_error_list = response.not_found_cin;
                    gl_alert('error', 'HMR', "Un ou plusieurs numéros de carte d'identité nationale (CIN) sont invalides. Voici la liste des CIN érronées : <a id='import_etat_al_download_wrong_cin_list_btn' href='Javascript:;'>Télécharger</a>");
                }

            }

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});


$(".import_etat_al_btn").click(function () {
    $("#import_etat_al_modal").modal("show");
});

$('body').on('click', '#import_etat_al_download_wrong_cin_list_btn', function () {
    var filename = "cin_éronnées_" + Date.now() + ".txt";
    var text = import_etat_al_last_wrong_cin_error_list;
    var element = document.createElement('a');
    element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text.join('\n')));
    element.setAttribute('download', filename);

    element.style.display = 'none';
    document.body.appendChild(element);

    element.click();

    document.body.removeChild(element);
});



$(".dt4_filter").change(function () {
    filter_suivi_al_table();
});

$(".dt4_filter").keyup(function () {
    filter_suivi_al_table();
});

function filter_suivi_al_table() {
    var filters = [];
    $(".dt4_filter").each(function () {
        var column = $(this).attr('column');
        var table = $(this).attr('table');
        var value = $(this).val();
        var params = $(this).attr('params');
        if (value != 'all' && value.trim().length > 0) {
            filters.push({ column: column, table: table, value: value, params: params });
        }
    });

    if ($("#suivi_al_only_different_etat_filter").prop('checked')) {
        var column = "suivi_al_only_different_etat_filter";
        var table = "";
        var value = 1;
        var params = "";
        filters.push({ column: column, table: table, value: value, params: params })
    }
    else {
        if ($("#suivi_al_with_etat_al_filter").prop('checked')) {
            var column = "suivi_al_with_etat_al_filter";
            var table = "";
            var value = 1;
            var params = "";
            filters.push({ column: column, table: table, value: value, params: params })
        }
    }



    suivi_al_dossiers_table.ajax.url(assetBaseUrl + 'dossiers_datatable?referer=suivi&filters=' + JSON.stringify(filters)).load();
}


$("#suivi_al_only_different_etat_filter").change(function () {
    $("#suivi_al_with_etat_al_filter").prop('checked',!$(this).prop('checked'));
    filter_suivi_al_table();
});

$("#suivi_al_with_etat_al_filter").change(function () {
     $("#suivi_al_only_different_etat_filter").prop('checked',!$(this).prop('checked'));
    filter_suivi_al_table();
});

$("#suivi_al_provinces_filter").change(function () {
    suivi_al_refresh_situation_filters('province');
});
$("#suivi_al_cercles_filter").change(function () {
    suivi_al_refresh_situation_filters('cercle');
});
$("#suivi_al_communes_filter").change(function () {
    suivi_al_refresh_situation_filters('commune');
});
$("#suivi_al_douars_filter").change(function () {
    suivi_al_refresh_situation_filters('douar');
});



function suivi_al_fill_situation_filter_cercle(province_id) {
    $("#suivi_al_cercles_filter").empty();
    $("#suivi_al_cercles_filter").append(new Option('Indifferent', 'all'));
    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                $("#suivi_al_cercles_filter").append(new Option(cercle.nom, cercle.id));
            }
        }
        else {
            $("#suivi_al_cercles_filter").append(new Option(cercle.nom, cercle.id));
        }
    });
}

function suivi_al_fill_situation_filter_commune(province_id, cercle_id) {
    $("#suivi_al_communes_filter").empty();
    $("#suivi_al_communes_filter").append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });

    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        $("#suivi_al_communes_filter").append(new Option(commune.nom, commune.id));
                    }
                }
                else {
                    $("#suivi_al_communes_filter").append(new Option(commune.nom, commune.id));
                }
            }
        });
    });

}


function suivi_al_fill_situation_filter_douar(province_id, cercle_id, commune_id) {
    $("#suivi_al_douars_filter").empty();
    $("#suivi_al_douars_filter").append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });

    var filtred_communes = [];
    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        filtred_communes.push(commune);
                    }
                }
                else {
                    filtred_communes.push(commune);
                }
            }
        });
    });

    filtred_communes.forEach(commune => {
        douars.forEach(douar => {
            if (douar.commune_id == commune.id) {
                if (commune_id != 'all') {
                    if (commune.id == commune_id) {
                        $("#suivi_al_douars_filter").append(new Option(douar.nom, douar.id));
                    }
                }
                else {
                    $("#suivi_al_douars_filter").append(new Option(douar.nom, douar.id));
                }
            }
        });
    });

}

function suivi_al_refresh_situation_filters(trigger_source) {
    if (trigger_source == 'province') {
        suivi_al_fill_situation_filter_cercle($("#suivi_al_provinces_filter").val(), 'all');
        suivi_al_fill_situation_filter_commune($("#suivi_al_provinces_filter").val(), 'all');
        suivi_al_fill_situation_filter_douar($("#suivi_al_provinces_filter").val(), 'all', 'all');
    }
    if (trigger_source == 'cercle') {
        var province_id = undefined;

        if ($("#suivi_al_cercles_filter").val() == 'all') {
            suivi_al_refresh_situation_filters('province');
            return;
        }

        cercles.forEach(cercle => {
            if (cercle.id == $("#suivi_al_cercles_filter").val()) {
                province_id = cercle.province_id;
            }
        });

        $("#suivi_al_provinces_filter").val(province_id);
        $('#suivi_al_provinces_filter').trigger('change.select2');

        suivi_al_fill_situation_filter_commune(province_id, $("#suivi_al_cercles_filter").val());
        suivi_al_fill_situation_filter_douar(province_id, $("#suivi_al_cercles_filter").val(), 'all');
    }

    if (trigger_source == 'commune') {
        var province_id = undefined;
        var cercle_id = undefined;

        if ($("#suivi_al_communes_filter").val() == 'all') {
            suivi_al_refresh_situation_filters('cercle');
            return;
        }

        communes.forEach(commune => {
            if (commune.id == $("#suivi_al_communes_filter").val()) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#suivi_al_provinces_filter").val(province_id);
        $('#suivi_al_provinces_filter').trigger('change.select2');

        $("#suivi_al_cercles_filter").val(cercle_id);
        $('#suivi_al_cercles_filter').trigger('change.select2');

        suivi_al_fill_situation_filter_douar(province_id, $("#suivi_al_cercles_filter").val(), $("#suivi_al_communes_filter").val(), 'all');
    }

    if (trigger_source == 'douar') {
        var province_id = undefined;
        var cercle_id = undefined;
        var commune_id = undefined;

        if ($("#suivi_al_douars_filter").val() == 'all') {
            suivi_al_refresh_situation_filters('commune');
            return;
        }

        douars.forEach(douar => {
            if (douar.id == $("#suivi_al_douars_filter").val()) {
                commune_id = douar.commune_id;
            }
        });

        communes.forEach(commune => {
            if (commune.id == commune_id) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#suivi_al_provinces_filter").val(province_id);
        $('#suivi_al_provinces_filter').trigger('change.select2');

        $("#suivi_al_cercles_filter").val(cercle_id);
        $('#suivi_al_cercles_filter').trigger('change.select2');

        $("#suivi_al_communes_filter").val(commune_id);
        $('#suivi_al_communes_filter').trigger('change.select2');


    }
}
