var map = undefined;
var source_initialized = false;
var suivi_par_communes_table = undefined;
var suivi_par_communes_current_document = "RECPTION_FONDATIONS";
var suivi_par_communes_current_document_nom = "Réception des fondations";
var suivi_par_communes_current_data = undefined;

const commune_popup = new maplibregl.Popup({
    closeButton: true,
    closeOnClick: false
});

$(document).ready(function () {
    map = new maplibregl.Map({
        container: 'map',
        style: {
            version: 8,
            sources: {
                osm: {
                    type: 'raster',
                    tiles: ['https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}'],
                    tileSize: 256,
                    attribution: '',
                    maxzoom: 22
                },
            },

            layers: [],

            "glyphs": "https://fonts.openmaptiles.org/{fontstack}/{range}.pbf",
        },

        attributionControl: false,
        center: [-7.629201045575201, 31.028071968372856],
        zoom: 7.4,
        pitch: 0,
        antialias: false,


    });
    map.addControl(new maplibregl.FullscreenControl());
    map.addControl(new maplibregl.NavigationControl());
    map.on('load', function () {
        initdata();
    });
    // var intervalId = window.setInterval(function () {
    //     rSize();
    // }, 100);


    suivi_par_communes_table = $('#suivi_par_communes_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 20,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: true,
        processing: true,
        serverSide: false,
        searching: true,
        scrollX: false,
        ajax: null,
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Suivi par communes-' + current_date.replaceAll("/", "-"),

            },
        ],
        columnDefs: [
            {
                "type": "num",
                "targets": 1,
                className: 'dt-center',
                "render": function (data, type, row) {

                    var value = $(data).filter('b').text();
                    return type === 'sort' ? parseInt(value, 10) : data;
                }
            },
            {
                "type": "num",
                "targets": 2,
                "render": function (data, type, row) {

                    var value = $(data).filter('b').text();
                    return type === 'sort' ? parseInt(value, 10) : data;
                }
            },

            {
                "type": "num",
                "targets": 3,
                "render": function (data, type, row) {

                    var value = $(data).attr('value');

                    return type === 'sort' ? parseFloat(value, 10) : data;
                }
            },
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }


    }).on("xhr.dt", function (e, settings, json, xhr) {

    });

});

$(".suivi_par_communes_table_export_excel").click(function () {
    suivi_par_communes_table.buttons(0).trigger();
});

function initdata() {
    cleanMap();
    init_sources();
    init_layer_communes();

    suivi_par_communes_loadData();
}
$("#suivi_par_communes_type_document_filter").change(function () {
    suivi_par_communes_current_document = $(this).val();

    if (suivi_par_communes_current_document == "RECPTION_FONDATIONS") {
        suivi_par_communes_current_document_nom = "Réception des fondations";
    }
    if (suivi_par_communes_current_document == "RECEPTION_STRUCTURE") {
        suivi_par_communes_current_document_nom = "Réception de la structure";
    }
    if (suivi_par_communes_current_document == "PV_RECEPTION_FINITION") {
        suivi_par_communes_current_document_nom = "Réception du plancher haut RDC";
    }
    if (suivi_par_communes_current_document == "PV_FIN_TRAVAUX") {
        suivi_par_communes_current_document_nom = "Fin des travaux";
    }
    suivi_par_communes_loadData();
});

function suivi_par_communes_loadData() {


    $("#suivi_par_communes_legend_min").text("0");
    $("#suivi_par_communes_legend_max").text("0");
    $.ajax({
        url: assetBaseUrl + "suivi/get_suivi_par_communes/" + suivi_par_communes_current_document,
        type: 'get',
        dataType: 'json',
        success: function (response) {
            update_commune_fill_colors(response.data);
            suivi_par_communes_table.rows().clear().draw();
            suivi_par_communes_current_data = response.data;

            var min = 0;
            var max = 0;
            response.data.forEach(row => {

                var nom_html = `<i style="color:${row.color}" class="fa-solid fa-circle"></i><a class="suivi_par_commune_table_row" id="${row.id}" href="javascript:void();" >${row.nom}</a>`;
                var value_html = `<b >${row.value}</b>`;
                var dossiers_count_html = `<b >${row.dossiers_count}</b>`;
                var progression_html = `<div class="progress" value="${row.progression}"> <div class="progress-bar"  style="width:${row.progression}%"><b style="background:${row.color};color:black">${row.progression}%</b></div> </div> `;
                suivi_par_communes_table.row.add([nom_html, value_html, dossiers_count_html, progression_html]).draw();

                if (row.value > max) {
                    max = row.value;
                }
                if (row.value < min || min == 0) {
                    min = row.value;
                }
            });
            $("#suivi_par_communes_legend_min").text(min);
            $("#suivi_par_communes_legend_max").text(max);
        }
    });
}
 

$("body").on('click', '.suivi_par_commune_table_row', function () {
    var id = $(this).attr('id');

     
    var features = map.queryRenderedFeatures({
        layers: ["communes_fill"],
        filter: ['==', ['get', 'id'], id]
    });

    if (features.length > 0) {
       
        handleDossierMarkerClick(id, turf.centroid(features[0].geometry).geometry.coordinates);
    } else {
        console.log('Feature not found');
    }
  
});

function cleanMap() {

    map.getStyle().layers.forEach(layer => {
        if (layer.type != 'raster') {
            map.removeLayer(layer.id);
        }

    });
    Object.keys(map.getStyle().sources).forEach(elem => {
        if (map.getStyle().sources[elem].type != 'raster') {
            map.removeSource(elem);
        }
    });

    map.listImages().forEach(image => {
        map.removeImage(image);
    });


    map.setTerrain();
}

function init_sources() {

    map.addSource('communes', {
        type: 'geojson',
        data: assetBaseUrl + 'mapping/communes_id_geo_3_wgs.geojson?v=3'
    });
    map.addSource('communes_centers', {
        type: 'geojson',
        data: assetBaseUrl + 'mapping/centres_communes.geojson?v=2'
    });

    map.addSource('provinces', {
        type: 'geojson',
        data: assetBaseUrl + 'mapping/provinces_2.geojson?v=2'
    });

    map.addSource('provinces_lines', {
        type: 'geojson',
        data: assetBaseUrl + 'mapping/lignes_provinces.geojson?v=3'
    });

    map.addSource('provinces_textes', {
        type: 'geojson',
        data: assetBaseUrl + 'mapping/points_provinces.geojson?v=3'
    });

    map.addSource('epicenter', {
        'type': 'geojson',
        'data': {
            'type': 'FeatureCollection',
            'features': [
                {
                    'type': 'Feature',
                    'geometry': {
                        'type': 'Point',
                        'coordinates': [-8.42464073, 31.09927756]
                    }
                }
            ]
        }
    });
    source_initialized = true;
}

function update_commune_fill_colors(data) {

    const updatedColors = {};

    data.forEach(row => {
        updatedColors[row.id] = row.color;
    });


    const dynamicCaseExpression = ['case'];

    for (const [featureId, color] of Object.entries(updatedColors)) {
        dynamicCaseExpression.push(['==', ['get', 'id'], featureId], color);
    }

    dynamicCaseExpression.push('#ffffff'); // Default color

    // Update the layer with the new case expression
    map.setPaintProperty('communes_fill', 'fill-color', dynamicCaseExpression);
}

function init_layer_communes() {




    map.addLayer({
        'id': 'communes_fill',
        'type': 'fill',
        'source': 'communes',
        'paint': {
            'fill-color': '#dddddd',
            'fill-opacity': 0.75,
        }
    });
    map.addLayer({
        'id': 'communes_line',
        'type': 'line',
        'source': 'communes',
        'paint': {
            'line-color': '#969696',
            'line-width': 1,

        }
    });
    map.addLayer({
        'id': 'provinces_line',
        'type': 'line',
        'source': 'provinces',
        'paint': {
            'line-color': '#000000',
            'line-width': 2,

        }
    });

    map.addLayer({
        'id': 'provinces_text_line',
        'type': 'line',
        'source': 'provinces_lines',
        'paint': {
            'line-color': '#000000',
            'line-width': 1,

        }
    });

   

    map.addLayer({
        "id": "provinces_symboles",
        "type": "symbol",
        "source": "provinces_textes",
        "layout": {
            "symbol-placement": "point",
            "text-font": ["Metropolis Semi Bold"],
            "text-field": '{nom}',
            "text-offset": [0, 0],
            "icon-overlap": "always",
            "text-allow-overlap": false,
            "text-size": 12,

        },
        "paint": {
            "text-color": "#138454",
            "text-halo-color": "white",
            "text-halo-width": 1,
            "text-halo-blur": 0
        }
    });

    map.addLayer({
        "id": "communes_symboles",
        "type": "symbol",
        "source": "communes_centers",
        "layout": {
            "symbol-placement": "point",
            "text-font": ["Metropolis Semi Bold"],
            "text-field": '{commune_id_nom_nom}',
            "text-offset": [0, -1],
            "icon-overlap": "always",
            "text-allow-overlap": false,
            "text-size": 11,

        },
        "paint": {
            "text-color": "#000000",
            "text-halo-color": "white",
            "text-halo-width": 1,
            "text-halo-blur": 0
        }
    });

    map.on('click', 'communes_fill', function (e) {


        this.getCanvas().style.cursor = 'pointer';
        const coordinates = e.features[0].geometry.coordinates.slice();
        handleDossierMarkerClick(e.features[0].properties.id, e.lngLat);

    });


    map.addLayer({
        id: 'epicenter-c-layer',
        type: 'circle',
        source: 'epicenter',
        paint: {
            'circle-radius': 5, // Radius of the circle in pixels
            'circle-color': 'white', // Make the circle fill transparent

        }
    });

    map.addLayer({
        id: 'epicenter-r1-layer',
        type: 'circle',
        source: 'epicenter',
        paint: {
            'circle-radius': 15, // Radius of the circle in pixels
            'circle-color': 'transparent', // Make the circle fill transparent
            'circle-stroke-color': 'white', // Color of the circle outline
            'circle-stroke-width': 6, // Width of the circle outline in pixels
            'circle-stroke-opacity': 1
        }
    });

    map.addLayer({
        id: 'epicenter-r2-layer',
        type: 'circle',
        source: 'epicenter',
        paint: {
            'circle-radius': 25, // Radius of the circle in pixels
            'circle-color': 'transparent', // Make the circle fill transparent
            'circle-stroke-color': 'white', // Color of the circle outline
            'circle-stroke-width': 5, // Width of the circle outline in pixels
            'circle-stroke-opacity': 0.8
        }
    });

    map.addLayer({
        id: 'epicenter-r3-layer',
        type: 'circle',
        source: 'epicenter',
        paint: {
            'circle-radius': 35, // Radius of the circle in pixels
            'circle-color': 'transparent', // Make the circle fill transparent
            'circle-stroke-color': 'white', // Color of the circle outline
            'circle-stroke-width': 4, // Width of the circle outline in pixels
            'circle-stroke-opacity': 0.6
        }
    });

    map.addLayer({
        id: 'epicenter-r4-layer',
        type: 'circle',
        source: 'epicenter',
        paint: {
            'circle-radius': 45, // Radius of the circle in pixels
            'circle-color': 'transparent', // Make the circle fill transparent
            'circle-stroke-color': 'white', // Color of the circle outline
            'circle-stroke-width': 5, // Width of the circle outline in pixels
            'circle-stroke-opacity': 0.4
        }
    });

    map.addLayer({
        id: 'epicenter-r5-layer',
        type: 'circle',
        source: 'epicenter',
        paint: {
            'circle-radius': 55, // Radius of the circle in pixels
            'circle-color': 'transparent', // Make the circle fill transparent
            'circle-stroke-color': 'white', // Color of the circle outline
            'circle-stroke-width': 2, // Width of the circle outline in pixels
            'circle-stroke-opacity': 0.2
        }
    });

    var radius_r1 = 15;
    var opacity_r1 = 1;

    function animateRadius_r1() {
        radius_r1 += 0.025;
        opacity_r1 -= 1 / ((25 - 15) / 0.025);

        if (radius_r1 > 25) {
            radius_r1 = 15;
        }
        if (opacity_r1 <= 0) {
            opacity_r1 = 1;
        }
        map.setPaintProperty('epicenter-r1-layer', 'circle-radius', radius_r1);
        if (opacity_r1 >= 0) {
            map.setPaintProperty('epicenter-r1-layer', 'circle-stroke-opacity', opacity_r1);
        }
        requestAnimationFrame(animateRadius_r1);
    }

    var radius_r2 = 25;
    var opacity_r2 = 0.8;

    function animateRadius_r2() {
        radius_r2 += 0.025;
        opacity_r2 -= 0.8 / 400;

        if (radius_r2 > 35) {
            radius_r2 = 25;
        }
        if (opacity_r2 <= 0) {
            opacity_r2 = 0.8;
        }
        map.setPaintProperty('epicenter-r2-layer', 'circle-radius', radius_r2);
        if (opacity_r2 >= 0) {
            map.setPaintProperty('epicenter-r2-layer', 'circle-stroke-opacity', opacity_r2);
        }
        requestAnimationFrame(animateRadius_r2);
    }


    var radius_r3 = 35;
    var opacity_r3 = 0.6;

    function animateRadius_r3() {
        radius_r3 += 0.025;
        opacity_r3 -= 0.6 / 400;

        if (radius_r3 > 45) {
            radius_r3 = 35;
        }
        if (opacity_r3 <= 0) {
            opacity_r3 = 0.6;
        }
        map.setPaintProperty('epicenter-r3-layer', 'circle-radius', radius_r3);
        if (opacity_r3 >= 0) {
            map.setPaintProperty('epicenter-r3-layer', 'circle-stroke-opacity', opacity_r3);
        }
        requestAnimationFrame(animateRadius_r3);
    }

    var radius_r4 = 45;
    var opacity_r4 = 0.4;

    function animateRadius_r4() {
        radius_r4 += 0.025;
        opacity_r4 -= 0.4 / 400;

        if (radius_r4 > 55) {
            radius_r4 = 45;
        }
        if (opacity_r4 <= 0) {
            opacity_r4 = 0.4;
        }
        map.setPaintProperty('epicenter-r4-layer', 'circle-radius', radius_r4);
        if (opacity_r4 >= 0) {
            map.setPaintProperty('epicenter-r4-layer', 'circle-stroke-opacity', opacity_r4);
        }
        requestAnimationFrame(animateRadius_r4);
    }

    var radius_r5 = 55;
    var opacity_r5 = 0.4;

    function animateRadius_r5() {
        radius_r5 += 0.025;
        opacity_r5 -= 0.2 / 400;

        if (radius_r5 > 65) {
            radius_r5 = 55;
        }
        if (opacity_r5 <= 0) {
            opacity_r5 = 0.2;
        }
        map.setPaintProperty('epicenter-r5-layer', 'circle-radius', radius_r5);
        if (opacity_r4 >= 0) {
            map.setPaintProperty('epicenter-r5-layer', 'circle-stroke-opacity', opacity_r5);
        }
        requestAnimationFrame(animateRadius_r5);
    }

    animateRadius_r1();
    animateRadius_r2();
    animateRadius_r3();
    animateRadius_r4();
    animateRadius_r5();
}




function handleDossierMarkerClick(id, coordinates) {

    suivi_par_communes_current_data.forEach(row => {
        if (row.id == id) {
            var html = `<div >   
                            <div style="background: ${row.color}; border-radius: 50%; padding: 0px; width: 64px; height: 64px; position: absolute; z-index: 99; top: -32px; left: -32px; border: 2px #4f4f4f solid;">
                                <b style="font-family: 'Roboto'; width: 100%; height: 100%; display: block; font-size: 0.9rem; color: black; margin: auto; text-align: center; top: 14px; position: relative;">
                                            ${row.value}
                                            <b style="border-top: 1px dashed #2b2b2b;font-family: 'Roboto'; font-size: 0.70rem; color: #3c3c3c; display: block; width: 100%;">${row.progression} %</b>
                                </b>
              
                            </div>  
                            <div class="row">         
                                <div class="col-12 dossier_popup_title_div " style="border-bottom: 1px #323232 dashed;background:white;border-radius:8px 8px 0px 0px;padding:0px">
                                    <b style="margin: 8px 0px;font-family: 'Roboto'; text-align: center; width: 100%; display: block; font-size: 0.9rem; color: black;">${suivi_par_communes_current_document_nom}</b>
                                </div>  
                            </div>  
                              

                             <div class="row mt-2">           
                                <div class="col-12">
                                    <span style="font-family:  'Roboto';text-align:center"><i class="fa-solid fa-location-dot"></i>&nbsp Commune : <b>${row.nom}</b></span>
                                </div>           
                            </div> 

                            <div class="row mt-2">           
                                <div class="col-12">
                                    <span style="font-family:  'Roboto';text-align:center"><i class="fa-solid fa-location-dot"></i>&nbsp Province : <b>${row.nom_province}</b></span>
                                </div>           
                            </div> 

                           
                            <hr>
                            <div class="row mt-2">           
                                <div class="col-12">
                                    <span style="font-family: 'Roboto';text-align:center"><i class="fa-solid fa-folder-closed"></i>&nbspNombre des Dossiers : <b>${row.dossiers_count}</b></span>
                                </div>           
                            </div> 

                      
                           
                        </div>`;

            commune_popup.setLngLat(coordinates).setHTML(html).addTo(map);

            commune_popup.getElement().style.width = '340px';
        }

    });


    // $.ajax({
    //     url: assetBaseUrl + "dossiers/data/" + id,
    //     type: 'get',
    //     dataType: 'json',
    //     success: function (response) {
    //         $(".dossier_popup_loader").css('opacity', '0');

    //         var Petitionnaires_html = "";
    //         response.demande.petitionnaires.forEach(petitionnaire => {
    //             Petitionnaires_html += `<br><b style="margin-left:8px">◈ ${petitionnaire.nom} ${petitionnaire.prenom}</b><br>`;
    //         });
    //         $(".dossier_popup_data_petitionnaires").html(Petitionnaires_html);

    //         $(".dossier_popup_data_province").text(response.douar.commune.cercle.province.nom);
    //         $(".dossier_popup_data_commune").text(response.douar.commune.nom);
    //         $(".dossier_popup_data_douar").text(response.douar.nom);
    //         $(".dossier_popup_data_date_demande").text(response.demande.format_created_at);
    //         $(".dossier_popup_data_date_dossier").text(response.format_created_at);
    //         $(".dossier_popup_numero").text(response.numero);
    //         $(".dossier_popup_title_div").css('background', response.etat_avancement_color);
    //         $(".dossier_popup_data_etat_avancement").text();
    //         $(".dossier_popup_data_architecte").text();
    //         $(".dossier_popup_url").attr('href', assetBaseUrl + 'dossiers/show/' + id);


    //     }
    // });
}