var detail_info_genarales_map = undefined;
var affectation_urbanistique_map = undefined;
var plle_style = {
    fillColor: '#29ABE2',
    weight: 2,
    opacity: 1,
    color: 'white',
    dashArray: '3',
    fillOpacity: 0.7
}

var googleSat = L.tileLayer('https://www.google.com/maps/vt?lyrs=s@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,
});

var googlehybrid = L.tileLayer('https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,

});

var googlemap = L.tileLayer('https://www.google.com/maps/vt?lyrs=m@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,
});


$(document).ready(function () {

    detail_info_genarales_map = new L.Map('detail_info_genarales_map', {
        zoomControl: false,
        center: new L.LatLng(32.62087018318113, -6.262207031250001),
        zoom: 6,
        editable: true,
        drawControl: true,
        preferCanvas: true,
        attributionControl: false,
        fullscreenControl: true,

    });
    L.Control.ZoomExtent = L.Control.extend(
        {
            options:
            {
                position: 'topleft',
            },
            onAdd: function (map) {
                var controlDiv = L.DomUtil.create('div', 'leaflet-draw-toolbar leaflet-bar');
              
                L.DomEvent
                    .addListener(controlDiv, 'click', L.DomEvent.stopPropagation)
                    .addListener(controlDiv, 'click', L.DomEvent.preventDefault)
                    .addListener(controlDiv, 'click', function () {
                        
                        var group = new L.featureGroup();
                        detail_info_genarales_map.eachLayer(function(layer)
                        {
                            if(layer instanceof L.Path)
                            {
                                group.addLayer(layer);
                            }
                           
                        });
                        detail_info_genarales_map.fitBounds(group.getBounds());
                    });
 

                var controlUI = L.DomUtil.create('a', 'leaflet-draw-edit-remove fa-solid fa-magnifying-glass-location', controlDiv);
                controlUI.title = 'Zoom étendu';
                controlUI.href = '#';
                return controlDiv;
            }
        });
        
    var ZoomExtentControl = new L.Control.ZoomExtent();
    detail_info_genarales_map.addControl(ZoomExtentControl);

    googlehybrid.addTo(detail_info_genarales_map);

    var layers_group = new L.featureGroup();
    var geojson = L.geoJSON(JSON.parse(terrain.geojson));
    geojson.setStyle(plle_style);
    geojson.addTo(detail_info_genarales_map);
    layers_group.addLayer(geojson);
    detail_info_genarales_map.fitBounds(layers_group.getBounds());



    //affectation urbanistiques
    var googlehybrid_affectation = L.tileLayer('https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,
    });


    affectation_urbanistique_map = new L.Map('affectation_urbanistique_map', {
        zoomControl: false,
        center: new L.LatLng(32.62087018318113, -6.262207031250001),
        zoom: 6,
        editable: true,
        drawControl: true,
        preferCanvas: true,
        attributionControl: false,
        fullscreenControl: true,

    });
    L.Control.ZoomExtent = L.Control.extend(
        {
            options:
            {
                position: 'topleft',
            },
            onAdd: function (map) {
                var controlDiv = L.DomUtil.create('div', 'leaflet-draw-toolbar leaflet-bar');
              
                L.DomEvent
                    .addListener(controlDiv, 'click', L.DomEvent.stopPropagation)
                    .addListener(controlDiv, 'click', L.DomEvent.preventDefault)
                    .addListener(controlDiv, 'click', function () {
                        
                        var group = new L.featureGroup();
                        affectation_urbanistique_map.eachLayer(function(layer)
                        {
                            if(layer instanceof L.Path)
                            {
                                group.addLayer(layer);
                            }
                           
                        });
                        affectation_urbanistique_map.fitBounds(group.getBounds());
                    });
 

                var controlUI = L.DomUtil.create('a', 'leaflet-draw-edit-remove fa-solid fa-magnifying-glass-location', controlDiv);
                controlUI.title = 'Zoom étendu';
                controlUI.href = '#';
                return controlDiv;
            }
        });
        
    var ZoomExtentControl = new L.Control.ZoomExtent();
    affectation_urbanistique_map.addControl(ZoomExtentControl);

    googlehybrid_affectation.addTo(affectation_urbanistique_map);

    var layers_group = new L.featureGroup();
    var terrain_geojson = L.geoJSON(JSON.parse(terrain.geojson));
    terrain_geojson.setStyle(plle_style);
    terrain_geojson.addTo(affectation_urbanistique_map);
    layers_group.addLayer(terrain_geojson);

    
    if (zones_pa && zones_pa.length > 0) {
        zones_pa.forEach(function(zone_pa) {
            if (zone_pa.geojson) {
                try {
                    // Check if geojson is already an object or needs parsing
                    var geojsonData = typeof zone_pa.geojson === 'string' ? 
                        JSON.parse(zone_pa.geojson) : zone_pa.geojson;
                    var zone_layer = L.geoJSON(geojsonData);
                    
                    zone_layer.setStyle({
                        color: zone_pa.color || "#3388ff",
                        weight: 2,
                        opacity: 0.8,
                        fillOpacity: 0.3,
                        fillColor: zone_pa.color || "#3388ff"
                    });
                    
                    // Add popup with zone name
                    zone_layer.bindPopup('<b>' + zone_pa.nom + '</b>');
                    
                    zone_layer.addTo(affectation_urbanistique_map);
                    layers_group.addLayer(zone_layer);
                } catch (error) {
                    console.error('Error parsing GeoJSON for zone_pa ID ' + zone_pa.id + ':', error);
                    console.log('Invalid GeoJSON:', zone_pa.geojson);
                }
            }
        });
    }
   

    affectation_urbanistique_map.fitBounds(terrain_geojson.getBounds());




});