var terrains_table = undefined;
var last_duplicated_cin_error_list = [];
var last_wrong_cin_error_list = [];


$(document).ready(function () {
    terrains_table = $('#terrains_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'terrains_datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Terrains-' + current_date.replaceAll("/", "-"),
                "action": newexportaction,

            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1,2,3,4,5] },
            { width: "150px", targets: [5] }
        ],
        columns: [
             {
                data: 'article',
            },
            {
                data: 'ref',
            },
            {
                data: 'surface',
            },
            {
                data: 'statut_foncier',
            },
          
            {
                data: 'adresse',
            },
            {
                data: 'proprietaires',
            },
            {
                data: 'zones',
            },
            {
                data: 'type',
            },
            {
                data: 'declare',
            },
            {
                data: 'liquidation',
            },
         
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }


    }).on("xhr.dt", function (e, settings, json, xhr) {

        $("#dt_dossiers_count").text(json.recordsFiltered);
    });
    terrains_table.on('draw', function () {
        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });
    })

    $('#filter_date').daterangepicker({
        startDate: (new Date(new Date().getFullYear(), 0, 1)).toLocaleDateString('fr-FR'),
        endDate: '31/12/2023',
        applyButtonClasses: 'btn-success',
        cancelButtonClasses: 'btn-danger',
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Accepter",
            cancelLabel: "Annuler",
        }
    });

});

$(function () {
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        localStorage.setItem('lastTab', $(this).attr('href'));

        if ($(this).attr('href') == "#tout_tab") {
            $("#create_btn").addClass('hidden');
            $("#import_btn").addClass('hidden');

            $("#create_enq_btn").addClass('hidden');
        }
        if ($(this).attr('href') == "#terrains_taxables_tab") {
            $("#create_btn").removeClass('hidden');
            $("#import_btn").removeClass('hidden');

            $("#create_enq_btn").addClass('hidden');
        }

        if ($(this).attr('href') == "#terrains_non_taxables_tab") {
            $("#create_btn").removeClass('hidden');
            $("#import_btn").removeClass('hidden');

            $("#create_enq_btn").addClass('hidden');
        }


        if ($(this).attr('href') == "#exoneration_temporaire_tab") {
            $("#create_btn").removeClass('hidden');
            $("#import_btn").removeClass('hidden');

            $("#create_enq_btn").addClass('hidden');
        }

        if ($(this).attr('href') == "#exoneration_permanente_tab") {
            $("#create_btn").removeClass('hidden');
            $("#import_btn").removeClass('hidden');

            $("#create_enq_btn").addClass('hidden');
        }

   
        filter_tab_index_table();
    });
    var lastTab = localStorage.getItem('lastTab');
    if (lastTab) {
        $('[href="' + lastTab + '"]').tab('show');
        if (lastTab == "#tout_tab") {
            $("#create_btn").addClass('hidden');
            $("#import_btn").addClass('hidden');

            $("#create_enq_btn").addClass('hidden');
        }
        if (lastTab == "#terrains_taxables_tab") {
            $("#create_btn").removeClass('hidden');
            $("#import_btn").removeClass('hidden');

            $("#create_enq_btn").addClass('hidden');
        }

        if (lastTab == "#terrains_non_taxables_tab") {
            $("#create_btn").removeClass('hidden');
            $("#import_btn").removeClass('hidden');

            $("#create_enq_btn").addClass('hidden');
        }

        if (lastTab == "#exoneration_temporaire_tab") {
            $("#create_btn").removeClass('hidden');
            $("#import_btn").removeClass('hidden');

            $("#create_enq_btn").addClass('hidden');
        }

        if (lastTab == "#exoneration_permanente_tab") {
            $("#create_btn").removeClass('hidden');
            $("#import_btn").removeClass('hidden');

            $("#create_enq_btn").addClass('hidden');
        }

    }
});


$("#create_btn").click(function () {
    window.location.href = "terrains/show/create";
});

function filter_tab_index_table() {
    var filters = [];

    var lastTab = localStorage.getItem('lastTab');

    $(".dt_filter").each(function () {
        var column = $(this).attr('column');
        var table = $(this).attr('table');
        var value = $(this).val();
        var params = $(this).attr('params');
        if (value != 'all' && value.trim().length > 0) {
            filters.push({ column: column, table: table, value: value, params: params });
        }
    });


    // if (lastTab == "#terrains_taxables_tab") {
    //     var column = "type";
    //     var table = "terrains";
    //     var value = "Terrains taxables";
    //     filters.push({ column: column, table: table, value: value });
    // }

    // if (lastTab == "#terrains_non_taxables_tab") {
    //     var column = "type";
    //     var table = "terrains";
    //     var value = "Terrains non taxables";
    //     filters.push({ column: column, table: table, value: value });
    // }

    // if (lastTab == "#exoneration_temporaire_tab") {
    //     var column = "type";
    //     var table = "terrains";
    //     var value = "Exonerations temporaires";
    //     filters.push({ column: column, table: table, value: value });
    // }

    // if (lastTab == "#exoneration_permanente_tab") {
    //     var column = "type";
    //     var table = "terrains";
    //     var value = "Exonerations permanentes";
    //     filters.push({ column: column, table: table, value: value });
    // }


    terrains_table.ajax.url(assetBaseUrl + 'terrains_datatable' + '?filters=' + JSON.stringify(filters)).load();
}

$(".dt_filter").change(function () {
    filter_tab_index_table();
});

$(".dt_filter").keyup(function () {
    filter_tab_index_table();
});

$(".custom_filter").change(function () {
    filter_tab_index_table();
});



$(".terrains_table_export_excel").click(function () {
    terrains_table.buttons(0).trigger();
});


