document.addEventListener("DOMContentLoaded", function () {
    const checkboxes = document.querySelectorAll(".sanction-checkbox");
    const montantSanctionsInput = document.getElementById("montant_sanctions");
    const montantTotalInput = document.getElementById("montant_total");
    const montantInitial = parseFloat(document.getElementById("montant_initial").value.replace(/[^\d.-]/g, ""));
    function recalculateTotals() {
        let totalSanctions = 0;
        checkboxes.forEach(checkbox => {
            const amount = parseFloat(checkbox.getAttribute("data-amount")) || 0;
            if (checkbox.checked) {
                totalSanctions += amount;
            }
        });
        montantSanctionsInput.value = `${totalSanctions.toFixed(2)} MAD`;
        montantTotalInput.value = `${(montantInitial + totalSanctions).toFixed(2)} MAD`;
    }
    checkboxes.forEach(checkbox => {
        checkbox.addEventListener("change", recalculateTotals);
    });
    recalculateTotals();
});



document.querySelector('.generate_liquidation').addEventListener('click', function (event) {
    event.preventDefault();
    
    // Get all sanctions (both checked and unchecked)
    const allSanctions = Array.from(document.querySelectorAll('.sanction-checkbox')).map(cb => ({
        year: cb.dataset.year,
        name: cb.parentElement.textContent.trim(),
        amount: cb.checked ? cb.dataset.amount : '0',
        checked: cb.checked
    }));
    
    const groupedSanctions = {};
    
    allSanctions.forEach(sanction => {
        const year = sanction.year;
        if (!groupedSanctions[year]) {
            // Find the TNB amount for this specific year
            let tnbAmount = '0';
            
            // Find all checkboxes for this year to get the TNB amount from the same row group
            const yearCheckboxes = document.querySelectorAll(`.sanction-checkbox[data-year="${year}"]`);
            if (yearCheckboxes.length > 0) {
                // Get the first checkbox of this year and traverse up to find the TNB row
                const firstCheckbox = yearCheckboxes[0];
                const currentRow = firstCheckbox.closest('tr');
                let tnbRow = currentRow.previousElementSibling;
                
                // The TNB row should be the previous sibling with the montant-tnb class
                while (tnbRow && !tnbRow.querySelector('.montant-tnb')) {
                    tnbRow = tnbRow.previousElementSibling;
                }
                
                if (tnbRow) {
                    const tnbElement = tnbRow.querySelector('.montant-tnb');
                    if (tnbElement) {
                        tnbAmount = tnbElement.dataset.amount;
                    }
                }
            }
            
            groupedSanctions[year] = {
                year: year,
                "Montant principal": document.querySelector(`#montant_initial`).value.replace(' MAD', '').trim(),
                "Montant de la TNB": tnbAmount,
                sanctions: [{}]
            };
        }

        groupedSanctions[year].sanctions[0][sanction.name] = sanction.amount;
        console.log(groupedSanctions);
    });
    
    // Convert grouped sanctions to an array
    const formattedSanctions = Object.values(groupedSanctions);
    
    // Populate form inputs with formatted data
    document.getElementById('sanctions_input').value = JSON.stringify(formattedSanctions);
    document.getElementById('montant_initial_input').value = document.getElementById('montant_initial').value.replace(' MAD', '').trim();
    document.getElementById('montant_sanctions_input').value = document.getElementById('montant_sanctions').value.replace(' MAD', '').trim();
    document.getElementById('montant_total_input').value = document.getElementById('montant_total').value.replace(' MAD', '').trim();
    
    console.log(document.getElementById('sanctions_input').value);
    
    // Submit the form to open in a new tab
    event.target.closest('form').submit();
});