$("#proprietaire_modal_documents_add_btn").click(function () {
  $("#proprietaire_document_modal").modal("show");
});

$("#upload_document_proprietaire_form").submit(function (event) {
  event.preventDefault();
  var formData = new FormData(this);
  $.ajax({
    url: assetBaseUrl + "proprietaire/store_proprietaire_document",
    type: "POST",
    dataType: "json",
    data: formData,
    processData: false,
    contentType: false,
    success: function (response) {
      proprietaire_modal_documents_table_add(response);
      $("#proprietaire_document_modal").modal("hide");
    },
    error: function (xhr, status, error) {
      console.log(xhr.responseText);
    },
  });
});

function proprietaire_modal_documents_table_add(proprietaire_doc) {
  var nom_html = `<input  type="checkbox" class="proprietaire_doc_cb" style="vertical-align: middle;position: relative;">&nbsp<a filename="${proprietaire_doc.filename}" item_id="${proprietaire_doc.id}" href="javascript:;" class="proprietaire_doc_a">${proprietaire_doc.nom}</a>`;
  var taille_html = "<span> " + proprietaire_doc.file_size_formated + "</span>";
  var type_html = "<span> Fichier " + proprietaire_doc.file_type + "</span>";
  var date_html = "<span> " + proprietaire_doc.created_at_formated + "</span>";

  proprietaire_modal_documents_table.row
    .add([nom_html, taille_html, type_html, date_html, proprietaire_doc])
    .draw();
}

$("#proprietaire_form").submit(function (e) {
    e.preventDefault();

    const quote_part = parseFloat($("#proprietaire_modal_quote_part").val());
    if (quote_part <= 0 || quote_part > 1) {
        gl_alert("error", "ETNB", `La quote part doit être entre 0 et 1.`);
        return;
    }

    // Create the propriétaire object
    var proprietaire = {
        id: null,
        type: $("#proprietaire_modal_type").val(),
        nom: $("#proprietaire_modal_nom").val(),
        prenom: $("#proprietaire_modal_prenom").val(),
        cine: $("#proprietaire_modal_cine").val(),
        rc: $("#proprietaire_modal_rc").val(),
        ville_rc: $("#proprietaire_modal_ville_rc").val(),
        quote_part: $("#proprietaire_modal_quote_part").val(),
    };

    if (proprietaires_table_edit_row) {
        // Update the existing row
        const rowDataToUpdate = [
            `<input type="checkbox" item_id="${proprietaire.id}" class="proprietaire_cb" style="vertical-align: middle;position: relative;">&nbsp;
                <a item_id="${proprietaire.id}" href="javascript:;" class="proprietaire_a">
                    ${proprietaire.nom ?? ""} ${proprietaire.prenom ?? ""}
                </a>`,
            proprietaire.type === "physique"
                ? `<span>${proprietaire.cine ?? "-"}</span>`
                : `<span>${proprietaire.rc ?? "-"} ${proprietaire.ville_rc ?? ""}</span>`,
            `<span>${proprietaire.adresse ?? "-"}</span>`,
            `<span class="quote-part-cell">${parseFloat(proprietaire.quote_part)}</span>`,
            proprietaire, // Keep the raw data for further updates
        ];

        // Update the row data in the DataTable
        proprietaires_table.row(proprietaires_table_edit_row).data(rowDataToUpdate).draw(false);

        // Reset the edit tracking variable
        proprietaires_table_edit_row = null;
    } else {
        // Add a new row since no row is being edited
        proprietaires_add(proprietaire);
    }

    // Hide the modal
    $("#proprietaire_modal").modal("hide");
});


// Event listener to handle editing
$("body").on("click", ".proprietaire_a", function () {
    // Set the global variable to track the row being edited
    proprietaires_table_edit_row = $(this).closest("tr");
    // Retrieve the data from the selected row
    var data = proprietaires_table.row(proprietaires_table_edit_row).data();
    data = data[data.length - 1];
    // Populate the modal form with the data
    $("#proprietaire_modal_nom").val(data.nom);
    if (data.type === "physique") {
        $(".physique-fields").show();
        $(".morale-fields").hide();
        $("#proprietaire_modal_prenom").val(data.prenom);
        $("#proprietaire_modal_cine").val(data.cine);
    } else if (data.type === "morale") {
        $(".morale-fields").show();
        $(".physique-fields").hide();
        $("#proprietaire_modal_rc").val(data.rc);
        $("#proprietaire_modal_ville_rc").val(data.ville_rc);
    }
    const quotePartValue = data.pivot?.quote_part ?? data.quote_part;
    $("#proprietaire_modal_quote_part").val(quotePartValue);
    // Show the modal for editing
    $("#proprietaire_modal").modal("show");
});

function proprietaires_add(proprietaire) {

    console.log('proprietaires_add');
    console.log(proprietaire);
    // Generate HTML for the columns
    var nom_html = `<input type="checkbox" item_id="${proprietaire.id}" class="proprietaire_cb" style="vertical-align: middle;position: relative;">&nbsp;
        <a item_id="${proprietaire.id}" href="javascript:;" class="proprietaire_a">
            ${proprietaire.nom ?? ""} ${proprietaire.prenom ?? ""}
        </a>`;

    let cin_or_rc_html = "-";
    if (proprietaire.type === "physique") {
        cin_or_rc_html = `<span>${proprietaire.cine ?? "-"}</span>`;
    } else if (proprietaire.type === "morale") {
        const rc = proprietaire.rc ?? "-";
        const ville = proprietaire.ville ?? "";
        cin_or_rc_html = `<span>${rc} ${ville}</span>`;
    }

    var adresse_html = `<span>${proprietaire.adresse ?? "-"}</span>`;
    var quote_part_html = `<span class="quote-part-cell">${
        proprietaire.pivot ? parseFloat(proprietaire.pivot.quote_part) : parseFloat(proprietaire.quote_part) ?? 0
    }</span>`;

    // Handle Add or Edit Row
    if (proprietaires_table_edit_row == undefined) {
        // Add a new row
        proprietaires_table.row.add([
            nom_html,
            cin_or_rc_html,
            adresse_html,
            quote_part_html,
            proprietaire,
        ]).draw();
    } else {
        // Edit the existing row
        proprietaires_table.row(proprietaires_table_edit_row).data([
            nom_html,
            cin_or_rc_html,
            adresse_html,
            quote_part_html,
            proprietaire,
        ]).draw();

        // Reset edit row tracking
        proprietaires_table_edit_row = null;
    }
}

$("body").on("click", ".proprietaire_a", function () {
  document.getElementById("proprietaire_form").reset();
  proprietaires_table_edit_row = $(this).closest("tr");
  var data = proprietaires_table.rows(proprietaires_table_edit_row).data()[0];
  data = data[data.length - 1];
  console.log(data);

  $("#proprietaire_modal_nom").val(data.nom);
  if (data.type === "physique") {
    $(".physique-fields").show();
    $(".morale-fields").hide();

    $("#proprietaire_modal_prenom").val(data.prenom);
    $("#proprietaire_modal_cine").val(data.cine);
  } else if (data.type === "morale") {
    $(".morale-fields").show();
    $(".physique-fields").hide();

    $("#proprietaire_modal_rc").val(data.rc);
    $("#proprietaire_modal_ville_rc").val(data.ville_rc);
  }

  const quotePartValue = data.pivot ? data.pivot.quote_part : data.quote_part;
  $("#proprietaire_modal_quote_part").val(quotePartValue ?? "-");
  $("#proprietaire_modal").modal("show");
});
