var zones_table = undefined;
var map = undefined;

$(document).ready(function () {
    zones_table = $('#zones_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'zones_datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Terrains-' + current_date.replaceAll("/", "-"),
                "action": newexportaction,

            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2] },

        ],
        columns: [
            {
                data: 'nom',
            },
            {
                data: 'tarif',
            },
            {
                data: 'annee',
            },


        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }


    }).on("xhr.dt", function (e, settings, json, xhr) {


    });
    zones_table.on('draw', function () {
        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });
    })

    map = new maplibregl.Map({
        container: 'map',
        style: {
            version: 8,
            sources: {
                osm: {
                    type: 'raster',
                    tiles: ['https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}'],
                    tileSize: 256,
                    attribution: '',
                    maxzoom: 22
                },
            },

            layers: [{
                id: 'osm',
                type: 'raster',
                source: 'osm'
            },],

            "glyphs": "https://fonts.openmaptiles.org/{fontstack}/{range}.pbf",
        },

        attributionControl: false,
        center: [-5.3288743638643155, 35.6932342419659],
        zoom: 13.25,
        pitch: 0,
        antialias: false,


    });

    map.on('load', function () {

        filter_zones_table();
        loadZonesDecision();
        loadZones();
        loadTerrains();
    });
});


$(".dt_filter").change(function () {

    map.getStyle().layers.forEach(layer => {
        if (layer.type != 'raster') {
            map.removeLayer(layer.id);
        }

    });
    Object.keys(map.getStyle().sources).forEach(elem => {
        if (map.getStyle().sources[elem].type != 'raster') {
            map.removeSource(elem);
        }
    });

    filter_zones_table();
    loadZonesDecision();
    loadZones();
    loadTerrains();

});

function loadTerrains() {


    $.ajax({
        type: "GET",
        dataType: 'json',

        url: assetBaseUrl + `terrains/getAllTerrains`,
        success: function (res) {

            var terrains_features = [];
            res.terrains.forEach(element => {
                var geometry = typeof element.geojson === 'string' ? JSON.parse(element.geojson) : element.geojson;

                var feature = {
                    type: "Feature",
                    properties: {
                        id: element.id,
                        fill: "#ffffff",
                        ref: element.ref
                    },
                    geometry: geometry
                };

                terrains_features.push(feature);
            });

            terrains_geojson = {
                "type": "FeatureCollection",
                'features': terrains_features,
            };

            map.addSource('terrains', {
                type: 'geojson',
                data: terrains_geojson
            });

            map.addLayer({
                'id': 'terrains_fill',
                'type': 'fill',
                'source': 'terrains',
                'paint': {
                    'fill-color': ['get', 'fill'],
                    'fill-opacity': 0.45,
                }
            });

            map.addLayer({
                'id': 'terrains_line',
                'type': 'line',
                'source': 'terrains',
                'paint': {
                    'line-color': "#000",
                    'line-width': 2,
                }
            });

            map.addLayer({
                "id": "terrains_symboles",
                "type": "symbol",
                "source": "terrains",
                "layout": {
                    "symbol-placement": "point",
                    "text-font": ["Metropolis Semi Bold"],
                    "text-field": '{ref}',
                    "text-offset": [0, 0],
                    "icon-overlap": "always",
                    "text-allow-overlap": false,
                    "text-size": 11

                },
                "paint": {
                    "text-color": "#cacacaff",
                    "text-halo-color": "black",
                    "text-halo-width": 1,
                    "text-halo-blur": 0
                }
            });


        },
        error: function (xhr, status, error) {

        }
    });
}

function loadZones() {
    var annee = $("#annee_filter").val();
    $.ajax({
        type: "GET",
        dataType: 'json',

        url: assetBaseUrl + `zoning/getZones?annee=${annee}`,
        success: function (res) {

            var zones_features = [];
            res.forEach(element => {
                var geometry = typeof element.geojson === 'string' ? JSON.parse(element.geojson) : element.geojson;

                var feature = {
                    type: "Feature",
                    properties: {
                        id: element.id,
                        fill: element.fill_color,
                        nom: element.nom,
                        tarif: element.tarif
                    },
                    geometry: geometry
                };

                zones_features.push(feature);
            });

            zones_geojson = {
                "type": "FeatureCollection",
                'features': zones_features,
            };

            map.addSource('zones', {
                type: 'geojson',
                data: zones_geojson
            });

            var zones_centroid_features = [];

            zones_features.forEach(feature => {
                // Calculate centroid
                var centroid = turf.centroid(feature);

                // Copy relevant properties
                centroid.properties = {
                    id: feature.properties.id,
                    nom: feature.properties.nom,
                    tarif: feature.properties.tarif,
                    fill: feature.properties.fill
                };

                zones_centroid_features.push(centroid);
            });

            // Build centroid GeoJSON
            var zones_centroid_geojson = {
                type: "FeatureCollection",
                features: zones_centroid_features
            };

            // Add centroid layer to MapLibre (optional)
            map.addSource('zones_centroids', {
                type: 'geojson',
                data: zones_centroid_geojson
            });

            map.addLayer({
                'id': 'zones_fill',
                'type': 'fill',
                'source': 'zones',
                'paint': {
                    'fill-color': ['get', 'fill'],
                    'fill-opacity': 0.45,
                }
            });

            map.addLayer({
                'id': 'zones_line',
                'type': 'line',
                'source': 'zones',
                'paint': {
                    'line-color': ['get', 'fill'],
                    'line-width': 2,
                }
            });

            map.addLayer({
                "id": "zones_symboles",
                "type": "symbol",
                "source": "zones_centroids",
                "layout": {
                    "symbol-placement": "point",
                    "text-font": ["Metropolis Semi Bold"],
                    "text-field": '{nom}\n{tarif} Dhs',
                    "text-offset": [0, 0],
                    "icon-overlap": "always",
                    "text-allow-overlap": true,
                    "text-size": 13,

                },
                "paint": {
                    "text-color": "#ffff00",
                    "text-halo-color": "black",
                    "text-halo-width": 1,
                    "text-halo-blur": 0
                }
            });


        },
        error: function (xhr, status, error) {

        }
    });
}

function getDistinctRandomColor() {
    // store colors between calls
    if (!getDistinctRandomColor.colors) {
        getDistinctRandomColor.colors = [];
    }

    // refill when empty
    if (getDistinctRandomColor.colors.length === 0) {
        const generated = new Set();
        while (generated.size < 100) { // 100 distinct colors
            generated.add(`#${Math.floor(Math.random() * 0xFFFFFF)
                .toString(16)
                .padStart(6, '0')}`);
        }
        getDistinctRandomColor.colors = Array.from(generated);
    }

    // pick & remove one
    const index = Math.floor(Math.random() * getDistinctRandomColor.colors.length);
    return getDistinctRandomColor.colors.splice(index, 1)[0];
}

function loadZonesDecision() {

    var annee = $("#annee_filter").val();

    $.ajax({
        url: assetBaseUrl + `zoning/getZonesDcision?annee=${annee}`,
        type: "GET",
        dataType: "json",

        success: function (response) {
            $("#decision_date").text('Décision importée le ' + response.formated_created_at);
            $("#decision_download").attr('file_id', response.id);
            $("#decision_download").removeAttr('disabled');
            $("#decision_date").css('color', '#0053ae');
        },
        error: function (xhr, status, error) {
            $("#decision_date").text("Aucun fichier importé ");
            $("#decision_download").attr('disabled', 'disabled');
            $("#decision_date").css('color', '#494949ff');
        },
    });
}

function filter_zones_table() {
    var filters = [];

    filters.push({ column: 'annee', table: '', value: $("#annee_filter").val(), params: '' });
    zones_table.ajax.url(assetBaseUrl + 'zones_datatable' + '?filters=' + JSON.stringify(filters)).load();
};


$("#decision_download").click(function () {
    downloadFile(assetBaseUrl + "zoning/file/" + $(this).attr("file_id"));
});