@extends('layouts.app')
@section('added_css')
@endsection
@section('content')
<div style="padding-top: 16px;margin-left: 8px;">

    <ul class="nav nav-tabs" role="tablist" aria-orientation="vertical">
        @if(Auth::user()->has_role("Observateur,Administrateur,GU,Chef du projet"))
        <li class="nav-item">
            <a class="nav-link active" id="douars_tab" data-toggle="tab" data-target="#douars_nav" href="#douars_tab" role="tab" aria-controls="douars_nav" aria-selected="true"><i class="fa-solid fa-location-dot"></i>&nbspArrondissements</a>
        </li>
        @endif       
        @if(Auth::user()->has_role("Administrateur,GU,Chef du projet,Observateur") )
        <li class="nav-item">
            <a class="nav-link" id="prestataires_tab" data-toggle="tab" data-target="#prestataires_nav" href="#affectations_tab" role="tab" aria-controls="affectations_nav" aria-selected="false"><i class="fa-solid fa-person-digging"></i>&nbspPrestataires</a>
        </li>
        @endif
        {{-- @if(Auth::user()->role->name=="Agence urbaine" )
        <li class="nav-item">
            <a class="nav-link " id="prestataires_tab" data-toggle="tab" data-target="#prestataires_nav" href="#affectations_tab" role="tab" aria-controls="affectations_nav" aria-selected="false"><i class="fa-solid fa-users-gear"></i>&nbspChargés des guichets</a>
        </li>
        @endif 
        @if(Auth::user()->has_role("Administrateur,GU,Chef du projet,Observateur"))
        <li class="nav-item">
            <a class="nav-link " id="gichets_tab" data-toggle="tab" data-target="#guichets_nav" href="#gichets_tab" role="tab" aria-controls="guichets_nav" aria-selected="false"><i class="fa-solid fa-shop"></i>&nbspGuichets d'accompagnement</a>
        </li>
        @endif
        @if(Auth::user()->has_role("Agence urbaine"))
        <li class="nav-item">
            <a class="nav-link" id="gichets_tab" data-toggle="tab" data-target="#guichets_nav" href="#gichets_tab" role="tab" aria-controls="guichets_nav" aria-selected="false"><i class="fa-solid fa-shop"></i>&nbspGuichets d'accompagnement</a>
        </li>
        @endif --}}

        {{-- <li class="nav-item">
            <a class="nav-link" id="cartes_aleas_tab" data-toggle="tab" data-target="#cartes_aleas_nav" href="#cartes_aleas_tab" role="tab" aria-controls="cartes_aleas_nav" aria-selected="false"><i class="fa-solid fa-database"></i>&nbspCartes d'aléas</a>
        </li> --}}
    </ul>

    <div class="tab-content" id="nav-tabContent">
        @if(Auth::user()->has_role("Observateur,Administrateur,GU,Chef du projet"))
        <div class="tab-pane show active" id="douars_nav" role="tabpanel" aria-labelledby="douars_tab">@include('centre_donnees/tab_douars')</div>
        @endif
        <div disabled class="tab-pane fade" id="aleas_nav" role="tabpanel" aria-labelledby="aleas_tab"></div>
        @if(Auth::user()->has_role("Observateur,Administrateur,GU,Chef du projet"))
        <div class="tab-pane fade" id="prestataires_nav" role="tabpanel" aria-labelledby="prestataires_tab">@include('centre_donnees/tab_prestataires')</div>
        @endif
        {{-- @if(Auth::user()->has_role("Agence urbaine"))
        <div class="tab-pane fade" id="prestataires_nav" role="tabpanel" aria-labelledby="prestataires_tab">@include('centre_donnees/tab_charges_guichets')</div>
        @endif      
        @if(Auth::user()->has_role("Agence urbaine"))
        <div class="tab-pane fade" id="guichets_nav" role="tabpanel" aria-labelledby="gichets_tab">@include('centre_donnees/tab_guichets')</div>
        @endif
        @if(Auth::user()->has_role("Observateur,Administrateur,GU,Chef du projet"))
        <div class="tab-pane fade" id="guichets_nav" role="tabpanel" aria-labelledby="gichets_tab">@include('centre_donnees/tab_guichets')</div>
        @endif

   
        <div class="tab-pane fade" id="cartes_aleas_nav" role="tabpanel" aria-labelledby="cartes_aleas_tab">@include('centre_donnees/tab_aleas')</div>
        --}}
    </div>

</div>
@include('centre_donnees.modals')
@endsection

@if(Auth::user()->role-> name != "Équipement")
<script>
    var douars_tab_columns = [{
            data: 'douar',
        },
        {
            data: 'commune',
        },
        // {
        //     data: 'cercle',
        // },
        {
            data: 'province',
        },
        {
            data: 'laboratoire',
        },
        {
            data: 'architecte',
        },
        {
            data: 'igt',
        },
        {
            data: 'bet',
        }        
       
    ];
</script>
@else
<script>
    var douars_tab_columns = [{
            data: 'douar',
        },
        {
            data: 'commune',
        },
        {
            data: 'cercle',
        },
        {
            data: 'province',
        },
        {
            data: 'etude_geotechnique',
        },
         
    ];
</script>
@endif

<script>
    var provinces = @json($provinces);
    var cercles = @json($cercles);
    var communes = @json($communes);
    var douars = @json($douars);
</script>
@push('added_scripts')
<script src="{{asset('js/centre_donnees/index.js').'?t='.time()}}"></script>

@if(Auth::user()->has_role("Observateur,Administrateur,GU,Chef du projet"))
<script src="{{asset('js/centre_donnees/tab_douars.js').'?t='.time()}}"></script>
<script src="{{asset('js/centre_donnees/conclusion_modal.js').'?t='.time()}}"></script>
<script src="{{asset('js/centre_donnees/etude_geotechnique.js').'?t='.time()}}"></script>
@endif

@if(Auth::user()->has_role("Observateur,Administrateur,GU,Chef du projet"))
<script src="{{asset('js/centre_donnees/tab_prestataires.js').'?t='.time()}}"></script>
@endif

@if(Auth::user()->has_role("Agence urbaine"))
<script src="{{asset('js/centre_donnees/tab_charges_guichets.js').'?t='.time()}}"></script>
@endif

@if(Auth::user()->has_role("Observateur,Administrateur,GU,Chef du projet"))
<script src="{{asset('js/centre_donnees/tab_guichets.js').'?t='.time()}}"></script>
@endif

<script src="{{asset('js/centre_donnees/tab_cartes_aleas.js').'?t='.time()}}"></script>
@endpush