<div id="affectation_des_prestations_modal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Affectation des prestations</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class=" modal-body">

                <div class="row">
                    <div class="col-5">
                        <div class="input-group input-group-sm">
                            <div class="input-group-prepend">
                                <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Type</span>
                            </div>
                            <select id="affectation_des_prestations_modal_type" class="select2">
                                @foreach($role_prestataires as $role)
                                <option value="{{$role->id}}">{{$role->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-7">
                        <div class="input-group input-group-sm">
                            <div class="input-group-prepend">
                                <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Prestataire</span>
                            </div>
                            <select id="affectation_des_prestations_modal_prestataire" class="select2">
                                @foreach($prestataires as $prestataire)
                                <option value="{{$prestataire->id}}">{{$prestataire->organisme_ste}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <h6>Arrondissements</h6>
                <div class="row">
                    <div class="col-6">
                        <button id="affectation_des_prestations_modal_add_douar" type="button" class="btn"> <i class="fa-solid fa-plus"></i>&nbspAjouter</button>
                    </div>
                    <div class="col-6">
                        <button disabled style="float:right" id="affectation_des_prestations_modal_reaffectation" type="button" class="btn"><i class="fa-solid fa-pencil"></i>&nbspRéaffectation </button>
                    </div>
                </div>
                <table id="affectation_des_prestations_modal_douars" class="table table-striped datatables dataTable no-footer display nowrap">
                    <thead>
                        <th>Arrondissement</th>
                        <th>District</th>
                        <th>Cercle</th>
                        <th>Province</th>
                        <th>Actions</th>
                    </thead>
                    <tbody>
                    </tbody>
                </table>

            </div>


        </div>
    </div>
</div>


<div id="reaffectation_modal" class="modal fade" role="dialog">
    <div class="modal-dialog " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Réaffectation</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class=" modal-body">

                <div class="row">
                    <div class="col-12">
                        <div class="input-group input-group-sm mb-3">
                            <div class="input-group-prepend">
                                <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Type</span>
                            </div>
                            <input readonly id="reaffectation_modal_type" class="form-control">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="input-group input-group-sm mb-3">
                            <div class="input-group-prepend">
                                <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Prestataire</span>
                            </div>
                            <input readonly id="reaffectation_modal_old_prestataire" class="form-control">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="input-group input-group-sm">
                            <div class="input-group-prepend">
                                <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Nouveau prestataire</span>
                            </div>
                            <select id="reaffectation_modal_new_prestataire" class="select2">

                            </select>
                        </div>
                    </div>
                </div>

            </div>

            <div class="modal-footer" style="width:100%">
                <div class="row">
                    <div class="col-6">
                    </div>
                    <div class="col-6">
                        <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                        <button id="reaffectation_modal_save" style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="douars_select_modal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Arrondissements</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class=" modal-body">

                <div class="row">
                    <div class="input-group input-group-sm col-lg-6">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Province :</span>
                            </div>
                            <select id="select_modal_provinces_filter" class="form-control select2 m-tout douars_select_modal_filter" column="province_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($provinces as $province)
                                <option value="{{$province->id}}">{{$province->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-6">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">District :</span>
                            </div>
                            <select id="select_modal_communes_filter" class="form-control select2 m-tout douars_select_modal_filter" column="commune_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($communes as $commune)
                                <option value="{{$commune->id}}">{{$commune->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="input-group input-group-sm col-lg-6" style="display: none;">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Cercle :</span>
                            </div>
                            <select id="select_modal_cercles_filter" class="form-control select2 m-tout douars_select_modal_filter" column="cercle_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($cercles as $cercle)
                                <option value="{{$cercle->id}}">{{$cercle->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                   
                    <div class="input-group input-group-sm col-lg-6">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Arrondissement :</span>
                            </div>
                            <select id="select_modal_douars_filter" class="form-control select2 m-tout douars_select_modal_filter" column="douars.id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($douars as $douar)
                                <option value="{{$douar->id}}">{{$douar->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <b style="display: block;margin-left: 8px;color: #9e9e9e;" class="mt-3"><b style="color: #0a85cc;" id="douars_select_modal_douars_seclted_counter">0</b> élément(s) sélectionné(s)</b>
                <table id="douars_select_modal_douars" class="table table-striped datatables dataTable no-footer display nowrap">
                    <thead>
                        <th style="padding-left: 4px;"><input class="douars_select_modal_douars_select_all_cb" style="vertical-align: middle;position: relative;" type="checkbox">&nbspArrondissement</th>
                        <th>Disrtict</th>
                        <!-- <th>Cercle</th> -->
                        <th>Province</th>
                        <th>Prestataire</th>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>

            <div class="modal-footer" style="width:100%">
                <div class="row">
                    <div class="col-6">
                    </div>
                    <div class="col-6">
                        <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                        <button id="douars_select_modal_douars_save" style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>




<div id="add_prestataire_modal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Prestataire</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="store_user_form">
                @csrf
                <input hidden name="id" class="form-control">
                <div class=" modal-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Type</span>
                                </div>
                                <select required name="role_id" class="select2nc ">
                                    @foreach($role_prestataires as $role)
                                    <option value="{{$role->id}}">{{$role->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Nom</span>
                                </div>
                                <input required name="nom" class="form-control" placeholder="Nom">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Prenom</span>
                                </div>
                                <input required name="prenom" class="form-control" placeholder="Prenom">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Email</span>
                                </div>
                                <input required name="email" class="form-control" placeholder="Email">
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Téléphone</span>
                                </div>
                                <input name="tel" class="form-control" placeholder="Téléphone">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Organisme/Société</span>
                                </div>
                                <input required name="organisme_ste" class="form-control" placeholder="Organisme/Société">
                            </div>
                        </div>
                    </div>


                </div>

                <div class="modal-footer" style="width:100%">
                    <div class="row">
                        <div class="col-6">
                        </div>
                        <div class="col-6">
                            <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                            @if(Auth::user()->has_role('Chef du projet'))
                                <button style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                            @endif
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>




<div id="etat_engagement_modal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Etat d'engagement</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="store_etat_engagement_form">
                @csrf
                <input hidden name="user_ids" class="form-control">
                <div class=" modal-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Etat d'engagement</span>
                                </div>

                                <select required name="etat_engagement" class="select2nc">
                                    <option value="Manifestation d’intérêt">Manifestation d’intérêt</option>
                                    <option value="Contractuel">Contractuel</option>

                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="width:100%">
                    <div class="row">
                        <div class="col-6">
                        </div>
                        <div class="col-6">
                            <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                            <button style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<div id="etat_sol_modal" class="modal fade" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Etat du sol</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="store_etat_sol_form">
                @csrf
                <input hidden name="ids" class="form-control">
                <div class=" modal-body">

                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <input name="deblaiement" type="checkbox">&nbspDéblaiement
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <input name="stabilisation_sol" type="checkbox">&nbspStabilisation du sol
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <input name="nivellement" type="checkbox">&nbspNivellement
                            </div>
                        </div>
                    </div>


                </div>

                <div class="modal-footer" style="width:100%">
                    <div class="row">
                        <div class="col-6">
                        </div>
                        <div class="col-6">
                            <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                            <button style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>



<div id="etude_geotechnique_modal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edude géotechnique</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="store_etude_geotechnique_form">
                @csrf
                <input hidden name="id" class="form-control">

                <div class=" modal-body">
                    <div class="row">
                        <div class="col-6">
                            <h6 style="font-size: 0.9rem;color: #2073a0;"><i class="fa-solid fa-upload"></i>&nbspRapport géotechnique</h6>
                            <div class="row" id="etude_geotechnique_modal_loaded_label" style="display: none;">
                                <div class="col-12">
                                    <p style="color: #6b912c;" class="mb-2">Fichier chargé le : <b id="etude_geotechnique_modal_created_at" style="font-weight: 500;"></b>&nbsp-&nbsp<a id="etude_geotechnique_modal_download_rapport" href="javascript:;">Télécharger</a></p>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <p class="mb-2">Formats : <b style="font-weight: 500;">Fichier PDF</b> ,La taille maximale de fichier <b style="font-weight: 500;">10 Mb</b> </b></p>

                                    <div class="row">
                                        <div class="col-12" style="padding: 0px;">
                                            <input id="etude_geotechnique_modal_file" data-max-file-size-preview="10M" data-allowed-file-extensions="pdf" type="file" name="file" class="dropify" />
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h6 style="font-size: 0.9rem;color: #2073a0;"><i class="fa-solid fa-upload"></i>&nbspEffet de site lithologique</h6>
                            <div class="row">
                                <div class="row" id="etude_geotechnique_modal_effet_site_lithologique_loaded_label" style="display: none;">
                                    <div class="col-12">
                                        <p style="color: #6b912c;" class="mb-2">Fichier chargé le : <b id="etude_geotechnique_modal_effet_site_lithologique_created_at" style="font-weight: 500;"></b>&nbsp-&nbsp<a id="etude_geotechnique_modal_effet_site_lithologique_download" href="javascript:;">Télécharger</a></p>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <p class="mb-2">Formats : <b style="font-weight: 500;">Fichier Geojson</b> ,La taille maximale de fichier <b style="font-weight: 500;">10 Mb</b> </b></p>

                                    <div class="row">
                                        <div class="col-12" style="padding: 0px;">
                                            <input id="etude_geotechnique_modal_effet_site_lithologique_input" data-max-file-size-preview="10M" data-allowed-file-extensions="geojson" type="file" name="effet_site_lithologique_file" class="dropify" />
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <h6 style="font-size: 0.9rem;color: #2073a0;"><i class="fa-solid fa-upload"></i>&nbspEffet d'amplification topographique</h6>
                            <div class="row">
                                <div class="row" id="etude_geotechnique_modal_effet_topo_loaded_label" style="display: none;">
                                    <div class="col-12">
                                        <p style="color: #6b912c;" class="mb-2">Fichier chargé le : <b id="etude_geotechnique_modal_effet_topo_created_at" style="font-weight: 500;"></b>&nbsp-&nbsp<a id="etude_geotechnique_modal_effet_topo_download" href="javascript:;">Télécharger</a></p>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <p class="mb-2">Formats : <b style="font-weight: 500;">Fichier Geojson</b> ,La taille maximale de fichier <b style="font-weight: 500;">10 Mb</b> </b></p>

                                    <div class="row">
                                        <div class="col-12" style="padding: 0px;">
                                            <input id="etude_geotechnique_modal_effet_topo_input" data-max-file-size-preview="10M" data-allowed-file-extensions="geojson" type="file" name="effet_topo_file" class="dropify" />
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <h6 style="font-size: 0.9rem;color: #2073a0;"><i class="fa-solid fa-upload"></i>&nbspRapport géotechnique (LPEE)</h6>
                            <div class="row" id="etude_geotechnique_modal_loaded_lpee_label" style="display: none;">
                                <div class="col-12">
                                    <p style="color: #6b912c;" class="mb-2">Fichier chargé le : <b id="etude_geotechnique_modal_lpee_created_at" style="font-weight: 500;"></b>&nbsp-&nbsp<a id="etude_geotechnique_modal_lpee_download_rapport" href="javascript:;">Télécharger</a></p>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <p class="mb-2">Formats : <b style="font-weight: 500;">Fichier PDF</b> ,La taille maximale de fichier <b style="font-weight: 500;">10 Mb</b> </b></p>

                                    <div class="row">
                                        <div class="col-12" style="padding: 0px;">
                                            <input id="etude_geotechnique_modal_lpee_file" data-max-file-size-preview="10M" data-allowed-file-extensions="pdf" type="file" name="file_lpee" class="dropify" />
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div class="col-6">
                            <h6 style="font-size: 0.9rem;color: #2073a0;"><i class="fa-solid fa-upload"></i>&nbspZone de constructibilité</h6>
                            <div class="row">
                                <div class="col-12">
                                    @if(Auth::user()->has_role('Laboratoire'))
                                    <input style="display: none;" type="file" id="etude_geotechnique_modal_upload_constructibilite_input" />
                                    <button id="etude_geotechnique_modal_upload_constructibilite_add" type="button" class="btn btn-light"><i class="fa-solid fa-check-double"></i>&nbspAjouter depius fichier geojson </button>
                                    <button disabled id="etude_geotechnique_modal_conclusions_delete" type="button" class="btn btn-danger"><i class="fa-solid fa-pen-to-square"></i>&nbspSupprimer</button>
                                    @endif
                                </div>
                            </div>
                            <div class="row">
                                <table id="etude_geotechnique_modal_conclusions_table" class="table table-striped datatables dataTable no-footer display nowrap">
                                    <thead>
                                        <th>Conclusion</th>
                                        <th>Commentaire</th>
                                        <th>Zone</th>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>







                </div>

                <div class="modal-footer" style="width:100%">
                    <div class="row">
                        <div class="col-6">
                        </div>
                        <div class="col-6">
                            <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                            @if (Auth::user()->has_role('Laboratoire'))
                            <button style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                            @endif
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>



<div id="etude_geotechnique_conclusion_modal" class="modal fade" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Conclusion</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="store_etude_geotechnique_conclusion_form">
                @csrf
                <input hidden name="id" class="form-control">
                <div class=" modal-body">

                    <div class="row mt-2">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 140px;" class="input-group-text">Conclusion</span>
                                </div>
                                <select required name="conclusion" class="select2">
                                    <option value="Constructible">Constructible</option>
                                    <option value="Constructible à conditions">Constructible à conditions</option>
                                    <option value="Constructible à conditions strictes">Constructible à conditions strictes</option>
                                    <option value="Non constructible">Non constructible</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="height:100px !important;padding: .0rem .5rem !important;min-width: 140px;" class="input-group-text">Commentaire</span>
                                </div>
                                <textarea class="form-control" style="height:100px !important" name="commentaire"></textarea>
                            </div>
                        </div>
                    </div>

                    <h6>Zone (Fichier geojson)</h6>

                    <div class="row" style="display: none;">
                        <div class="col-12">
                            <input id="etude_geotechnique_conclusion_modal_geojson_file" name="file" type="file">
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-12">
                            <div id="etude_geotechnique_conclusion_modal_map" style="min-height: 200px; background: rgb(242, 242, 242); height: 100%; width: 100%; border-radius: 6px; border: 1px solid rgb(198, 198, 198); position: relative;" class="leaflet-container leaflet-touch leaflet-retina leaflet-fade-anim leaflet-grab leaflet-touch-drag leaflet-touch-zoom" tabindex="0">

                            </div>
                        </div>
                    </div>

                </div>

                <div class="modal-footer" style="width:100%">
                    <div class="row">
                        <div class="col-6">
                        </div>
                        <div class="col-6">
                            <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                            <button style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<div id="etat_deblaiement_modal" class="modal fade" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Déblaiement</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="store_deblaiement_form">
                @csrf
                <input hidden name="douar_id" class="form-control">
                <div class=" modal-body">

                    <div id="etat_deblaiement_modal_deblaiement_div" class="card">
                        <div class="row mb-2 mt-2">
                            <div class="col-12">
                                <input name="concerne" style="vertical-align: middle;position: relative;margin-left:8px" type="checkbox">&nbsp Quartier concerné
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-12">
                                <input name="non_concerne" style="vertical-align: middle;position: relative;margin-left:8px" type="checkbox">&nbsp Douar non concerné
                            </div>
                        </div>
                    </div>

                    <div id="etat_deblaiement_modal_concerne_div" class="card disabled">
                        <div class="row mt-2">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">
                                            <input name="entame" style="vertical-align: middle;position: relative;" type="checkbox">&nbsp Entamé
                                        </span>
                                    </div>
                                    <input disabled name="progression" value="0" type="number" class="form-control" placeholder="">
                                    <div class="input-group-append">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">
                                            <input name="acheve" style="vertical-align: middle;position: relative;" type="checkbox">&nbsp Achevé
                                        </span>
                                    </div>
                                    <input disabled name="date_achevement" type="text" class="form-control cdate" placeholder="Date d'achévement">

                                </div>
                            </div>
                        </div>
                    </div>


                    <h6 class="mt-2"><i class="fa-regular fa-clock"></i>&nbsp Historique</h6>

                    <div class="row mt-2">
                        <table id="etat_deblaiement_modal_historique_table" class="table table-striped datatables dataTable no-footer display nowrap">
                            <thead>
                                <th>Etat</th>
                                <th>Date</th>
                                <th>Prestateire</th>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>


                <div class="modal-footer" style="width:100%">
                    <div class="row">
                        <div class="col-6">
                        </div>
                        <div class="col-6">
                            <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                            <button type="submit" style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>




<div id="guichet_creation_modal" class="modal fade" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Guichet d'accompagnement</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="store_guichet_form">
                @csrf
                <input hidden name="id" class="form-control">
                <div class=" modal-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">
                                        <input name="creation" style="vertical-align: middle;position: relative;" type="checkbox">&nbsp Guichet créé le :
                                    </span>
                                </div>
                                <input disabled name="date_creation" type="text" class="form-control cdate">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <table id="guichet_creation_modal_charges_guichets_table" class="table table-striped datatables dataTable no-footer display nowrap">
                                <thead>
                                    <th>E-mail</th>
                                    <th>Nom</th>
                                    <th>Prenom</th>
                                    <th>Cguichet</th>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    </table>

                </div>
                <div class="modal-footer" style="width:100%">
                    <div class="row">
                        <div class="col-6">
                        </div>
                        <div class="col-6">
                            <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                            <button type="submit" style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<div id="add_charge_guichet_modal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Chargé du guichet d'accompagnement</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="store_charge_guichet_form">
                @csrf
                <input hidden name="id" class="form-control">
                <div class=" modal-body">

                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Nom</span>
                                </div>
                                <input required name="nom" class="form-control" placeholder="Nom">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Prenom</span>
                                </div>
                                <input required name="prenom" class="form-control" placeholder="Prenom">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Email</span>
                                </div>
                                <input required name="email" class="form-control" placeholder="Email">
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-12">
                            <div class="input-group input-group-sm mb-3">
                                <div class="input-group-prepend">
                                    <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Téléphone</span>
                                </div>
                                <input name="tel" class="form-control" placeholder="Téléphone">
                            </div>
                        </div>
                    </div>

                </div>

                <div class="modal-footer" style="width:100%">
                    <div class="row">
                        <div class="col-6">
                        </div>
                        <div class="col-6">
                            <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                            <button style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<div id="add_douar_modal" class="modal fade" role="dialog">
    <div class="modal-dialog  " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Ajouter quartier</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="store_new_douar_form">
                @csrf
                <div class=" modal-body">

                    <div class="row">
                        <div class="input-group input-group-sm col-lg-12">
                            <div class="input-group mb-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 160px;">Province :</span>
                                </div>
                                <select name="province" id="add_douar_modal_provinces_filter" class="form-control select2 m-tout add_douar_modal_filter" column="province_id" table="">
                                    <option value="all" selected>Veuillez sélectionner</option>
                                    @foreach($provinces as $province)
                                    <option value="{{$province->id}}">{{$province->nom}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>

                    <div class="row" style="display: none;">
                        <div class="input-group input-group-sm col-lg-12">
                            <div class="input-group mb-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 160px;">Cercle :</span>
                                </div>
                                <select name="cercle" id="add_douar_modal_cercles_filter" class="form-control select2 m-tout add_douar_modal_filter" column="cercle_id" table="">
                                    <option value="all" selected>Veuillez sélectionner</option>
                                    @foreach($cercles as $cercle)
                                    <option value="{{$cercle->id}}">{{$cercle->nom}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="input-group input-group-sm col-lg-12">
                            <div class="input-group mb-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 160px;">Disrtict :</span>
                                </div>
                                <select name="commune" id="add_douar_modal_communes_filter" class="form-control select2 m-tout add_douar_modal_filter" column="commune_id" table="">
                                    <option value="all" selected>Veuillez sélectionner</option>
                                    @foreach($communes as $commune)
                                    <option value="{{$commune->id}}">{{$commune->nom}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="input-group input-group-sm col-lg-12">
                            <div class="input-group mb-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 160px;">Arrondissement :</span>
                                </div>
                                <input id="add_douar_modal_douar" name="douar" class="form-control">

                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer" style="width:100%">
                    <div class="row">
                        <div class="col-6">
                        </div>
                        <div class="col-6">
                            <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                            <button disabled id="add_douar_modal_submit" style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>