@extends('layouts.app')

@section('added_css')
<link rel="stylesheet" href="{{asset('css/datatable/datatables.min.css')}}" />
<link rel="stylesheet" type="text/css" href="{{asset('chart.js/dist/Chart.min.css')}}">
<script src="{{asset('chart.js/dist/Chart.js')}}"></script>
<style>
    .m-footer {
        color: #ff1308 !important;
        font-weight: 600;
    }

    .small-box>.inner {
        padding: 0.75rem;
    }

    .small-box {
        margin-bottom: 10px;
    }


    .text-styling {
        font-size: 14px;
        color: #000;

    }

    .text-center {
        font-size: 14px;
        color: #000;
    }


    .table th,
    .table td {
        border-right: 1px solid #f4f4f4;
    }


    .table-striped tbody tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, .05) !important;
    }

    th {
        background-color: unset !important;
    }


    .m-thead {
        font-family: Lato;
        font-weight: 700 !important;
        font-size: 15px !important;
    }


    .m-thead-mobile {
        font-family: Lato;
        font-weight: 600 !important;
        font-size: 13px !important;

    }
</style>
@endsection

@section('content')
<div style="padding-top: 16px;margin-left: 8px">

    <div class="row">
        <div class="col-12">
            <b style="display: block;width:100%;font-size: 1rem; margin-top: 12px; border-bottom: 1px #f18888 dashed; text-align: left;color: #ff4d4d;padding-left: 12px;"><i class="fa-solid fa-chart-pie"></i>&nbsp Demandes</b>
        </div>
    </div>
    <div class="row">
        <div class="col-12 col-md-4">
            @foreach($stats_1_rows[0]['cols'] as $col)
            <div class="col-md col-sm-12 mb-2 mt-2">
                <div class="card card-stats" style="border: 1px solid rgb(221 221 221);; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 13%) !important;">

                    <div class="card-content">
                        <div class="row">
                            <div class="col" style="max-width:86px;background: {{$col['back_color']}}50;padding: 0px;border-radius: 5px 0px 0px 5px;border-right: 1px #c9c9c9 solid;">
                                <span style="display: block; padding: 6px 12px; font-size: 0.8rem; background: {{$col['back_color']}}; border-radius: 8px;  margin: 12px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 13%) !important; width: 60px; height: 60px;">
                                    <b style="display: block; text-align: center; line-height: 50px; font-size: 1.5rem; color: {{$col['text_color']}};" class="category"> <i class="{{$col['fa-icon']}}"></i></b>
                                </span>
                            </div>
                            <div class="col">
                                <div class="row" style="width: 100%; border-bottom: 1px silver dashed;padding: 4px;">
                                    <b style="color: gray;font-size: 0.78rem;">{{$col['title']}}</b>
                                </div>
                                <div class="row" style="width: 100%;text-align: center;padding:8px">
                                    <h5 class="{{$col['class']}} main_value" style="width: 100%;font-size:1.5rem;">{{$col['main_value']}}</h5>
                                </div>
                                @if(!is_null($col['percentage_1']) || !is_null($col['percentage_1']))
                                <div class="row" style="width: 100%; border-top: 1px #d8d8d8 solid !important;;padding: 4px;">
                                    @if(!is_null($col['percentage_1']))
                                    <div class="col" style="{{!is_null($col['percentage_2'])?'border-right: 1px #d8d8d8 solid !important;':''}}">
                                        <h5 class="{{$col['class']}} percentage_1" style="color: gray;width: 100%;text-align: center;font-size:0.8rem">{{$col['percentage_1']}} % </h5>
                                    </div>
                                    @endif
                                    @if(!is_null($col['percentage_2']))
                                    <div class="col">
                                        <h5 class="{{$col['class']}} percentage_2" style="color: #F08A38;width: 100%;text-align: center;font-size:0.8rem">{{$col['percentage_2']}} % </h5>
                                    </div>
                                    @endif
                                </div>
                                @else
                                <div class="row" style="width: 100%;padding: 4px;">
                                    <div class="col" style="width: 100%">
                                        <h5 style="width: 100%;">&nbsp</h5>
                                    </div>
                                </div>
                                @endif

                            </div>
                        </div>

                    </div>
                </div>
            </div>
            @endforeach
        </div>
        <div class="col-12 col-md-8">
            <div class="row">
                <div class="col-12">
                    <div id="prestataires_demandes_chart" style="padding: 8px;box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 13%) !important;height:460px;border-radius: 8px;margin: 8px;border:1px rgb(221 221 221); solid">
                    </div>
                </div>
               
            </div>

        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <b style="display: block;width:100%;font-size: 1rem; margin-top: 12px; border-bottom: 1px #f18888 dashed; text-align: left;color: #ff4d4d;padding-left: 12px;"><i class="fa-solid fa-chart-pie"></i>&nbsp Avancement des travaux</b>
        </div>
    </div>
    <div class="row mb-3">
        <div class="col-md-6 col-12">
            @foreach($stats_2_rows as $stat_row)
            <div class="row mt-2 dashboard_row">
                <b style="width: 100%;margin: 8px 8px;font-size: 0.8rem;">{{$stat_row['title']}}</b>
                @foreach($stat_row['cols'] as $col)
                <div class="col-md col-sm-12 mb-1">
                    <div class="card card-stats" style="border: 1px solid rgb(221 221 221);; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 13%) !important;">

                        <div class="card-content">
                            <div class="row">
                                <div class="col" style="max-width:86px;background: {{$col['back_color']}}50;padding: 0px;border-radius: 5px 0px 0px 5px;border-right: 1px #c9c9c9 solid;">
                                    <span style="display: block; padding: 6px 12px; font-size: 0.8rem; background: {{$col['back_color']}}; border-radius: 8px;  margin: 12px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 13%) !important; width: 60px; height: 60px;">
                                        <b style="display: block; text-align: center; line-height: 50px; font-size: 1.5rem; color: {{$col['text_color']}};" class="category"> <i class="{{$col['fa-icon']}}"></i></b>
                                    </span>
                                </div>
                                <div class="col">
                                    <div class="row" style="width: 100%; border-bottom: 1px silver dashed;padding: 4px;">
                                        <b style="color: gray;font-size: 0.78rem;">{{$col['title']}}</b>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <h5 class="{{$col['class']}} main_value" style="width: 100%;font-size:1.5rem;">{{$col['main_value']}}</h5>
                                    </div>
                                    @if(!is_null($col['percentage_1']) || !is_null($col['percentage_1']))
                                    <div class="row" style="width: 100%; border-top: 1px #d8d8d8 solid !important;;padding: 4px;">
                                        @if(!is_null($col['percentage_1']))
                                        <div class="col" style="{{!is_null($col['percentage_2'])?'border-right: 1px #d8d8d8 solid !important;':''}}">
                                            <h5 class="{{$col['class']}} percentage_1" style="color: gray;width: 100%;text-align: center;font-size:0.8rem">{{$col['percentage_1']}} % </h5>
                                        </div>
                                        @endif
                                        @if(!is_null($col['percentage_2']))
                                        <div class="col">
                                            <h5 class="{{$col['class']}} percentage_2" style="color: #F08A38;width: 100%;text-align: center;font-size:0.8rem">{{$col['percentage_2']}} % </h5>
                                        </div>
                                        @endif
                                    </div>
                                    @else
                                    <div class="row" style="width: 100%;padding: 4px;">
                                        <div class="col" style="width: 100%">
                                            <h5 style="width: 100%;">&nbsp</h5>
                                        </div>
                                    </div>
                                    @endif

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                @endforeach

            </div>
            @endforeach


            @foreach($stats_3_rows as $stat_row)
            <div class="row mt-2 dashboard_row">
                <b style="width: 100%;margin: 8px 8px;font-size: 0.8rem;">{{$stat_row['title']}}</b>
                @foreach($stat_row['cols'] as $col)
                <div class="col-md col-sm-12 mb-1">
                    <div class="card card-stats" style="border: 1px solid rgb(221 221 221);; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 13%) !important;">

                        <div class="card-content">
                            <div class="row">
                                <div class="col" style="max-width:86px;background: {{$col['back_color']}}50;padding: 0px;border-radius: 5px 0px 0px 5px;border-right: 1px #c9c9c9 solid;">
                                    <span style="display: block; padding: 6px 12px; font-size: 0.8rem; background: {{$col['back_color']}}; border-radius: 8px;  margin: 12px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 13%) !important; width: 60px; height: 60px;">
                                        <b style="display: block; text-align: center; line-height: 50px; font-size: 1.5rem; color: {{$col['text_color']}};" class="category"> <i class="{{$col['fa-icon']}}"></i></b>
                                    </span>
                                </div>
                                <div class="col">
                                    <div class="row" style="width: 100%; border-bottom: 1px silver dashed;padding: 4px;">
                                        <b style="color: gray;font-size: 0.78rem;">{{$col['title']}}</b>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <h5 class="{{$col['class']}} main_value" style="width: 100%;font-size:1.5rem;">{{$col['main_value']}}</h5>
                                    </div>
                                    @if(!is_null($col['percentage_1']) || !is_null($col['percentage_1']))
                                    <div class="row" style="width: 100%; border-top: 1px #d8d8d8 solid !important;;padding: 4px;">
                                        @if(!is_null($col['percentage_1']))
                                        <div class="col" style="{{!is_null($col['percentage_2'])?'border-right: 1px #d8d8d8 solid !important;':''}}">
                                            <h5 class="{{$col['class']}} percentage_1" style="color: gray;width: 100%;text-align: center;font-size:0.8rem">{{$col['percentage_1']}} % </h5>
                                        </div>
                                        @endif
                                        @if(!is_null($col['percentage_2']))
                                        <div class="col">
                                            <h5 class="{{$col['class']}} percentage_2" style="color: #F08A38;width: 100%;text-align: center;font-size:0.8rem">{{$col['percentage_2']}} % </h5>
                                        </div>
                                        @endif
                                    </div>
                                    @else
                                    <div class="row" style="width: 100%;padding: 4px;">
                                        <div class="col" style="width: 100%">
                                            <h5 style="width: 100%;">&nbsp</h5>
                                        </div>
                                    </div>
                                    @endif

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                @endforeach

            </div>
            @endforeach
        </div>
        <div class="col-12 col-md-6">
            <div id="etats_reconstruction_chart" style="height:320px;padding: 8px;box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 13%) !important; border-radius: 8px;margin: 8px;border:1px rgb(221 221 221); solid">
            </div>
        </div>
    </div>

</div>

</div>


@endsection

@push('added_scripts')

<script src="{{asset('js/dashbaord/charts_prestataires.js').'?t='.time()}}"></script>
<script src="{{asset('js/dashbaord/index-prestataire.js').'?t='.time()}}"></script>
 

<script src="{{asset('js/dashbaord/prestataire_avis_favorables_chart.js').'?t='.time()}}"></script>
<script src="{{asset('js/dashbaord/prestataire_demandes_chart.js').'?t='.time()}}"></script>
<script src="{{asset('js/dashbaord/prestataire_avancement_chart.js').'?t='.time()}}"></script>
@endpush