<div>
    <div class="card card-refresh mt-2" style="{{Auth::user()->has_role('Vérificateur,Financier,Observateur,Chef du projet,Administrateur,GU,Architecte,Laboratoire,BET,IGT')?'':'display:none'}}">
        <div class="refresh-container">
            <div class="loader-pendulums"></div>
        </div>
        <div class="card-header card-header-action">
            <h5 style="margin: 2px !important;color: #2273ae;font-size: 15px;">Demolition</h5>
            <div class="d-flex align-items-center card-action-wrap">
                <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_3" aria-expanded="true">
                    <i class="zmdi zmdi-chevron-down"></i>
                </a>

            </div>
        </div>
        <div id="collapse_3" class="collapse show">
            <div class="card-body">
                @if(!Auth::user()->has_role('Vérificateur'))
                <div style="display : none">
                    <h6><input {{Auth::user()->has_role('Architecte')?'':'disabled'}} {{$dossier->use_plan_type==1?'checked':''}} type="checkbox" class="use_plan_type">&nbspPlan type (Architecte)</h6>
                    <div class="plan_type_div card {{$dossier->use_plan_type==0?'disabled':''}}">

                        <table class="table rtable datatables table-striped no-footer display nowrap  ">
                            <thead>
                                <th style="text-align: left;">Plan type</th>
                                <th style="text-align: center;">Document</th>
                                <th style="text-align: center;">Etat</th>
                                <th style="text-align: center;">Téléchargement</th>

                            </thead>
                            <tbody>
                                <tr>
                                    <td style="text-align: left;"><i class="fa-solid fa-sheet-plastic"></i>&nbspPlan type - Architecte</td>
                                    <td style="text-align: center;">
                                        <select class="plan_type_select form-control select2nc">
                                            <option {{is_null($dossier->plan_type)?'selected':''}} value="">Veuillez sélectionner</option>
                                            @foreach($plans_type as $plan_type)
                                            @if( $plan_type->type=="PLAN_ARCHITECTE")
                                            <option {{$dossier->plan_type_id==$plan_type->id?'selected':''}} value="{{$plan_type->id}}">Plan type {{$plan_type->nom}}</option>
                                            @endif
                                            @endforeach
                                        </select>
                                    </td>
                                    <td style="text-align: center;"><span class="plan_type_etat" style="color:#575757">Aucun fichier sélectionné</span></td>
                                    <td style="text-align: center;">
                                        <button disabled type="button" class="btn btn-success download_plan_type_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>


                <div style="display: none;">

                    <h6><input {{Auth::user()->has_role('BET')?'':'disabled'}} {{$dossier->use_plan_type_bet==1?'checked':''}} type="checkbox" class="use_plan_type_bet">&nbspPlan type (BET)</h6>
                    <div class="plan_type_bet_div card {{$dossier->use_plan_type_bet==0?'disabled':''}}">

                        <table class="table rtable datatables table-striped no-footer display nowrap  ">
                            <thead>
                                <th style="text-align: left;">Plan type</th>
                                <th style="text-align: center;">Document</th>

                                <th style="text-align: center;">Téléchargement</th>

                            </thead>
                            <tbody>
                                <tr>
                                    <td style="text-align: left;"><i class="fa-solid fa-sheet-plastic"></i>&nbspPlan type - BET</td>
                                    <td style="text-align: center;">
                                        <select class="plan_type_bet_select form-control select2nc">
                                            <option {{is_null($dossier->plan_type)?'selected':''}} value="">Veuillez sélectionner</option>
                                            @foreach($plans_type as $plan_type)
                                            @if( $plan_type->type=="BET")
                                            <option {{$dossier->plan_type_bet_id==$plan_type->id?'selected':''}} value="{{$plan_type->id}}">Plan type {{$plan_type->nom}}</option>
                                            @endif
                                            @endforeach
                                        </select>
                                    </td>
                                    <td style="text-align: center;">
                                        <button disabled type="button" class="btn btn-success download_plan_type_bet_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                @endif
                <h6 class="mt-3" style="display: none;">Dossier de permis de construire</h6>

                <table class="table rtable datatables table-striped no-footer display nowrap">
                    <thead>
                        <th>Document</th>
                        <th>Type du fichier</th>
                        <th>Date dépôt</th>
                        <th>Date document</th>
                        <th style="display:none;">Vérification de dépôt</th>
                        <th></th>
                        <th></th>
                    </thead>
                    <tbody>
                        @foreach($demolition_documents_list as $demolition_document)
                        <tr>
                            <td><i class="fa-solid fa-file-pdf"></i>&nbsp{{$demolition_document['name']}}
                                @if($demolition_document['document']!=null && $demolition_document['validation']==1)
                                <span style="font-weight:bold;color:{{$demolition_document['document']->decision_color()}}"> - {{$demolition_document['document']->decision_full()}}</span>
                                @endif
                            </td>
                            <td>Fichier {{strtoupper($demolition_document['file_type'])}}</td>
                            <td>
                                @if(is_null($demolition_document['document']))
                                <span type_document="{{$demolition_document['type_document']}}" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                @else
                                <span type_document="{{$demolition_document['type_document']}}" class="download_depot_date" style="color:black">{{$demolition_document['document']->formated_created_at()}} - <span style="color:coral">{{$demolition_document['document']->user->organisme_ste}} <span></span>
                                        @endif
                            </td>

                            <td style="display:none;">
                                @if(is_null($demolition_document['document']))
                                <span type_document="{{$demolition_document['type_document']}}" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                @else

                                <a href="javascript:;" document_id="{{$demolition_document['document']->id}}" type_document="{{$demolition_document['type_document']}}" class="document_decision" style="{{(Auth::user()->role->name == "Architecte" ?'':'pointer-events:none;text-decoration:none;')}};color:{{$demolition_document['document']->decision_color()}} !important">{{$demolition_document['document']->decision_full()}}</a>
                                <a href="javascript:;" data-toggle="popover" title="Commentaire" data-content="{{$demolition_document['document']->commentaire}}" document_id="{{$demolition_document['document']->id}}" style="display:{{strlen($demolition_document['document']->commentaire)>0?'inline-block':'none'}};margin-left:6px;color:darkorange" class="fa-solid fa-comment-dots document_comments"></a>
                                @endif
                            </td>
                            <td>
                                @if(!is_null($demolition_document['document']))
                                <span>{{$demolition_document['document']->formated_date_document()}} </span>
                                @else
                                <span type_document="{{$demolition_document['type_document']}}" style="color:gray">Aucun fichier importé</span>
                                @endif
                            </td>
                            <td>
                                @if(Auth::user()->has_role($demolition_document['w_roles']) && $demolition_document['active']==1)
                                <button type_document="{{$demolition_document['type_document']}}" file_type="{{$demolition_document['file_type']}}" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                @endif
                            </td>
                            <td>
                                @if(is_null($demolition_document['document']))
                                <button type_document="{{$demolition_document['type_document']}}" file_id="" disabled type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                @else
                                <button type_document="{{$demolition_document['type_document']}}" file_id="{{$demolition_document['document']->id}}" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>

            <br>
            <div class="row">
                <div class="col-lg-6" style="padding-left : 0px;">
                    <div class="input-group input-group-sm mb-3">
                        <div class="input-group-prepend">
                            <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Demolition</span>
                        </div>
                        <select id="is_demolition_select" name="is_demolition" class="select2nc" {{$dossier->is_demolition == 1 || !Auth::user()->has_role('Chef du projet')  ? "disabled" : ''}}>
                            <option {{$dossier->is_demolition == 0 ? "selected" : ''}} value="0">Non</option>
                            <option {{$dossier->is_demolition == 1 ? "selected" : ''}} value="1">Oui</option>                       
                        </select>
                    </div>
                </div>

                <div class="col-lg-6" style="padding-right : 0px;"> 
                        <div id="entreprise_div" class="input-group input-group-sm" style="margin-top: -4px;">
                            <div class="input-group mb-1 mt-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 160px;">Entreprise:</span>
                                </div>
                                <select id="entreprise_select" class="form-control select2 m-tout" {{$dossier->is_demolition == 1 || !Auth::user()->has_role('Chef du projet')  ? "disabled" : ''}}>
                                    <option value="">Non selectionnée</option>
                                    @foreach($entreprises as $entreprise)
                                        <option {{$dossier->entreprise_id == $entreprise->id ? "selected" : ''}} value="{{$entreprise->id}}">{{$entreprise->nom}}</option>
                                    @endforeach
                                </select>

                            </div>
                        </div>  
                </div>

            </div>

            <h6>Photothèque</h6>
            <div class="row">
                @foreach($demolition_phototheque as $photos_group)
                <h6 style="font-size: 0.8rem; margin-left: 8px; color: #797979;">{{$photos_group['name']}}</h6>
                <div class="col-6">
                    @if(Auth::user()->has_role('Chef du projet'))
                        <button type_document="{{$photos_group['type_document']}}" type="button" class="btn btn-light upload_photo_link"> <i class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                        <button type_document="{{$photos_group['type_document']}}" type="button" disabled class="btn btn-danger delete_photo_link"> <i class="fa-solid fa-plus"></i>&nbsp;Supprimer</button>
                    @endif
                </div>
                <div id="photos_{{$photos_group['type_document']}}" class="phototheque hk-gallery" type_document="{{$photos_group['type_document']}}" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:120px;overflow-x: auto;white-space: nowrap;padding:4px">
                    @foreach($photos_group['photos'] as $photo)
                    <a class="costume-img" href="{{$photo->documentUrl()}}" style="margin: 0px;">
                        <img style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="{{$photo->documentUrl()}}" class="gallery-img costume-img hk-gallery">
                        </br>
                        <input item_id="{{$photo->id}}" type_document="{{$photos_group['type_document']}}" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                    </a>
                    @endforeach
                </div>
                @endforeach
            </div>


            </div>
        </div>
    </div>
</div>


