<div class="card card-refresh mt-2  {{$FONDATION_LOCKED?'disabled':''}}" style="{{Auth::user()->has_role('Vérificateur,Financier,Observateur,Chef du projet,Administrateur,GU,Architecte,Laboratoire,BET')?'':'display:none'}}">
    <div class="refresh-container">
        <div class="loader-pendulums"></div>
    </div>
    <div class="card-header card-header-action">
        <h5 style="margin: 2px !important;color: #2273ae;font-size: 15px;">Fondations</h5>
        <div class="d-flex align-items-center card-action-wrap">
            <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_5" aria-expanded="true">
                <i class="zmdi zmdi-chevron-down"></i>
            </a>

        </div>
    </div>
    <div id="collapse_5" class="collapse show">
        <div class="card-body">
            <h6>Dossier des réceptions</h6>
            <table class="table rtable datatables table-striped no-footer display nowrap">
                <thead>
                    <th></th>
                    <th>Document</th>
                    <th>Type du fichier</th>  
                    <th>Date dépôt</th>
                    <th>Date document</th>
                    <th style="display:none;">Vérification de dépôt</th>
                    <th></th>
                    <th></th>
                </thead>
                <tbody>
                    @foreach($fondation_documents_reception_list as $fondation_document_reception)
                    @if(Auth::user()->has_role('Architecte,IGT,BET,Laboratoire') && ($fondation_document_reception['type_document'] == "DECISION_AF_2" || $fondation_document_reception['type_document'] == "ACCUSE_RECEPTION_CHEQUE_AF_2" ))
                    @else
                    <tr>
                        <td><i class="fa-solid fa-file-pdf"></i>&nbsp{{$fondation_document_reception['title']}}
                            @if($fondation_document_reception['document']!=null && $fondation_document_reception['validation']==1)
                            <span style="font-weight:bold;color:{{$fondation_document_reception['document']->decision_color()}}"> - {{$fondation_document_reception['document']->decision_full()}}</span>
                            @endif
                        </td>
                        <td>
                            <{{$fondation_document_reception['name']}}< /td>
                        <td>Fichier {{strtoupper($fondation_document_reception['file_type'])}}</td>
                        <td>
                            @if(is_null($fondation_document_reception['document']))
                            <span type_document="{{$fondation_document_reception['type_document']}}" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                            @else
                            <span type_document="{{$fondation_document_reception['type_document']}}" class="download_depot_date" style="color:black">{{$fondation_document_reception['document']->formated_created_at()}}</span>
                            @endif
                        </td>
                        <td>
                            @if(!is_null($fondation_document_reception['document']))
                            <span>{{$fondation_document_reception['document']->formated_date_document()}} </span>
                            @else
                            <span type_document="{{$fondation_document_reception['type_document']}}" style="color:gray">Aucun fichier importé</span>
                            @endif
                        </td>

                        <td style="display:none;">
                            @if(is_null($fondation_document_reception['document']))
                            <span type_document="{{$fondation_document_reception['type_document']}}" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                            @else
                            <a href="javascript:;" document_id="{{$fondation_document_reception['document']->id}}" type_document="{{$fondation_document_reception['type_document']}}" class="document_decision" style="{{(Auth::user()->role->name == "Architecte" ?'':'pointer-events:none;text-decoration:none;')}};color:{{$fondation_document_reception['document']->decision_color()}} !important">{{$fondation_document_reception['document']->decision_full()}}</a>
                            <i document_id="{{$fondation_document_reception['document']->id}}" style="display:{{strlen($fondation_document_reception['document']->commentaire)>0?'inline-block':'none'}};margin-left:6px;color:darkorange" class="fa-solid fa-comment-dots document_comments"></i>
                            @endif
                        </td>
                        <td>
                            @if(Auth::user()->has_role($fondation_document_reception['w_roles']) && $fondation_document_reception['active']==1)
                            <button type_document="{{$fondation_document_reception['type_document']}}" file_type="{{$fondation_document_reception['file_type']}}" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                            @endif
                        </td>
                        <td>
                            @if(is_null($fondation_document_reception['document']))
                            <button type_document="{{$fondation_document_reception['type_document']}}" file_id="" disabled type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                            @else
                            <button type_document="{{$fondation_document_reception['type_document']}}" file_id="{{$fondation_document_reception['document']->id}}" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                            @endif
                        </td>
                    </tr>
                    @endif
                    @endforeach
                </tbody>
            </table>
            <h6>Photothèque</h6>
            <div class="row">


                @foreach($fondation_phototheque as $photos_group)
                <h6 style="font-size: 0.8rem; margin-left: 8px; color: #797979;">{{$photos_group['name']}}</h6>
                <div class="col-6">
                    <button type_document="{{$photos_group['type_document']}}" type="button" class="btn btn-light upload_photo_link"> <i class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                    <button type_document="{{$photos_group['type_document']}}" type="button" disabled class="btn btn-danger delete_photo_link"> <i class="fa-solid fa-trash"></i>&nbsp;Supprimer</button>
                </div>
                <div id="photos_{{$photos_group['type_document']}}" class="phototheque hk-gallery" type_document="{{$photos_group['type_document']}}" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:120px;overflow-x: auto;white-space: nowrap;padding:4px">
                    @foreach($photos_group['photos'] as $photo)
                    <a class="costume-img" href="{{$photo->documentUrl()}}" style="margin: 0px;">
                        <img data-src="{{$photo->documentUrl()}}" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="{{$photo->documentUrl()}}" class="gallery-img costume-img hk-gallery">
                        </br>
                        <input item_id="{{$photo->id}}" type_document="{{$photos_group['type_document']}}" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                    </a>


                    @endforeach
                </div>
                @endforeach
            </div>


        </div>
    </div>
</div>