@extends('layouts.app')
@section('added_css')
@endsection
@section('content')
<div style="padding-top: 16px;margin-left: 8px;">

    <div style="margin-top:8px;padding-left: 10px;padding-right: 10px;">
        <div class="box" style="margin-bottom: 0.5em;border: none;">
            <div class="filters" style="margin-bottom: 4px;">
                <div class="row">
                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Province :</span>
                            </div>
                            <select id="provinces_filter" class="form-control select2 m-tout dt_filter" column="dossiers.province_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($provinces as $province)
                                <option value="{{$province->id}}">{{$province->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3" style="display: none;">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">District :</span>
                            </div>
                            <select id="cercles_filter" class="form-control select2 m-tout dt_filter" column="dossiers.cercle_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($cercles as $cercle)
                                <option value="{{$cercle->id}}">{{$cercle->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">District :</span>
                            </div>
                            <select id="communes_filter" class="form-control select2 m-tout dt_filter" column="dossiers.commune_id" table="">
                                <option value="all" selected>Indifferent</option>

                                @foreach($communes as $commune)
                                <option value="{{$commune->id}}">{{$commune->nom}}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Arrondissement :</span>
                            </div>
                            <select id="douars_filter" class="form-control select2 m-tout dt_filter" column="dossiers.douar_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($douars as $douar)
                                <option value="{{$douar->id}}">{{$douar->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>


                    @if(Auth::user()->has_role('Observateur filiale') || Auth::user()->has_role("Vérificateur") || Auth::user()->has_role("Administrateur") || Auth::user()->has_role("GU") || Auth::user()->has_role("Observateur de suivi"))
                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Statut:</span>
                            </div>

                            <select class="form-control select2 m-tout dt_filter" column="dossiers.mi_verified" table="">
                                <option value="all" selected>Indifferent</option>
                                <option value="-1">En cours</option>
                                <option value="0">Non vérifié</option>
                                <option value="1">Vérifié</option>
                            </select>
                        </div>
                    </div>
                    @endif
                </div>



                <div class="row">



                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Etat d'avancement :</span>
                            </div>
                            <select id="etat_avancement_filter" class="form-control select2 m-tout custom_filter">
                                <option value="all" selected>Indifferent</option>
                                <option value="En cours d'étude">En cours d'étude</option>
                                <option value="Autorisé">Autorisé</option>
                                <option value="Travaux Gros œuvres">Travaux Gros œuvres</option>
                                <option value="Travaux de finition">Travaux de finition</option>
                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Déblocage Aide frontale :</span>
                            </div>
                            <select id="aide_frontale_filter" class="form-control select2 m-tout custom_filter">
                                <option value="all" selected>Indifferent</option>
                                <option value="1">Aide frontale N°1</option>
                                <option value="2">Aide frontale N°2</option>
                                <option value="3">Aide frontale N°3</option>
                                <option value="4">Aide frontale N°4</option>
                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Type :</span>
                            </div>
                            <select id="type_demande_filter" class="form-control select2 m-tout custom_filter" column="demande_type" table="">
                                <option value="all" selected>Indifferent</option>
                                <option value="reconstruction_partielle">Partielle</option>
                                <option value="reconstruction_totale">Totale</option>
                                <option value="NULL">Non identifié	</option>
                            </select>
                        </div>
                    </div>

                    @if(Auth::user()->has_role("Administrateur,GU,Observateur de suivi,Vérificateur,Observateur filiale"))
                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Prestataire :</span>
                            </div>
                            <select class="form-control select2 m-tout dt_filter " column="prestataire" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($prestataires as $prestataire)
                                <option value="{{$prestataire->id}}">{{$prestataire->organisme_ste}} - {{$prestataire->role->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    @endif
                </div>
                <hr>
                <div class="row">
                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Document :</span>
                            </div>
                            <select class="form-control select2 m-tout document_filter" id="type_document_filter">
                                <option value="all" selected>Indifferent</option>
                                <option value="NO_DOCUMENTS">Aucun dépôt</option>
                                <option value="PLAN_SITUATION_PDF">Plan de situation (PS)</option>
                                <option value="PLAN_ARCHITECTE_PDF">Plan d'architecte (PA)</option>
                                <option value="PLAN_BETON_ARME_PDF">Plan béton armé / ferraillage (PB)</option>
                                <option value="DEMANDE_AUTORISATION">Demande de l'autorisation (DA)</option>
                                <option value="AUTORISATION_CONSTRUIRE">Autorisation de construire (AC)</option>
                                <option value="ATTESTATION_IMPLANTATION">Attestation d'implantation (AI)</option>
                                <option value="OVERTURE_CHANTIER">Ouverture de chantier (OC)</option>
                                <option value="RECPTION_FONDS_FOUILLES">Réception des fonds de fouilles (RFF)</option>
                                <option value="CONTROLES_FONDATIONS">Contrôle des fondation (CF)</option>
                                <option value="RECPTION_FONDATIONS">Réception des fondations (RF)</option>
                                <option value="CONTROLE_STRUCTURE"> Contrôle de la structure (CS)</option>
                                <option value="RECEPTION_STRUCTURE">Réception de la structure (RS)</option>
                                <option value="ENGAGEMENT_ACHEVEMENT">Engagement d'achèvement (EA)</option>
                                
                                <option value="PV_RECEPTION_FINITION">Réception du plancher haut RDC et finition (RDCF)</option>

                                
                                <option value="PV_FIN_TRAVAUX">Fin des travaux (FT)</option>


                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Etat :</span>
                            </div>
                            <select disabled class="form-control select2 m-tout" id="document_etat_filter">
                                <option value="all" selected>Déposé</option>
                                <option value="NO_DEPOT">Non déposé</option>
                                <option value="En attente">En attente</option>
                                <option value="Validé">Validé</option>
                                <option value="Rejeté">Rejeté</option>
                                <option value="CIN introuvable"> CIN introuvable</option>

                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Géometrie :</span>
                            </div>
                            <select class="form-control select2 m-tout dt_filter" column="geometry">
                                <option value="all" selected>Indifferent</option>
                                <option value="1">Oui</option>
                                <option value="0">Non</option>

                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Evacuation :</span>
                            </div>
                            <select class="form-control select2 m-tout dt_filter" column="evacuation">
                                <option value="all" selected>Indifferent</option>
                                <option value="oui">Oui</option>
                                <option value="non">Non</option>

                            </select>
                        </div>
                    </div>

                  

                </div>

                <hr>



            </div>
        </div>

        <div class="row">
            @if(Auth::user()->has_role('Agence urbaine') || Auth::user()->has_role("Chargé du guichet d'accompagnement"))
            <div class="col-3">
                <button id="avis_favorable_btn" disabled type="button" class="btn btn-success "><i class="fa-solid fa-check-double"></i>&nbsp;Avis favorable</button>
                @if(Auth::user()->has_role('Agence urbaine'))
                <button id="livrable_etat_avancement_btn" type="button" class="btn btn-success "><i class="fa-solid fa-file-pdf"></i>&nbsp;Etat d'avancement</button>
                @endif
            </div>

            <div class="col-9">
                <button style="float:right" id="commissions_btn" type="button" class="btn btn-success "><i class="fa-solid fa-user-check"></i>&nbsp;Commissions</button>
            </div>
            @endif

            @if(Auth::user()->has_role('Administrateur') || Auth::user()->has_role('GU'))
            <div class="col-3">
                <button style="display: none;" id="reaffecter_btn" disabled type="button" class="btn btn-success "><i class="fa-solid fa-check-double"></i>&nbsp;Réaffecter</button>
            </div>
            <div class="col-9">
            </div>
            @endif


        </div>

        @if(Auth::user()->deblocage_dossiers==1)
        <div class="row">
            <div class="col-3">
                <button id="deblocage_dossiers_btn" type="button" class="btn btn-success "><i class="fa-solid fa-lock-open"></i>&nbsp;Déblocage des dossiers</button>
            </div>
        </div>
        @endif

        <div class="table-responsive">

            <div class="row">
                <div class="col-lg-3">

                    <button class="mr-3 btn dossiers_table_export_excel"><i class="fa fa-file-excel-o"></i> Exporter Excel</button>
                    <span>Nombre des dossiers : <b style="color:#63a013" id="dt_dossiers_count">0</b></span>
                </div>
                <div class="col-lg-3">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" style="width: 160px;">Déblaiement :</span>
                        </div>
                        <select column="dossiers.deblaiement" table="" class="form-control select2 m-tout dt_filter">
                            <option value="all" selected>Indifferent</option>
                            <option value="Non renseigné">Non renseigné</option>
                            <option value="Déblayée et nettoyée">Déblayée et nettoyée</option>
                            <option value="Déblayée non nettoyée">Déblayée non nettoyée</option>
                            <option value="Non déblayée">Non déblayée</option>
                        </select>
                    </div>
                </div>

                <div class="input-group input-group-sm col-3">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" style="width: 160px;">CIN :</span>
                        </div>
                        <input placeholder="CIN" class="form-control dt_filter" column="cin" table="petitionnaires" sparams="remove_spaces">
                    </div>
                </div>

                <div class="input-group input-group-sm col-3">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" style="width: 160px;">Numéro du dossier :</span>
                        </div>
                        <input placeholder="Numéro" class="form-control dt_filter" column="dossiers.numero" table="">
                    </div>
                </div>

            </div>

            <table class="table table-striped datatables dataTable no-footer display nowrap" id="dossiers_table" style="min-width: 1200px;">
                <thead>
                    <th>N°</th>
                    <th>Province</th>
                    <th>Commune</th>
                    <th>Douar</th>
                    <th>Pétitionnaire</th>
                    <th>CIN</th>
                    <th>Tél</th>
                    <th>Type</th>
                    <th>Architecte</th>
                    <th>IGT</th>
                    <th>BET</th>
                    <th>Laboratoire</th> 
                    <th>Avancement</th>
                    <th>Aide frontale</th>
                    <th>Dépôt</th>
                    <th>Date dossier</th>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>

@include('dossiers/modals_index')

@endsection
@push('added_scripts')
<script>
    var provinces = @json($provinces);
    var cercles = @json($cercles);
    var communes = @json($communes);
    var douars = @json($douars);
</script>
<script src="{{asset('js/dossiers/index.js').'?t='.time()}}"></script>


@endpush