@extends('layouts.app')
@section('added_css')
@endsection
@section('content')
<div style="padding-top: 16px;margin-left: 8px;">
    <nav class="hk-breadcrumb" aria-label="breadcrumb">
        @if(Auth::user()->has_role('Vérificateur'))
        @if(request()->from_v1 == "1")
        <button class="mr-3 btn next_btn" style="background: #e4e4e4 !important;border: 1px gray solid !important;float: right;"><i class="fa-solid fa-arrow-right"></i>&nbsp; Dossier suivant</button>
        @endif

        @if(request()->from_v2 == "1")
        <button class="mr-3 btn next_v2_btn" style="background: #e4e4e4 !important;border: 1px gray solid !important;float: right;"><i class="fa-solid fa-arrow-right"></i>&nbsp; Dossier suivant</button>
        @endif
        @endif
        <ol class="breadcrumb breadcrumb-light bg-transparent">
            <li class="breadcrumb-item"><a href="{{route('demandes')}}">Dossiers</a></li>
            <li class="breadcrumb-item"><a href="{{route('demandes')}}">Demande N° {{$dossier->demande->numero}}</a>
            </li>
            <li class="breadcrumb-item " aria-current="page">Dossier N° {{$dossier->numero}}</li>

            @if(Auth::user()->has_role('Vérificateur'))
            @if($dossier->mi_verified == 10)
            <span class="badge badge-primary" style="color:#0d9fe6;font-size: 0.7rem; margin-left: 8px;"> <i style="color:#0d9fe6" class="fa-solid fa-circle-check"></i>&nbspVérifié</span>
            @endif
            @if($dossier->mi_verified == 10)
            <span class="badge badge-primary" style="color:#c3c3c3;font-size: 0.7rem; margin-left: 8px;"> <i style="color:#c3c3c3" class="fa-solid fa-circle-check"></i>&nbspNon vérifié</span>
            @endif
            @if($dossier->mi_verified == 20)
            <span class="badge badge-primary" style="color:#d9a211;font-size: 0.7rem; margin-left: 8px;"> <i style="color:#d9a211" class="fa-solid fa-clock"></i>&nbspEn cours</span>
            @endif
            @endif
        </ol>
    </nav>

    @if(Auth::user()->has_role('Vérificateur'))
    <ul class="nav nav-tabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link {{(request()->tab == "verification-tab")?'':'active'}}" id="donnees-tab" data-toggle="tab" data-target="#donnees" type="button" role="tab" aria-controls="donnees" aria-selected="true">Données</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link {{(request()->tab == "verification-tab")?'active':''}}" id="verification-tab" data-toggle="tab" data-target="#verification" type="button" role="tab" aria-controls="verification" aria-selected="false">Vérification</button>
        </li>
    </ul>
    @endif
    <div class="tab-content" id="myTabContent">
        <div class="tab-pane fade {{(request()->tab == "verification-tab")?'':'active show'}}" id="donnees" role="tabpanel" aria-labelledby="donnees-tab">
            <div class="row">
                <div class="col-12 col-md-9">
                    @if($dossier->created_from_rehab==1)
                    <div class="card card-refresh mt-2">
                        <div class="refresh-container">
                            <div class="loader-pendulums"></div>
                        </div>
                        <div class="card-header card-header-action">
                            <h5 style="margin: 2px !important;color: #2273ae;font-size: 15px;">Documents de dossier de réhabilitation</h5>
                            <div class="d-flex align-items-center card-action-wrap">
                                <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_2" aria-expanded="true">
                                    <i class="zmdi zmdi-chevron-down"></i>
                                </a>

                            </div>
                        </div>
                        <div id="collapse_2" class="collapse show">
                            <div class="card-body">

                                <table class="table rtable datatables table-striped no-footer display nowrap">
                                    <thead>
                                        <th>Document</th>
                                        <th>Type du fichier</th>
                                        <th>Date dépôt</th>
                                        <th></th>
                                        <th></th>
                                    </thead>
                                    <tbody>
                                        @foreach($dossier_rehab_docs as $dossiers_rehab_doc)
                                        <tr>
                                            <td><i class="fa-solid fa-file-pdf"></i>&nbsp{{$dossiers_rehab_doc['name']}}
                                                @if($dossiers_rehab_doc['document']!=null && $dossiers_rehab_doc['validation']==1)
                                                <span style="font-weight:bold;color:{{$dossiers_rehab_doc['document']->decision_color()}}"> - {{$dossiers_rehab_doc['document']->decision}}</span>
                                                @endif
                                            </td>
                                            <td>Fichier {{strtoupper($dossiers_rehab_doc['file_type'])}}</td>
                                            <td>
                                                @if(is_null($dossiers_rehab_doc['document']))
                                                <span type_document="{{$dossiers_rehab_doc['type_document']}}" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                                @else
                                                <span type_document="{{$dossiers_rehab_doc['type_document']}}" class="download_depot_date" style="color:black">{{$dossiers_rehab_doc['document']->formated_created_at()}} - <span style="color:coral">{{$dossiers_rehab_doc['document']->user->organisme_ste}} <span></span>
                                                        @endif
                                            </td>

                                            <td>
                                                @if(Auth::user()->has_role($dossiers_rehab_doc['w_roles']) && $dossiers_rehab_doc['active']==1)
                                                <button type_document="{{$dossiers_rehab_doc['type_document']}}" file_type="{{$dossiers_rehab_doc['file_type']}}" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                                @endif
                                            </td>
                                            <td>
                                                @if(is_null($dossiers_rehab_doc['document']))
                                                <button type_document="{{$dossiers_rehab_doc['type_document']}}" file_id="" disabled type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                                @else
                                                <button type_document="{{$dossiers_rehab_doc['type_document']}}" file_id="{{$dossiers_rehab_doc['document']->id}}" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>


                            </div>
                        </div>

                    </div>
                    @endif

                    @if($dossier->pv_expertise==0)
                    @if($dossier->douar->block_dossiers==1 || $dossier->etude_geotechnique_area_non_constructible>0 || $dossier->etude_geotechnique_area_constructible_conditions_strictes>0)
                    <div class="row" style="width: 100%;">
                        <div class="col-12 m-step-af success" style="background: #ec5858;color: white;border: 1px red;border-radius: 4px;padding: 12px;">
                            <i class="fa-solid fa-lock"></i>&nbsp Le dossier actuel se trouve dans une zone désignée par le laboratoire comme non constructible. Par conséquent, vous ne pouvez pas poursuivre leur traitement
                            <input type="file" id="unblock_geometry_input" style="display: none;" />
                            @if(Auth::user()->id=="5fe818a2-ba62-4a78-9c7d-9616d29c353f")
                            <button style="margin: 0px; padding: 0px; float: right; color: white;" type="button" class="btn btn-success unblock_geometry"><i class="fa-solid fa-download "></i>&nbsp;Débloquer</button>
                            @endif
                        </div>
                    </div>
                    @endif
                    @else
                    <div class="row" style="width: 100%;">
                        <div class="col-12 m-step-af success" style="background: #65b47e;color: white;border: 1px red;border-radius: 4px;padding: 12px;">
                            <i class="fa-solid fa-unlock"></i>&nbspDossier débloqué suite au PV d’expertise, chargé le <b>{{$pv_expertise->formated_created_at()}}</b> par <b>{{$pv_expertise->user->organisme_ste}}</b>,<a href="/dossiers/file/{{$pv_expertise->id}}">Télécharger</a>
                        </div>
                    </div>
                    @endif

                    @include('dossiers/detail_info_generales')
                    @include('dossiers/detail_etude_geotechnique')
                    @include('dossiers/detail_evacuation')
                    @include('dossiers/detail_demolition')
                    @include('dossiers/detail_permis_construire')                    
                 

                    @include('dossiers/detail_travaux_construction')
                    @include('dossiers/detail_documents_aide_frontale_1')
                    <br>
                    <div class="row" style="{{Auth::user()->has_role('Vérificateur,Financier,Observateur,Chef du projet,Administrateur,GU')?'':'display:none'}}">
                        <div class="col-3" style="padding-right:0px">
                            <div style="height: 1px;background: #adadad;margin: auto;display: block;margin-top: 22px;">
                            </div>
                        </div>
                        <div class="col-6" style="padding-left:0px;padding-right:0px">
                            <div class="alert alert-inv alert-inv-primary {{$dossier->check_step_in_log('AIDE_FRONTALE_1')?'success':''}}" role="alert">Aide frontale N°1</div>
                        </div>
                        <div class="col-3" style="padding-left:0px">
                            <div style="height: 1px;background: #adadad;margin: auto;display: block;margin-top: 22px;">
                            </div>
                        </div>
                    </div>
                    <!-- <div class="row">
                        <div class="col-3" style="padding-right:0px">
                            <div style="height: 1px;background: #adadad;margin: auto;display: block;margin-top: 22px;">
                            </div>
                        </div>
                        <div class="col-6" style="padding-left:0px;padding-right:0px">
                            <div class="alert alert-inv alert-inv-primary {{$dossier->check_step_in_log('AIDE_FRONTALE_1')?'success':''}}">Aide frontale N°1</div>
                        </div>
                        <div class="col-3" style="padding-left:0px">
                            <div style="height: 1px;background: #adadad;margin: auto;display: block;margin-top: 22px;">
                            </div>
                        </div>
                    </div> -->
                    @include('dossiers/detail_fondations')
                    <div class="row" style="{{Auth::user()->has_role('Vérificateur,Financier,Observateur,Chef du projet,Administrateur,GU')?'':'display:none'}}">
                        <div class="col-3" style="padding-right:0px">
                            <div style="height: 1px;background: #adadad;margin: auto;display: block;margin-top: 22px;">
                            </div>
                        </div>
                        <div class="col-6" style="padding-left:0px;padding-right:0px">
                            <div class="alert alert-inv alert-inv-primary {{$dossier->check_step_in_log('AIDE_FRONTALE_2')?'success':''}}" role="alert">Aide frontale N°2</div>
                        </div>
                        <div class="col-3" style="padding-left:0px">
                            <div style="height: 1px;background: #adadad;margin: auto;display: block;margin-top: 22px;">
                            </div>
                        </div>
                    </div>
                    @include('dossiers/detail_structure')
                    <div class="row" style="{{Auth::user()->has_role('Vérificateur,Financier,Observateur,Chef du projet,Administrateur,GU')?'':'display:none'}}">
                        <div class="col-3" style="padding-right:0px">
                            <div style="height: 1px;background: #adadad;margin: auto;display: block;margin-top: 22px;">
                            </div>
                        </div>
                        <div class="col-6" style="padding-left:0px;padding-right:0px">
                            <div class="alert alert-inv alert-inv-primary {{$dossier->check_step_in_log('AIDE_FRONTALE_3')?'success':''}}" role="alert">Aide frontale N°3</div>
                        </div>
                        <div class="col-3" style="padding-left:0px">
                            <div style="height: 1px;background: #adadad;margin: auto;display: block;margin-top: 22px;">
                            </div>
                        </div>
                    </div>
                    @include('dossiers/detail_reception_plancher')
                    <div class="row" style="{{Auth::user()->has_role('Vérificateur,Financier,Observateur,Chef du projet,Administrateur,GU')?'':'display:none'}}">
                        <div class="col-3" style="padding-right:0px">
                            <div style="height: 1px;background: #adadad;margin: auto;display: block;margin-top: 22px;">
                            </div>
                        </div>
                        <div class="col-6" style="padding-left:0px;padding-right:0px">
                            <div class="alert alert-inv alert-inv-primary {{$dossier->check_step_in_log('AIDE_FRONTALE_4')?'success':''}}" role="alert">Aide frontale N°4</div>
                        </div>
                        <div class="col-3" style="padding-left:0px">
                            <div style="height: 1px;background: #adadad;margin: auto;display: block;margin-top: 22px;">
                            </div>
                        </div>
                    </div>
                    @include('dossiers/detail_finition')
                    <div class="mb-3"></div>
                </div>
                <div class="col-12 col-md-3 " style="padding-top: 8px;">
                    <div class="row" style="background: #ffffff; padding: 8px; border-radius: 6px; border: 1px #003366 solid;">
                        <i style="text-align: center; margin: auto; font-size:20px; color: #d07979;" class="fa-regular fa-folder-open"></i>
                        <b class="mt-2" style="font-size: 0.8rem;color: #2273ae;width:100%;text-align: center;">Dossier
                            N° : {{$dossier->numero}}</b>
                            @if(Auth::user()->has_role('Administrateur,GU,Observateur'))
                                <a href="{{asset('').'demandes/show_eq/'.$dossier->demande->id}}" class="mt-2" style="font-size: 0.8rem;color: #2273ae;width:100%;text-align: center;">Demande N° :
                                    {{$dossier->demande->numero}}</a>
                            @endif
                        @if(Auth::user()->has_role('Architecte,IGT'))
                        <div class="col-12">
                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1 mt-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 120px;">Type :</span>
                                    </div>
                                    <select {{$dossier->demande->type_locked==1?'disabled':''}} id="demande_type" class="form-control select2nc">
                                        <option {{(is_null($dossier->demande->type)?'selected':'')}} value="">Veuillez
                                            sélectionner</option>
                                        <option {{($dossier->demande->type=='T'?'selected':'')}} value="T">Totale
                                        </option>
                                        <option {{($dossier->demande->type=='P'?'selected':'')}} value="P">Partielle
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>


                        @else
                        <div class="col-12">
                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1 mt-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 120px;">Type :</span>
                                    </div>
                                    <input disabled="" style="width: 30px;" value="{{$dossier->demande->type=='T'?'Totale':($dossier->demande->type=='P'?'Partielle':'Non identifié')}}" type="text" class="form-control" placeholder="" aria-label="">

                                </div>
                            </div>
                        </div>
                        @endif
                        <div class="col-12">
                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1 mt-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 120px;">Etat d'avancement :</span>
                                    </div>
                                    <input disabled="" style="width: 30px;" value="{{$dossier->etat_avancement()}}" type="text" class="form-control" placeholder="" aria-label="">
                                </div>
                            </div>
                        </div>
                        <h6>Traitement</h6>
                        <div class="row ml-2 m-step success">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Saisie de la demande</b>
                            </div>
                        </div>
                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('PROMESSE_EVACUATION')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Promesse d'evacuation</b>
                            </div>
                        </div>
                        <div class="row ml-2 m-step  {{$dossier->check_step_in_log('ATTESTATION_EVACUATION')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Attestation d'evacuation</b>
                            </div>
                        </div>
                        <div class="row ml-2 m-step  {{$dossier->check_step_in_log('EVACUATION_100')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Evacuation 100%</b>
                            </div>
                        </div>
                        <div class="row mt-2" style="width: 100%;">
                            <div class="col-12 mb-2 m-step-af {{$dossier->check_step_in_log('AIDE_FRONTALE_0')?'success':'pending'}}">
                                <div class="row ml-2 m-step {{$dossier->check_step_in_log('AIDE_FRONTALE_0')?'success':'pending'}}" style="text-align: center; width: 100%; display: block;">
                                    <div>
                                        <i class="pending-icon fa-regular fa-clock"></i>
                                        <i class="success-icon fa-solid fa-check"></i>
                                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                        <b class="ml-1">Indemnité d’évacuation</b>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('DEMANDE_AUTORISATION')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Demande de l'autorisation</b>
                            </div>
                        </div>
                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('QUITANCE_PAIEMENT')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Paiement des taxes</b>
                            </div>
                        </div>


                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('AUTORISATION_CONSTRUIRE')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Autorisation de construire</b>
                            </div>
                        </div>


                        <div class="row mt-2" style="width: 100%;">
                            <div class="col-12 mb-2 m-step-af {{$dossier->check_step_in_log('AIDE_FRONTALE_1')?'success':'pending'}}">
                                <div class="row ml-2 m-step {{$dossier->check_step_in_log('AIDE_FRONTALE_1')?'success':'pending'}}" style="text-align: center; width: 100%; display: block;">
                                    <div>
                                        <i class="pending-icon fa-regular fa-clock"></i>
                                        <i class="success-icon fa-solid fa-check"></i>
                                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                        <b class="ml-1">Aide frontale N°1</b>
                                    </div>
                                </div>
                            </div>
                        </div>

                      

                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('OVERTURE_CHANTIER')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Ouverture de chantier</b>
                            </div>
                        </div>



                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('RECEPTION_FONDATIONS')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Réception des fondations</b>
                            </div>
                        </div>


                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('PV_AF_2')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">PV d'aide frontale</b>
                            </div>
                        </div>
 

                        <div class="row mt-2" style="width: 100%;">

                            <div class="col-12 mb-2 m-step-af {{$dossier->check_step_in_log('AIDE_FRONTALE_2')?'success':'pending'}}">
                                <div class="row ml-2 m-step {{$dossier->check_step_in_log('AIDE_FRONTALE_2')?'success':'pending'}}" style="text-align: center; width: 100%; display: block;">
                                    <div>
                                        <i class="pending-icon fa-regular fa-clock"></i>
                                        <i class="success-icon fa-solid fa-check"></i>
                                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                        <b class="ml-1">Aide frontale N°2</b>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('RECEPTION_STRUCTURES')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Réception des structures</b>
                            </div>
                        </div>


                         <div class="row ml-2 m-step {{$dossier->check_step_in_log('PV_AF_3')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">PV d'aide frontale</b>
                            </div>
                        </div>

                        


                        <div class="row mt-2" style="width: 100%;">

                            <div class="col-12 mb-2 m-step-af  {{$dossier->check_step_in_log('AIDE_FRONTALE_3')?'success':'pending'}}">
                                <div class="row ml-2 m-step  {{$dossier->check_step_in_log('AIDE_FRONTALE_3')?'success':'pending'}}" style="text-align: center; width: 100%; display: block;">
                                    <div>
                                        <i class="pending-icon fa-regular fa-clock"></i>
                                        <i class="success-icon fa-solid fa-check"></i>
                                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                        <b class="ml-1">Aide frontale N°3</b>
                                    </div>
                                </div>
                            </div>

                        </div>

                     

                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('RECEPTION_FINITION')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Réception du plancher haut RDC et finition</b>
                            </div>
                        </div>


                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('PV_AF_4')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">PV d'aide frontale</b>
                            </div>
                        </div>

                         

                        <div class="row mt-2" style="width: 100%;">

                            <div class="col-12 mb-2 m-step-af {{$dossier->check_step_in_log('AIDE_FRONTALE_4')?'success':'pending'}}">
                                <div class="row ml-2 m-step  {{$dossier->check_step_in_log('AIDE_FRONTALE_4')?'success':'pending'}}" style="text-align: center; width: 100%; display: block;">
                                    <div>
                                        <i class="pending-icon fa-regular fa-clock"></i>
                                        <i class="success-icon fa-solid fa-check"></i>
                                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                        <b class="ml-1">Aide frontale N°4</b>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('FINITION_TRAVAUX')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Fin des travaux</b>
                            </div>
                        </div>

                        <div class="row ml-2 m-step {{$dossier->check_step_in_log('PERMIS_HABITER')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Permis d'habiter</b>
                            </div>
                        </div>


                        <div style="display: none;">

                       
                        <h6>Etat déclaré par les autorités locales</h6>
                        @if(is_null($last_al_etat))
                        <b style="color:black;margin-left:12px;width: 100%;display:block">Etat déclaré : <b style="color:gray;">Néant</b></b>
                      
                        @else
                        <b style="color:black;margin-left:12px;width: 100%;display:block">Etat déclaré : <b style="color:#7DA727;">{{$last_al_etat->etat}}</b></b>
                         @if(!is_null($last_al_etat_photo))
                            <img style="display: block; height: 200px; width: 100%; object-fit: contain; border: 1px gray solid; background: #505050; border-radius: 8px; margin: 8px;" src="{{$last_al_etat_photo->documentUrl()}}">
                        @endif

                        @endif


                        <h6>Guichet d'accompagnement</h6>
                        @if(!is_null($dossier->specific_document('RECEPISSE')))

                        <b style="color:#7DA727;margin-left:12px;">Guichet :
                            @if(!is_null($dossier->specific_document('RECEPISSE')->guichet))
                            {{$dossier->specific_document('RECEPISSE')->guichet->nom}}
                            @endif
                        </b>
                        @else
                        <b style="color:gray;margin-left:12px;">Récépissé n'a pas encore été mise en ligne.</b>
                        @endif
                        </div>

                        <h6>Prestataires</h6>
                        <table id="demandes_petetionnaire_modal_documents_table" class="table table-hover datatables dataTable no-footer display nowrap">
                            <thead>
                                <th>Raison sociale</th>
                                <th>Mission</th>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="font-weight: 500; color: #1a8fb8;"><a type="architecte" style="color: {{!is_null($dossier->demande->Architecte)?'#94AC09':'#808080'}} !important;" item_id="{{is_null($dossier->demande->Architecte)?'-':$dossier->demande->Architecte->id}}" class="prestataire_info_btn" href="javascript:;"><i class="fa-solid fa-building"></i>&nbsp{{is_null($dossier->demande->Architecte)?'non
                                            spécifié':$dossier->demande->Architecte->organisme_ste}}</a></td>
                                    <td>Architecte</td>
                                </tr>
                                <tr>
                                    <td style="font-weight: 500; color: #1a8fb8;"><a type="igt" style="color: {{!is_null($dossier->demande->igt)?'#94AC09':'#808080'}} !important;" item_id="{{is_null($dossier->demande->igt)?'-':$dossier->demande->igt->id}}" class="prestataire_info_btn" href="javascript:;"><i class="fa-solid fa-building"></i>&nbsp{{is_null($dossier->demande->igt)?'non
                                            spécifié':$dossier->demande->igt->organisme_ste}}</a></td>
                                    <td>Topographe</td>
                                </tr>
                                <tr>
                                    <td style="font-weight: 500; color: #1a8fb8;"><a type="laboratoire" style="color: {{!is_null($dossier->demande->laboratoire)?'#94AC09':'#808080'}} !important;" item_id="{{is_null($dossier->demande->laboratoire)?'-':$dossier->demande->laboratoire->id}}" class="prestataire_info_btn" href="javascript:;"><i class="fa-solid fa-building"></i>&nbsp{{is_null($dossier->demande->laboratoire)?'non
                                            spécifié':$dossier->demande->laboratoire->organisme_ste}}</a></td>
                                    <td>Laboratoire</td>
                                </tr>
                                <tr>
                                    @if(Auth::user()->role->name=="Architecte")
                                    <td style="font-weight: 500; color: #1E85E1;"><a type="bet" style="color: {{!is_null($dossier->demande->bet)?'#94AC09':'#1E85E1'}} !important;" item_id="{{is_null($dossier->demande->bet)?'-':$dossier->demande->bet->id}}" class="prestataire_info_btn" href="javascript:;"><i class="fa-solid fa-building"></i>&nbsp{{is_null($dossier->demande->bet)?'non
                                            spécifié':$dossier->demande->bet->organisme_ste}}</a> </td>
                                    @else
                                    <td style="font-weight: 500; color: #1a8fb8;"><a style="color: {{!is_null($dossier->demande->bet)?'#94AC09':'#808080'}} !important;" item_id="{{is_null($dossier->demande->bet)?'-':$dossier->demande->bet->id}}" class="prestataire_info_btn"><i class="fa-solid fa-building"></i>&nbsp{{is_null($dossier->demande->bet)?'non
                                            spécifié':$dossier->demande->bet->organisme_ste}}</a> </td>

                                    @endif
                                    <td>Bureau d'études</td>
                                </tr>

                            </tbody>
                        </table>
                        @if(Auth::user()->has_role('GU,Architecte,Financier,IGT,Laboratoire,BET,Bureau de contrôle,Chef du projet'))
                        <button id="save_dossier" style="width: 100%; background: #dddddd !important; border: 1px #a1a1a1 solid !important;" type="button" class="btn">
                            <span style="display: none;" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                            Enregistrer
                        </button>
                        @endif

                        <!-- @if(Auth::user()->has_role('Administrateur'))
                        <button id="delete_btn" type="button" class="btn btn-danger" style="width: 100%;">
                            <i class="fa-solid fa-trash"></i>&nbspSupprimer le dossier
                        </button>
                        @endif -->

                        <!-- @if(Auth::user()->has_role('Administrateur'))
                        <button id="switch_rehab_btn" type="button" class="btn btn-warning" style="width: 100%;">
                            <i class="fa-solid fa-repeat"></i>&nbspConvertir en dossier de réhabilitation
                        </button>
                        @endif -->
                    </div>

                </div>
            </div>

        </div>
        <div class="tab-pane fade {{(request()->tab == "verification-tab")?'active show':''}}" id="verification" role="tabpanel" aria-labelledby="verification-tab">
            @include('dossiers/verification')
        </div>

    </div>



</div>
@include('dossiers.modals')

@if(Auth::user()->has_role('Vérificateur'))
@include('dossiers.modals_verification')
@endif
@endsection

@push('added_scripts')
<script>
    var dossier = @json($dossier);
</script>

<script src="{{asset('js/dossiers/show.js').'?t='.time()}}"></script>
<script src="{{asset('js/dossiers/detail_info_generales.js').'?t='.time()}}"></script>
<script src="{{asset('js/dossiers/detail_etude_geotechnique.js').'?t='.time()}}"></script>
<script src="{{asset('js/dossiers/detail_agence_urbaine.js').'?t='.time()}}"></script>
@if(Auth::user()->has_role('Vérificateur'))
<script src="{{asset('js/dossiers/verification.js').'?t='.time()}}"></script>
@endif

<script>
    $(document).ready(function() {
        for (var i = 0; i < dossier.demande.petitionnaires.length; i++) {
            petitionnaires_add(dossier.demande.petitionnaires[i]);
        }
    });
</script>
@endpush