<div class="row mt-3" id="declarations">
    <div class="col-12">
        <table class="table rtable datatables table-striped no-footer display nowrap">
            <thead>
                <th>Document</th>
                <th>Type du fichier</th>
                <th>Date dépôt</th>
                <th>Date document</th>
                <th></th>
                <th></th>
            </thead>
            <tbody>
                @foreach($declaration_documents_list as $declaration_doc)
                <tr>
                    <td><i class="fa-solid fa-file-pdf"></i>&nbsp{{$declaration_doc['name']}}
                        @if($declaration_doc['document']!=null &&
                        $declaration_doc['validation']==1)
                        <span style="font-weight:bold;color:{{$declaration_doc['document']->decision_color()}}">
                            -
                            {{$declaration_doc['document']->decision_full()}}</span>
                        @endif
                    </td>
                    <td>Fichier {{strtoupper($declaration_doc['file_type'])}}</td>
                    <td>
                        @if(is_null($declaration_doc['document']))
                        <span type_document="{{$declaration_doc['type_document']}}" class="download_depot_date"
                            style="color:gray">Aucun fichier
                            importé</span>
                        @else
                        <span type_document="{{$declaration_doc['type_document']}}" class="download_depot_date"
                            style="color:black">{{$declaration_doc['document']->formated_created_at()}}
                            - <span style="color:coral">{{$declaration_doc['document']->user->nom.'
                                '.$declaration_doc['document']->user->prenom}}

                                @endif
                    </td>

                    <td>
                        @if(!is_null($declaration_doc['document']))
                        <span>{{$declaration_doc['document']->formated_date_document()}}
                        </span>
                        @else
                        <span type_document="{{$declaration_doc['type_document']}}" style="color:gray">Aucun fichier
                            importé</span>
                        @endif
                    </td>
                    <td>
                        @if(is_null($declaration_doc['document']))
                        <button type_document="{{$declaration_doc['type_document']}}"
                            file_type="{{$declaration_doc['file_type']}}" type="button"
                            class="btn btn-light upload_doc_link"> <i
                                class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                        @endif
                    </td>
                    <td>
                        @if(is_null($declaration_doc['document']))
                        <button type_document="{{$declaration_doc['type_document']}}" file_id="" disabled type="button"
                            class="btn btn-success download_doc_link"><i
                                class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                        @else
                        <button type_document="{{$declaration_doc['type_document']}}"
                            file_id="{{$declaration_doc['document']->id}}" type="button"
                            class="btn btn-success download_doc_link"><i
                                class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                        @endif
                    </td>
                </tr>
                @endforeach

            </tbody>
        </table>
    </div>



    <div class="col-12 mt-2">
        <div class="row">
            <div class="col-md-4 col-12">
                <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                    <div>
                        @if(is_null($declaration_document['document']))
                        <i type_document="{{$declaration_document['type_document']}}"
                            style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;"
                            class="fa-solid fa-file-pdf-o upload_doc_icon"></i>
                        @else
                        <i type_document="{{$declaration_document['type_document']}}"
                            style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;"
                            class="fa-solid fa-file-circle-check upload_doc_icon"></i>

                        @endif


                        <b class="mt-2 upload_doc_no_file_label"
                            style="color:gray;display: block; margin: auto;text-align: center;">
                            Génération de la déclaration
                        </b>

                        <div style="margin: auto; display: block;text-align: center;">
                            <form action="/declarations/generate-pdf" method="POST" target="_blank">
                                @csrf
                                <input type="hidden" name="terrain_id" id="terrain_id_liquidation_input"
                                    value="{{$terrain->id}}">

                                <div style="margin: auto; display: block;text-align: center;">

                                    @if($terrain->specific_document('PLAN_CADASTRAL_SITUATION_PDF') &&
                                    $terrain->specific_document('CERTIFICAT_ATTESTATION_PROPRIETE_PDF'))
                                    @if(!$terrain->specific_document('DECLARATION_PDF'))
                                    <button type="submit" type="button" class="btn btn-light"> <i
                                            class="fa-solid fa-plus"></i>&nbsp;Générer</button>
                                    @else
                                    <b class="mt-2 upload_doc_no_file_label"
                                        style="color:#0F91C8;display: block; margin: auto;text-align: center;">Générée
                                        par {{$terrain->specific_document('DECLARATION_PDF')->user->nom.'
                                        '.$terrain->specific_document('DECLARATION_PDF')->user->prenom}} -
                                        {{$terrain->specific_document('DECLARATION_PDF')->formated_created_at()}}</b>
                                    @endif
                                    @else
                                    <b class="mt-2 upload_doc_no_file_label"
                                        style="color:#0F91C8;display: block; margin: auto;text-align: center;">Les
                                        documents nécessaires non importés</b>
                                    @endif
                                </div>
                            </form>
                        </div>


                    </div>
                </div>
            </div>
            <div class="col-md-4 col-12">
                <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                    <div>
                        @if(is_null($declaration_document['document']))
                        <i type_document="{{$declaration_document['type_document']}}"
                            style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;"
                            class="fa-solid fa-file-circle-xmark upload_doc_icon"></i>
                        @else
                        <i type_document="{{$declaration_document['type_document']}}"
                            style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;"
                            class="fa-solid fa-file-circle-check upload_doc_icon"></i>
                        @endif

                        @if(is_null($declaration_document['document']))
                        <b type_document="{{$declaration_document['type_document']}}"
                            class="mt-2 upload_doc_no_file_label"
                            style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                            fichier importé </b>
                        @endif
                        <div style="margin: auto; display: block;text-align: center;">
                            @if($terrain->specific_document('PLAN_CADASTRAL_SITUATION_PDF') &&
                            $terrain->specific_document('CERTIFICAT_ATTESTATION_PROPRIETE_PDF'))

                            @if( $declaration_document['active']==1)
                            @if(!$terrain->specific_document('DECLARATION_PDF'))
                            <button type_document="{{$declaration_document['type_document']}}"
                                file_type="{{$declaration_document['file_type']}}" type="button"
                                class="btn btn-light upload_doc_link"> <i
                                    class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                            @else
                            <b class="mt-2 upload_doc_no_file_label"
                                style="color:#0F91C8;display: block; margin: auto;text-align: center;">Déclaration
                                Importée</b>
                            @endif
                            @endif
                            @endif
                            @if(is_null($declaration_document['document']))
                            <button disabled type_document="{{$declaration_document['type_document']}}" file_id=""
                                type="button" class="btn btn-success download_doc_link"> <i
                                    class="fa-solid fa-plus"></i>&nbsp;Télécharger</button>
                            @else
                            <button type_document="{{$declaration_document['type_document']}}"
                                file_id="{{$declaration_document['document']->id}}" type="button"
                                class="btn btn-success download_doc_link">
                                <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                            @endif
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-4 col-12">
                <div class="row">
                    <div class="col-12">
                        <b
                            style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Numéro
                            déclaration</b>
                        @if(is_null($declaration_document['document']))
                        <b type_document="{{$declaration_document['type_document']}}" class="mt-1 download_doc_numero"
                            style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                            fichier importé </b>
                        @else
                        <b type_document="{{$declaration_document['type_document']}}" class="mt-1 download_doc_numero"
                            style="color:black;display: block; margin: auto;text-align: center;">{{$declaration_document['document']->numero}}</b>
                        @endif
                    </div>
                    <div class="col-12 mt-3">
                        <b
                            style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date
                            déclaration</b>
                        @if(is_null($declaration_document['document']))
                        <b type_document="{{$declaration_document['type_document']}}" class="mt-1 download_doc_date"
                            style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                            fichier importé </b>
                        @else
                        <b type_document="{{$declaration_document['type_document']}}" class="mt-1 download_doc_date"
                            style="color:black;display: block; margin: auto;text-align: center;">{{$declaration_document['document']->formated_date_document()}}</b>
                        @endif
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>