@if(!$terrain->hasLiquidationThisYear())
<div class="row mt-3">
    <div class="col-md-4">
        <div class="input-group input-group-sm">
            <div class="input-group mb-1">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width: 140px;font-weight : bold">Montant
                        initial:</span>
                </div>
                <input readonly class="form-control" id="montant_initial"
                    value="{{ number_format($montant_initial, 2, '.', ' ') }} MAD">
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="input-group input-group-sm">
            <div class="input-group mb-1">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width: 140px;font-weight : bold">Montant sanctions
                        :</span>
                </div>
                <input readonly class="form-control" id="montant_sanctions"
                    value="{{ number_format($montant_sanctions, 2, '.', ' ') }} MAD">
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="input-group input-group-sm">
            <div class="input-group mb-1">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width: 140px;font-weight : bold">Montant total
                        :</span>
                </div>
                <input readonly class="form-control" id="montant_total"
                    value="{{ number_format($montant_total, 2, '.', ' ') }} MAD">
            </div>
        </div>
    </div>
</div>
@endif
@if(!$terrain->hasLiquidationThisYear())
<div class="col-12">
    <table class="table table-hover table-striped datatables dataTable no-footer display nowrap rtable"
        id="liquidation-table">
        <thead>
            <tr>
                <th>Année</th>
                <th>Sanction</th>
                <th>Montant</th>
            </tr>
        </thead>
        <tbody>
            @foreach($liquidations as $liquidation)
            <tr>
                <td rowspan="{{ count($liquidation['sanctions']) + 1 }}"
                    style="background: white !important;text-align : center"><b
                        style="font-weight: bold;color : #00b894;">{{ $liquidation['year'] }}</b></td>
                <td><b>Montant de la TNB</b></td>
                <td class="montant-tnb" data-amount="{{ $liquidation['montant_tnb'] }}"><b>{{
                        number_format($liquidation['montant_tnb'], 2, '.', ' ') }} MAD</b></td>
            </tr>
            @foreach($liquidation['sanctions'] as $index => $sanction)
            <tr style="border-bottom : 1px solid #f1f1f1;">
                <td><input type="checkbox" class="sanction-checkbox" data-year="{{ $liquidation['year'] }}"
                        data-index="{{ $index }}" data-amount="{{ $sanction['amount'] }}" checked>&nbsp;{{
                    $sanction['name'] }}</td>
                <td>{{ number_format($sanction['amount'], 2, '.', ' ') }} MAD</td>
            </tr>
            @endforeach
            @endforeach
        </tbody>
    </table>
</div>
@endif
<div class="row col-12 mt-3">
    <div class="col-md-4 col-12">
        <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
            <div>
                @if(is_null($liquidation_document['document']))
                <i type_document="{{$liquidation_document['type_document']}}"
                    style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;"
                    class="fa-solid fa-file-pdf-o upload_doc_icon"></i>
                @else
                <i type_document="{{$liquidation_document['type_document']}}"
                    style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;"
                    class="fa-solid fa-file-circle-check upload_doc_icon"></i>

                @endif


                <b class="mt-2 upload_doc_no_file_label"
                    style="color:gray;display: block; margin: auto;text-align: center;">
                    Génération de l'avis d'imposition
                </b>

                <form action="/liquidations/generate-pdf" method="POST" target="_blank">
                    @csrf
                    <input type="hidden" name="sanctions" id="sanctions_input">
                    <input type="hidden" name="montant_initial" id="montant_initial_input">
                    <input type="hidden" name="montant_sanctions" id="montant_sanctions_input">
                    <input type="hidden" name="montant_total" id="montant_total_input">
                    <input type="hidden" name="terrain_id" id="terrain_id_liquidation_input" value="{{$terrain->id}}">

                    <div style="margin: auto; display: block;text-align: center;">
                        @if(!$LIQUIDATION_LOCKED)
                        <button type="submit" type_document="{{$liquidation_document['type_document']}}"
                            file_type="{{$liquidation_document['file_type']}}" type="button"
                            class="btn btn-light generate_liquidation"> <i
                                class="fa-solid fa-plus"></i>&nbsp;Générer</button>
                        @endif
                    </div>
                </form>

            </div>
        </div>
    </div>
    <div class="col-md-4 col-12">
        <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
            <div>
                @if(is_null($liquidation_document['document']))
                <i type_document="{{$liquidation_document['type_document']}}"
                    style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;"
                    class="fa-solid fa-file-circle-xmark upload_doc_icon"></i>
                @else
                <i type_document="{{$liquidation_document['type_document']}}"
                    style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;"
                    class="fa-solid fa-file-circle-check upload_doc_icon"></i>
                @endif

                @if(is_null($liquidation_document['document']))
                <b type_document="{{$liquidation_document['type_document']}}" class="mt-2 upload_doc_no_file_label"
                    style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                    fichier importé </b>
                @endif
                <div style="margin: auto; display: block;text-align: center;">
                    @if(!$LIQUIDATION_LOCKED)
                    @if( $liquidation_document['active']==1)
                    <button type_document="{{$liquidation_document['type_document']}}"
                        file_type="{{$liquidation_document['file_type']}}" type="button"
                        class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                    @endif
                    @endif
                    @if(is_null($liquidation_document['document']))
                    <button disabled type_document="{{$liquidation_document['type_document']}}" file_id="" type="button"
                        class="btn btn-success download_doc_link"> <i
                            class="fa-solid fa-plus"></i>&nbsp;Télécharger</button>
                    @else
                    <button type_document="{{$liquidation_document['type_document']}}"
                        file_id="{{$liquidation_document['document']->id}}" type="button"
                        class="btn btn-success download_doc_link">
                        <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                    @endif
                </div>


            </div>
        </div>
    </div>

    <div class="col-md-4 col-12">
        <div class="row">
            @if($terrain->hasLiquidationThisYear())
            <div class="col-12">
                <b
                    style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Montant</b>
                @if($terrain->liquidations->isNotEmpty())
                @foreach($terrain->liquidations as $liquidation)
                <b class="mt-1" style="color:gray;display: block; margin: auto;text-align: center;"> {{
                    number_format($liquidation->montant, 2, '.', ' ') }} MAD </b>
                @endforeach
                @endif
            </div>
            <br>
            @endif
            <div class="col-12">
                <b
                    style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Numéro</b>
                @if(is_null($liquidation_document['document']))
                <b type_document="{{$liquidation_document['type_document']}}" class="mt-1 download_doc_numero"
                    style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                    fichier importé </b>
                @else
                <b type_document="{{$liquidation_document['type_document']}}" class="mt-1 download_doc_numero"
                    style="color:black;display: block; margin: auto;text-align: center;">{{$liquidation_document['document']->numero}}</b>
                @endif
            </div>
            <div class="col-12 mt-3">
                <b
                    style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date</b>
                @if(is_null($liquidation_document['document']))
                <b type_document="{{$liquidation_document['type_document']}}" class="mt-1 download_doc_date"
                    style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                    fichier importé </b>
                @else
                <b type_document="{{$liquidation_document['type_document']}}" class="mt-1 download_doc_date"
                    style="color:black;display: block; margin: auto;text-align: center;">{{$liquidation_document['document']->formated_date_document()}}</b>
                @endif
            </div>

        </div>
    </div>
</div>