<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Liquidation</title>
    <style>
        /* General styles */
        body {
            font-family: Arial, sans-serif;
            margin: 0px;
            font-size: 11px;
        }

        h1,
        h3 {
            text-align: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid black;
            padding: 2px;
            text-align: center;
        }

        th {
            background-color: #f9f9f9;
        }

    </style>
</head>

<body>
    <table style="width:100%">
        <tbody>
            <tr style="border :  0px solid;">
                <td style="width:25%;font-size : 0.8em;font-weight : bold;border :  0px solid">
                    <b><u>Royaume du Maroc</u></b> <br>
                    Ministère de l’Intérieur<br>
                    Préfecture M’diq- fnideq<br>
                    Commune de M’diq<br>
                    Direction des services<br>
                    Division des AF, E et A<br>
                    Service du Budget, AF et P<br>
                    Bureau d’Assiettes et DRF<br>

                </td>
                <td style="width:50%;border :  0px solid"></td>
                <td style="width:25%;border :  0px solid;text-align : center">
                     <img src="{{base_path('images/commune_mdiq.jpg')}}" width="60" height="60" alt="Logo">
                </td>
            </tr>
        </tbody>
    </table>

    <h2 style="text-align: center">Liquidation</h2>
    <hr style="height:1px;border:none;color:#333;background-color:#333;">
    <br>

    <table>
        <tbody>
            <tr>
                <td style="border :  0px solid;text-align :left;font-weight : bold">Article :</td>
                <td style="border :  0px solid;text-align :left">{{$terrain->article}}</td>
                <td style="border :  0px solid;text-align :lef;font-weight : bold">Référence foncière :</td>
                <td style="border :  0px solid;text-align :left">{{$terrain->ref}}</td>
                <td style="border :  0px solid;text-align :lef;font-weight : bold">Superficie (m²) :</td>
                <td style="border :  0px solid;text-align :left">{{$terrain->surface}}</td>
            </tr>
        </tbody>
    </table>
   
    <h3 style="text-align: center"><u>Redevables</u></h3>
    <table>
        <thead>
            <thead>
                <th style="width : 30%">Nom/ Raison sociale</th>
                <th style="width : 10%">CIN/RC</th>                
                <th style="width : 5%">Q.P</th>
                <th style="width : 10%">Téléphone</th>
                <th style="width : 30%">Adresse</th>
            </thead>
            <tbody>
                @foreach ($terrain->proprietaires as $proprietaire)
                    <tr>
                        <td>{{ $proprietaire->nom }} {{ $proprietaire->prenom }}</td>
                        @if($proprietaire->type === "physique")
                        <td>{{ $proprietaire->cine }}</td>
                        @elseif($proprietaire->type === "morale")
                        <td>{{ $proprietaire->rc }}-{{ $proprietaire->ville_rc }}</td>
                        @else
                        @endif                        
                        <td>{{ $proprietaire->pivot->quote_part ?? '—' }}</td>
                        <td>{{ $proprietaire->tel }}</td>
                        <td>{{ $proprietaire->adresse_redevable }}</td>
                    </tr>
                @endforeach              
            </tbody>
        </thead>
    </table>
    <br>
    <h3 style="text-align: center"><u>Montant</u></h3>
    <table>
        <thead>
            <tr>
                <th style="border : 0px solid;background-color : white"></th>
                <th style="border : 0px solid;background-color : white"></th>
                <th colspan="5" style="background-color : #cacaca;border : 1px solid black">Majorations</th>
                <th style="border : 0px solid;background-color : white"></th>
            </tr>
            <tr>
                <th>Année</th>
                <th>Montant de la TNB (DHS)</th>
                <th>Défaut de déclaration de terrain</th>
                <th>Paiement tardif</th>
                <th>Majoration pour le premier mois</th>
                <th>Retard (mois)</th>
                <th>Majoration pour chaque mois supplémentaires</th>
                <th>Montant a payer</th>
            </tr>
        </thead>
        <?php 
            $total_tnb = 0;
            $total_defaut_declaration = 0;
            $total_paiement_tardif = 0;
            $total_majoration_premier_mois = 0;
            $total_majoration_mois_supp = 0;
            $total_mois_supp = 0;
         ?>
        <tbody>
            @foreach($sanctionsData as $sanctionData)
            <tr>
                <td>{{ $sanctionData['year'] }}</td>
                <td>{{ number_format($sanctionData['Montant de la TNB'], 2, '.', ' ') }}</td>
                <?php $total_tnb +=  $sanctionData['Montant de la TNB'];?>

                {{-- Default de déclaration de terrain --}}
                @if(!empty($sanctionData['sanctions'][0]['Défaut de déclaration de terrain']))
                <td>{{ number_format($sanctionData['sanctions'][0]['Défaut de déclaration de terrain'], 2, '.', ' ') }}</td>
                <?php $total_defaut_declaration +=  $sanctionData['sanctions'][0]['Défaut de déclaration de terrain'];?>
                @else
                <td>0</td>
                @endif

                {{-- Paiement tardif --}}
                @if(!empty($sanctionData['sanctions'][0]['Paiement tardif']))
                <td>{{ number_format($sanctionData['sanctions'][0]['Paiement tardif'], 2, '.', ' ') }}</td>
                <?php $total_paiement_tardif +=  $sanctionData['sanctions'][0]['Paiement tardif'];?>
                @else
                <td>0</td>
                @endif

                {{-- Majoration pour le premier mois --}}
                @if(!empty($sanctionData['sanctions'][0]['Majoration pour le premier mois']))
                <td>{{ number_format($sanctionData['sanctions'][0]['Majoration pour le premier mois'], 2, '.', ' ') }}</td>
                <?php $total_majoration_premier_mois +=  $sanctionData['sanctions'][0]['Majoration pour le premier mois'];?>
                @else
                <td>0</td>
                @endif

                {{-- Majoration pour chaque mois supplémentaires --}}
                @if(!empty($sanctionData['sanctions'][0]['Majoration pour chaque mois supplémentaires']))
                <td>{{ ($sanctionData['sanctions'][0]['Majoration pour chaque mois supplémentaires'] / ($sanctionData['Montant de la TNB'] * 0.005)) }}</td>
                <td>{{ number_format($sanctionData['sanctions'][0]['Majoration pour chaque mois supplémentaires'], 2, '.', ' ') }}</td>
                <?php $total_majoration_mois_supp +=  $sanctionData['sanctions'][0]['Majoration pour chaque mois supplémentaires'];?>
                <?php $total_mois_supp +=  ($sanctionData['sanctions'][0]['Majoration pour chaque mois supplémentaires'] / ($sanctionData['Montant de la TNB'] * 0.005));?>
                @else
                <td>0</td>
                @endif

                <td style="border: 1px solid !important">{{ number_format(($sanctionData['sanctions'][0]['Majoration pour chaque mois supplémentaires'] + $sanctionData['sanctions'][0]['Majoration pour le premier mois'] + $sanctionData['sanctions'][0]['Paiement tardif'] + $sanctionData['sanctions'][0]['Défaut de déclaration de terrain'] + $sanctionData['Montant de la TNB']), 2, '.', ' ') }}</td>
            </tr>
            @endforeach
            <tr>
                <td colspan="7" style="border: 0px solid black"></td>
            </tr>
            <tr>
                <td><b>Total</b></td>
                <td>{{number_format($total_tnb, 2, '.', ' ') }} DH</td>
                <td>{{number_format($total_defaut_declaration, 2, '.', ' ') }} DH</td>
                <td>{{number_format($total_paiement_tardif, 2, '.', ' ') }} DH</td>
                <td>{{number_format($total_majoration_premier_mois, 2, '.', ' ') }} DH</td>
                <td>{{$total_mois_supp }}</td>
                <td>{{number_format($total_majoration_mois_supp, 2, '.', ' ') }} DH</td>
                <td><b>{{number_format($montant_total, 2, '.', ' ') }} DH</b></td>
            </tr>
        </tbody>
    </table>
    

   


</body>

</html>
