<?php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\GeoportailController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\CommissionsController;
use App\Http\Middleware\Authenticate;
use App\Http\Controllers\Indexing;
use App\Http\Controllers\TerrainsController;
use App\Http\Controllers\ProprietairesController;
use App\Http\Controllers\LiquidationsController;
use App\Http\Controllers\DeclarationsController;
use App\Http\Controllers\TerrainsNotificationsController;
use App\Http\Controllers\ZonesPAController;


use App\Http\Controllers\PagesController;
use App\Http\Controllers\CentreDonneesController;

use App\Http\Controllers\InvitationController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\StatisticsController;
use App\Http\Controllers\LivrablesController;
use App\Http\Controllers\SuiviController;
use App\Http\Controllers\VerificationsController;
use App\Http\Controllers\StorageManagerController;
use App\Http\Controllers\AttachementController;
use App\Http\Controllers\LoginSecurityController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\wtspController;
use App\Http\Controllers\ZoningController;



/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


//invitation
Route::get('/invitation/{user_id}/{token}', [InvitationController::class, 'show']);
Route::post('/invitation-save-pwd/', [InvitationController::class, 'invitation_save_pwd']);
Route::post('/send-forgotpwd-mail', [UserController::class, 'send_forgotpwd_mail']);
Route::get('/reset-pwd/{user_id}/{token}', [UserController::class, 'reset_pwd']);
Route::post('/reset-save-pwd', [UserController::class, 'reset_save_pwd']);

Auth::routes();
Route::get('/', [PagesController::class, 'index']);

Route::group(['prefix' => '2fa'], function () {


    Route::get('/', [LoginSecurityController::class, 'show2faForm'])->name("show2faForm");;
    Route::post('/generateSecret', [LoginSecurityController::class, 'generate2faSecret'])->name("generate2faSecret");
    Route::post('/enable2fa', [LoginSecurityController::class, 'enable2fa'])->name("enable2fa");
    Route::post('/disable2fa', [LoginSecurityController::class, 'disable2fa'])->name("disable2fa");


    // 2fa middleware
    Route::post('/2faVerify', function () {
        return redirect(URL()->previous());
    })->name('2faVerify')->middleware('2fa');
});

Route::get('/wts_webhook', [wtspController::class, 'wtsp_webhook']);



Route::post('/webhook/whatsapp', [wtspController::class, 'handle']);
Route::get('/webhook/whatsapp', [wtspController::class, 'verify']);


Route::get('/webhook/wtsp_webhook', [wtspController::class, 'wtsp_webhook']);

Route::group(
    ['middleware' => ['auth', '2fa']],
    function () {
        Route::resources([]);

        //ATTACHEMENT
        Route::get('/attachement', [AttachementController::class, 'index'])->name('attachement');
        Route::get('/attachement/generate_new', [AttachementController::class, 'generate_new']);
        Route::get('/attachement/delete', [AttachementController::class, 'delete']);
        Route::get('/attachement/datatable', [AttachementController::class, 'attachements_datatable']);




        // TERRAINS
        Route::get('/terrains', [TerrainsController::class, 'index'])->name('terrains');
        Route::get('/terrains_taxables', [TerrainsController::class, 'index_terrains_taxables'])->name('terrains_taxables');
        Route::get('/terrains_exonerations_temporaires', [TerrainsController::class, 'index_exonerations_temporaires'])->name('terrains_exonerations_temporaires');
        Route::get('/terrains_supprimes', [TerrainsController::class, 'index_supprimes'])->name('terrains_supprimes');
        // Route::get('/terrains/show/{id}', [TerrainsController::class, 'show']);
        Route::get('/terrains/show/{terrain}', [TerrainsController::class, 'show']);
        Route::get('/terrains_datatable', [TerrainsController::class, 'terrains_datatable']);
        Route::get('/terrains_taxables_datatable', [TerrainsController::class, 'terrains_taxables_datatable']);
        Route::get('/terrains_exonerations_temporaires_datatable', [TerrainsController::class, 'terrains_exonerations_temporaires_datatable']);
        Route::get('/terrains_supprimes_datatable', [TerrainsController::class, 'terrains_supprimes_datatable']);
        Route::post('/terrains/store', [TerrainsController::class, 'store']);
        Route::post('/terrains/file/upload', [TerrainsController::class, 'upload']);
        Route::get('/terrains/file/{id}', [TerrainsController::class, 'file']);
        Route::post('/terrains/destroy', [TerrainsController::class, 'destroy']);
        Route::post('/terrains/assujettissement', [TerrainsController::class, 'assujettissement']);


        Route::get('/terrains/data/{id}', [TerrainsController::class, 'terrain_data']);
        Route::get('/terrains/getAllTerrains', [TerrainsController::class, 'getAllTerrains'])->name('getAllTerrains');


        //generate terrain notification pdf
        Route::get('/generate-notifications-pdf', [TerrainsNotificationsController::class, 'generateNotificationsPdf'])->name('generate.notifications.pdf');


        // PROPRIETAIRES
        Route::post('/proprietaire/store_proprietaire_document', [ProprietairesController::class, 'store_proprietaire_document']);
        Route::post('/proprietaire/check_proprietaire', [ProprietairesController::class, 'check_proprietaire']);


        //LIQUIDATIONS
        Route::post('/liquidations/generate-pdf', [LiquidationsController::class, 'generatePdf']);

        //DECLARATIONS
        Route::post('/declarations/generate-pdf', [DeclarationsController::class, 'generatePdf']);

        //ZONES
        Route::get('/zonespa/getZonesPA', [ZonesPAController::class, 'getZonesPA'])->name('getZonesPA');


        //SUIVI
        Route::get('/suivi', [SuiviController::class, 'index'])->name('suivi');
        Route::get('/suivi/suivi_datatable', [SuiviController::class, 'suivi_datatable']);
        Route::get('/suivi/contacte/{id}', [SuiviController::class, 'contacter']);
        Route::get('/suivi/refresh_users_suivi', [SuiviController::class, 'refresh_users_suivi']);
        Route::get('/suivi/suivi_par_douar_table', [SuiviController::class, 'suivi_par_douar_table']);
        Route::get('/suivi/suivi_par_province', [SuiviController::class, 'suivi_par_province']);
        Route::get('/constructibilite', [SuiviController::class, 'constructibilite_index'])->name('constructibilite');
        Route::get('/suivi/get_suivi_par_communes/{type_document}', [SuiviController::class, 'get_suivi_par_communes']);





        //CENTRE DONNEES
        Route::get('/centre_donnees', [CentreDonneesController::class, 'index'])->name('centre_donnees');
        Route::get('/centre_donnees/douars_datatable', [CentreDonneesController::class, 'douars_datatable']);
        Route::get('/centre_donnees/prestataires_datatable', [CentreDonneesController::class, 'prestataires_datatable']);
        Route::post('/centre_donnees/douars_edit_etat_sol', [CentreDonneesController::class, 'douars_edit_etat_sol']);
        Route::post('/centre_donnees/douars_store_etude_geotechnique', [CentreDonneesController::class, 'douars_store_etude_geotechnique']);
        Route::get('/douar/{id}', [CentreDonneesController::class, 'douar']);
        Route::get('/douar/files/etude_geotechnique/{douar_id}', [CentreDonneesController::class, 'downloadEtudeGeotechnique']);
        Route::get('/douar/files/etude_geotechnique_lpee/{douar_id}', [CentreDonneesController::class, 'downloadEtudeGeotechniqueLPEE']);
        Route::get('/douar/files/effet_lithologique/{douar_id}', [CentreDonneesController::class, 'downloadFileEffetLithologique']);
        Route::get('/douar/files/effet_topo/{douar_id}', [CentreDonneesController::class, 'downloadFileEffetTopo']);
        Route::get('/douar/etude_geotechnique/{etude_geotechnique_id}', [CentreDonneesController::class, 'etude_geotechnique']);

        Route::get('/douar/files/etude_geotechnique_lpee/{douar_id}', [CentreDonneesController::class, 'downloadEtudeGeotechniqueLPEE']);

        Route::get('/douar/etude_geotechnique/conclusion/{conclusion_id}', [CentreDonneesController::class, 'conclusion']);
        Route::post('/douar/deblaiement/store', [CentreDonneesController::class, 'store_deblaiement']);
        Route::get('/douar/deblaiement/{douar_id}', [CentreDonneesController::class, 'get_deblaiement']);
        Route::get('/douar/deblaiement/datatable/get', [CentreDonneesController::class, 'deblaiements_datatable']);
        Route::get('/guichets/datatable', [CentreDonneesController::class, 'guichets_datatable']);
        Route::post('/guichets/store', [CentreDonneesController::class, 'guichets_store']);
        Route::get('/guichets/get/{guichet_id}', [CentreDonneesController::class, 'guichets_get']);
        Route::get('/centre_donnees/charges_guichets_datatable', [CentreDonneesController::class, 'charges_guichets_datatable']);
        Route::get('/centre_donnees/get_douar_prestataires/{douar_id}', [CentreDonneesController::class, 'get_douar_prestataires']);

        Route::get('/centre_donnees/plan_types/{douar_id}', [CentreDonneesController::class, 'plan_types_show']);
        Route::get('/centre_donnees/plan_types_files_datatable', [CentreDonneesController::class, 'plan_types_files_datatable']);
        Route::get('/centre_donnees/plan_types_bet_files_datatable', [CentreDonneesController::class, 'plan_types_bet_files_datatable']);
        Route::post('/centre_donnees/plan_type_upload', [CentreDonneesController::class, 'plan_type_upload']);
        Route::get('/centre_donnees/plan_type_file_pdf/{id}', [CentreDonneesController::class, 'plan_type_file_pdf']);
        Route::get('/centre_donnees/plan_type_file_dwg/{id}', [CentreDonneesController::class, 'plan_type_file_dwg']);
        Route::get('/centre_donnees/plan_type/{id}', [CentreDonneesController::class, 'plan_type']);
        Route::post('/centre_donnees/delete_plan_type', [CentreDonneesController::class, 'delete_plan_type']);
        Route::get('/centre_donnees/plan_type_remarques_datatable', [CentreDonneesController::class, 'plan_type_remarques_datatable']);

        Route::get('/centre_donnees/plan_types_bet/{douar_id}', [CentreDonneesController::class, 'plan_types_bet_show']);


        Route::post('/centre_donnees/store_plan_type_remarque', [CentreDonneesController::class, 'store_plan_type_remarque']);
        Route::post('/centre_donnees/delete_plan_type_remarques', [CentreDonneesController::class, 'delete_plan_type_remarques']);
        Route::post('/centre_donnees/validate_plan_type', [CentreDonneesController::class, 'validate_plan_type']);
        Route::post('/centre_donnees/check_affectation_delection', [CentreDonneesController::class, 'check_affectation_delection']);
        Route::post('/centre_donnees/reaffecter', [CentreDonneesController::class, 'reaffecter']);
        Route::get('/centre_donnees/get_plan_type/{id}', [CentreDonneesController::class, 'get_plan_type']);
        Route::get('centre_donnees/carte_aleas_datatable', [CentreDonneesController::class, 'carte_aleas_datatable']);
        Route::get('centre_donnees/export_douars_data', [CentreDonneesController::class, 'export_douars_data']);

        Route::get('centre_donnees/dump_etude_geotechnique_geometry', [CentreDonneesController::class, 'dump_etude_geotechnique_geometry']);



        Route::get('centre_donnees/clean_files', [CentreDonneesController::class, 'clean_files']);
        Route::post('centre_donnees/store_new_douar', [CentreDonneesController::class, 'store_new_douar']);


        Route::get('/centre_donnees/optimise_petitionnaires', [CentreDonneesController::class, 'optimise_petitionnaires']);



        //DASHBOARD
        //Route::get('/dashboard-prestataire', [DashboardController::class, 'index_prestataire'])->name('dashboard');
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('/dashboard/index_terrains_stats', [DashboardController::class, 'index_terrains_stats']);
        Route::get('/dashboard/terrain_types_chart', [DashboardController::class, 'terrain_types_chart']);
        Route::get('/dashboard/declarations_chart', [DashboardController::class, 'declarations_chart']);
        Route::get('/dashboard/index_terrains_liquidations', [DashboardController::class, 'index_terrains_liquidations']);


        //GEOPORTAIL
        Route::get('/geoportail', [GeoportailController::class, 'index'])->name('geoportail');
        Route::get('/geoportail/terrains_datatable', [GeoportailController::class, 'terrains_datatable']);
        Route::get('/geoportail/map_get_terrains', [GeoportailController::class, 'map_get_terrains']);

        Route::get('/get_etude_geo_geometries', [GeoportailController::class, 'get_etude_geo_geometries']);
    Route::get('/geoportail/getAllTerrains', [GeoportailController::class, 'getAllTerrains'])->name('getAllTerrains');


        //statistiques
        Route::get('/statistiques', [DashboardController::class, 'index'])->name('statistiques');


        //USER
        Route::get('/fix_no_token', [UserController::class, 'fix_no_token']);
        Route::get('/update_depot', [UserController::class, 'update_depot']);

        Route::get('/get_dours/{id}', [UserController::class, 'get_douars']);
        Route::post('/set_dours/{id}', [UserController::class, 'set_douars']);
        Route::get('/user/get_by_role/{id}', [UserController::class, 'get_by_role']);
        Route::post('/user/store', [UserController::class, 'store'])->name('user.store');
        Route::post('/user/store_charge_guichet', [UserController::class, 'store_charge_guichet']);
        Route::post('/user/delete', [UserController::class, 'delete'])->name('user.delete');
        Route::get('/user/{id}', [UserController::class, 'get']);
        Route::get('/send-invitation-mail/{user_id}', [UserController::class, 'send_invitation_mail']);
        Route::get('/user/get_by_role_douar/{id}/{douar_id}', [UserController::class, 'get_by_role_douar']);

        Route::post('/user/store_etat_engagement', [UserController::class, 'store_etat_engagement']);


        //PROFILE
        Route::get('/profile', [ProfileController::class, 'index'])->name('profile.index');
        Route::post('/profile/update', [ProfileController::class, 'update']);
        Route::post('/profile/updatePassword', [ProfileController::class, 'updatePassword']);

        //COMMISSIONS
        Route::post('/commissions/store', [CommissionsController::class, 'store']);
        Route::get('/commissions/datatable', [CommissionsController::class, 'datatable']);
        Route::get('/commissions/getAll', [CommissionsController::class, 'get_comissions']);
        Route::post('/commissions/delete', [CommissionsController::class, 'delete']);

        //LIVRABLES
        Route::get('/livrables/generate_EtatAvancement', [LivrablesController::class, 'generate_EtatAvancement']);
        Route::get('/livrables/generate_suivi_realisations', [LivrablesController::class, 'generate_suivi_realisations']);
        Route::get('/livrables/generate_all_recaps', [LivrablesController::class, 'generate_all_recaps']);
        Route::get('/download_recap/{recap_id}', [LivrablesController::class, 'download_recap']);


        Route::get('/test_geojson_err1', [DossiersController::class, 'test_geojson_err1']);
        Route::get('/detect_bad_demandes', [DemandesController::class, 'detect_bad_demandes']);

        Route::get('/detect_bad_cin', [CentreDonneesController::class, 'detect_bad_cin']);

        Route::get('/fix_v1_pass', [VerificationsController::class, 'fix_v1_pass']);


        //STORAGE MANAGER
        Route::get('/storage_manager', [StorageManagerController::class, 'index'])->name('storage_manager');
        Route::get('/sftp', [StorageManagerController::class, 'sftp']);
        Route::get('/stats_dossiers_documents', [StorageManagerController::class, 'stats_dossiers_documents']);



        //temp

        Route::get('/f_update_dossier_etat/{id}', [DossiersController::class, 'f_update_dossier_etat']);

        Route::get('/suivi_prestataire_douars/{type}/{start}/{limit}', [SuiviController::class, 'suivi_prestataire_douars']);

        Route::get('/fix_duplicated_dossiers', [DossiersController::class, 'fix_duplicated_dossiers']);

        Route::get('/detect_bad_demandes', [CentreDonneesController::class, 'detect_bad_demandes']);

        Route::get('/detect_cin_no_demandes', [CentreDonneesController::class, 'detect_cin_no_demandes']);

        Route::get('/check_etat_actuel', [DashboardController::class, 'check_etat_actuel']);

        Route::get('/update_all_dossiers_rehab_etat', [DossiersRehabController::class, 'update_all_dossiers_rehab_etat']);
        Route::get('/update_dossier_rehab_etat/{id}', [DossiersRehabController::class, 'update_dossier_etat']);

        Route::get('/rehab_fix_active_dossiers_documents', [DossiersRehabController::class, 'rehab_fix_active_dossiers_documents']);

        Route::get('/update_dossier_etat/{id}', [DossiersController::class, 'update_dossier_etat']);

        Route::get('/fix_cin_with_empty_spaces', [DossiersController::class, 'fix_cin_with_empty_spaces']);

        Route::get('/dossiers_rehab/delete_tmp', [DossiersRehabController::class, 'delete_dossier']);

        Route::get('/get_dossiers_from_cin', [DossiersController::class, 'get_dossiers_from_cin']);


        Route::get('/get_mi', [CentreDonneesController::class, 'get_mi']);

        Route::get('/update_petitionnaires', [CentreDonneesController::class, 'update_petitionnaires']);


        Route::get('/update_type_from_list', [DossiersController::class, 'update_type_from_list']);

        Route::get('/documents_constructibilite_par_douar', [echangeMI::class, 'documents_constructibilite_par_douar']);

        Route::get('/detect_bad_geometries', [DossiersController::class, 'detect_bad_geometries']);
        Route::get('/export_geometries', [DossiersController::class, 'export_geometries']);


        Route::get('/delete_geometries', [DossiersController::class, 'delete_geometries']);


        Route::get('tmp_phpmyinfo', function () {
            phpinfo();
        });

        Route::get('/export_mi_verified_petitionnaires', [DossiersController::class, 'export_mi_verified_petitionnaires']);


        //Route::get('/update_names_from_list', [DossiersController::class, 'update_names_from_list']);
        Route::get('/fix_50', [DossiersController::class, 'fix_50']);

        Route::get('/get_verified_today', [DossiersController::class, 'get_verified_today']);
        Route::get('/cleanFiles', [CentreDonneesController::class, 'cleanFiles']);



        //ZONING
        Route::get('/zoning', [ZoningController::class, 'index'])->name('zoning');
        Route::get('/zones_datatable', [ZoningController::class, 'zones_datatable']);
        Route::get('/zoning/getZonesDcision', [ZoningController::class, 'getZonesDcision']);
        Route::get('/zoning/getZones', [ZoningController::class, 'getZones']);
        Route::get('/zoning/file/{id}', [ZoningController::class, 'file']);
    }
);

Route::get('/statistics/etat_avancement', [StatisticsController::class, 'etat_avancement']);
Route::get('/statistics/stats_all', [StatisticsController::class, 'stats_all']);
Route::get('/dossiers/getAllDocuments', [DossiersController::class, 'getAllDocuments']);
