<?php
$profile_pic = Auth::user()->avatar();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="_token" content="<?php echo e(csrf_token()); ?>" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" href="<?php echo e(asset('images/favicon.png')); ?>">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <title><?php echo e(config('app.name')); ?></title>
    <?php echo $__env->make('inc.css_links', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


</head>

<body class="hold-transition skin-blue layout-top-nav has-drawer">

    <div class="wrapper">

        <header class="main-header" style="box-shadow: 1px 3px 7px 0px rgb(0 0 0 / 8%) !important; border-bottom: 1px #dbdbdb solid;">
            <div class="inside-header">
                <!-- Logo -->
                <a style="padding: 0 0px !important;width: 90px;" href="<?php echo e(route('dashboard')); ?>" class="logo">
                    <b class="logo-mini" style="height: 100%;padding: 2px;">
                        <span class="light-logo"><img src="<?php echo e(asset('images/logo/logo_app_ns.svg').'?v=2'); ?>" alt="logo" style="height: 100%;margin-left: 3px;margin-bottom: 6px;"></span>
                    </b>
                </a>
                <!-- Header Navbar -->
                <nav class="navbar navbar-static-top">
                    <!-- Sidebar toggle button-->
                    <a id="navbar_toggle_btn" style="padding:20px 8px !important;text-decoration: none;" style="text-decoration: none !important;" href="#" class="sidebar-toggle d-block d-lg-none" data-toggle="push-menu" role="button">
                        <span class="sr-only">Toggle navigation</span>
                    </a>
                    <ul class="navbar-nav mr-auto mt-md-0">
                    </ul>

                    <div class="navbar-custom-menu">
                        <ul class="nav navbar-nav">

                            <!-- User Account -->
                            <li class="dropdown user user-menu" style="padding-top: 8px;padding-right: 8px;">
                                <a href="#" style="background: transparent;display: inline-flex;width: 100%;padding: 0px 0px !important;" class="dropdown-toggle" data-toggle="dropdown">

                                    <img src="<?php echo e($profile_pic); ?>" class="user-image rounded-circle" style="float: left; border: #005bcc solid; border-width: 2px 2px 2px 2px;margin-right: 6px; margin-left: 6px;" alt="User Image">
                                    <div style="float:left;line-height: 1rem;padding-right: 6px; border-right: 1px #b6b6b6 dashed;">
                                        <b style="font-size: 0.75rem;color: #005bcc;display: block;"><?php echo e(ucfirst(auth()->user()->nom)); ?> <?php echo e(ucfirst(auth()->user()->prenom)); ?> </b>  
                                        <b style="font-size: 0.65rem;color: #676767;display: block;"><?php echo e(ucfirst(auth()->user()->role->name)); ?> </b>

                                    </div>

                                </a>
                                <ul class="dropdown-menu " style="width: 200px;border: 1px #d6d6d6 solid;border-radius: 6px;margin-top: 12px;margin-right: 8px;box-shadow: 0px 0px 8px 2px rgb(0 0 0 / 15%) !important;">
                                    <!-- User image -->
                                    <li class="user-header" style="display: contents;">
                                        <div class="row">
                                            <h5 style="margin-bottom: 8px !important;font-size: 1rem;width: 100%; text-align: center !important;">
                                                <?php echo e(ucfirst(auth()->user()->nom)); ?>

                                                <?php echo e(ucfirst(auth()->user()->prenom)); ?>

                                            </h5>
                                        </div>
                                        <div class="row">

                                            <?php if(Auth::user()->has_role('Observateur de suivi')): ?>
                                            <?php if(Auth::user()->coordinateur==1): ?>
                                            <b style="margin-bottom: 8px !important;font-size: 0.76rem; color: #2584c9; text-align: center; width: 100%;"><?php echo e(ucfirst('Coordinateur')); ?> </b>
                                            <?php else: ?>
                                            <b style="margin-bottom: 8px !important;font-size: 0.76rem; color: #2584c9; text-align: center; width: 100%;"><?php echo e(ucfirst(auth()->user()->role->full_name)); ?> </b>
                                            <?php endif; ?>
                                            <?php else: ?>
                                            <b style="margin-bottom: 8px !important;font-size: 0.76rem; color: #2584c9; text-align: center; width: 100%;"><?php echo e(ucfirst(auth()->user()->role->full_name)); ?> </b>
                                            <?php endif; ?>

                                        </div>

                                    </li>
                                    <!-- Menu Body -->
                                    <li class="user-body">
                                        <div class="row no-gutters">
                                            <div role="separator" class="divider col-12"></div>
                                            <div class="col-12 text-left">
                                                <a style="border-radius: 10px;text-decoration: none;" class="dropdown-item" href="<?php echo e(route('profile.index')); ?>">
                                                    <i class="fa fa-user"></i> Mon profil
                                                </a>

                                                <a style="color: red !important;border-radius: 10px;text-decoration: none;" class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                                    <i class="fa fa-sign-out"></i> <?php echo e(__('Déconnexion')); ?>

                                                </a>

                                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                                    <?php echo csrf_field(); ?>
                                                </form>
                                            </div>
                                        </div>
                                        <!-- /.row -->
                                    </li>
                                </ul>
                            </li>

                            <li class="nav-item dropdown dropdown-notifications">
                                <a style="border: 1px #005bcc solid;margin: 12px 4px !important; line-height: 32px; border-radius: 50%; width: 40px; height: 40px; padding: 0px 8px;" class="nav-link dropdown-toggle no-caret" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                    <span class="feather-icon" style="color: #005bcc; margin-top: 6px; display: flex;">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="currentColor" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-bell">
                                            <path d="M22 17H2a3 3 0 0 0 3-3V9a7 7 0 0 1 14 0v5a3 3 0 0 0 3 3zm-8.27 4a2 2 0 0 1-3.46 0"></path>
                                        </svg>
                                    </span>

                                </a>
                                <div class="dropdown-menu dropdown-menu-right" data-dropdown-in="fadeIn" data-dropdown-out="fadeOut" style="margin-right: 8px; margin-top: 8px; border-radius: 8px;width: 320px;border: 1px #d6d6d6 solid;box-shadow: 0px 0px 8px 2px rgb(0 0 0 / 15%) !important;">
                                    <h6 style="text-align: center;" class="dropdown-header"> Notifications -&nbsp<a href="javascript:void(0);" class="">Aficher tout</a></h6>
                                    <div class="slimScrollDiv" style="position: relative; overflow: hidden; width: auto; height: 260px;">
                                        <div class="notifications-nicescroll-bar" style="padding: 6px;overflow-y: auto;width: auto; height: 260px; outline: none;" tabindex="-50">
                                      
                                           
                                        </div>
                                        <div class="slimScrollBar" style="background: rgb(214, 217, 218); width: 6px; position: absolute; top: 0px; opacity: 0.8; display: none; border-radius: 0px; z-index: 99; right: 1px; outline: none; height: 284.334px;" tabindex="-50"></div>
                                        <div class="slimScrollRail" style="width: 6px; height: 100%; position: absolute; top: 0px; display: none; border-radius: 7px; background: rgb(51, 51, 51); opacity: 0.2; z-index: 90; right: 1px;"></div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </nav>
            </div>
        </header>


        <!-- Main Navbar -->
        <div class="main-nav" style="font-size: 85%;margin-top: 8px !important;z-index: 99999999;;background: unset;margin-left: 150px;width: calc(100% - 420px) !important;">
            <nav class="navbar navbar-expand-lg">
                <div class="collapse navbar-collapse" id="navbarNavDropdown" style="top: 60px;">
                    <?php echo $__env->make('inc.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </nav>
        </div>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">

            <!-- Main content -->
            <section class="content m-content " style="overflow-y: hidden; ">

                <?php echo $__env->yieldContent('content'); ?>

            </section>
            <!-- /.content -->
        </div>

        <!-- Add the sidebar's background. This div must be placed immediately after the control sidebar -->
        <div class="control-sidebar-bg"></div>

    </div>
    <!-- ./wrapper -->
    <?php echo $__env->make('inc.scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('layouts/modals', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

</body>

</html><?php /**PATH /home/jobbidmng/public_html/ettnb.ma/resources/views/layouts/app.blade.php ENDPATH**/ ?>