<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="_token" content="<?php echo e(csrf_token()); ?>" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta http-equiv="cache-control" content="private, max-age=0, no-cache">
    <meta http-equiv="pragma" content="no-cache">
    <meta http-equiv="expires" content="0">
    <link rel="icon" href="<?php echo e(asset('images/favicon.png')); ?>">
    <title><?php echo e(config('app.name')); ?></title>
    <?php echo $__env->make('inc.css_links', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <style>
        .form-group {
            margin-bottom: 1rem !important;
        }

        @font-face {
            font-family: Lato;
            src: url('<?php echo e(asset(' fonts/Lato/lato-v11-latin-ext_latin-700.ttf')); ?>');
        }


        @font-face {
            font-family: Roboto-Condensed;
            src: url('<?php echo e(asset(' fonts/roboto/RobotoCondensed-Regular.ttf')); ?>');
        }


        @font-face {
            font-family: Lato2;
            src: url('<?php echo e(asset(' fonts/Lato/lato-v11-latin-ext_latin-regular.ttf')); ?>');
        }

        .lato-bold {
            font-family: 'Lato2';
            font-weight: bold;
        }

        body,
        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            font-family: 'Roboto-Condensed', 'Roboto';

        }

        label {
            font-family: 'Roboto-Condensed', 'Roboto';
            font-weight: bold;
        }

        .nav-tabs {
            font-family: 'Roboto-Condensed', 'Roboto' !important;
            font-weight: bold;
        }


        .table th,
        .table thead th {
            font-family: Lato;
            font-weight: 600;
            font-size: 13px;
        }

        .btn {
            font-family: Lato, 'Roboto';
            font-weight: bold;
            font-size: 12px;
        }

        .form-control {}

        .btn {
            font-size: 15px;
        }

        .video_thmb {
            height: 120px;
            font-family: 'Roboto';
            transition-duration: 500ms;
            border: 1px #9e9e9e solid;
            border-radius: 6px;
            background-image: url(/images/video_thumb_bg.png);
            background-repeat: no-repeat;
            background-size: contain;
            background-position: center;
            background-color: black;
            display: flex;
            box-shadow: 0px 0px 10px 0px rgb(164 164 164 / 56%);

        }

        .video_thmb:hover {
            cursor: pointer;
            opacity: 0.6;
        }

        .video_thmb span {
            font-size: 0.8rem;
            margin: auto;
            background: #131212ab;
            width: 100%;
            text-align: center;
            color: white;
        }

        .vpopup .popuptext {
            visibility: hidden;
            background-color: #555;
            color: #fff;
            text-align: center;
            border-radius: 6px;
            padding: 8px 0;
            z-index: 1;
            bottom: 125%;
            width: 100%;
            height: 100%;
        }

        .vpopup {
            width: calc(100% - 40px) !important;
            position: absolute;
            top: 20px;
            height: calc(100% - 38px);
            left: 20px;
            margin-left: 0px !important;
            z-index: 99999;
            pointer-events: none;
        }

        .vpopup .show {
            visibility: visible;
            -webkit-animation: fadeIn 0.25s;
            animation: fadeIn 0.25s;
            pointer-events: all;
        }

        @-webkit-keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        .popup_close {
            position: absolute;
            font-size: 1.5rem;
            color: white;
            right: 0px;
            padding: 10px;
            opacity: 1;
            pointer-events: all;

        }

        .popup_close:hover {
            opacity: 0.7;
            cursor: pointer;
        }
    </style>
</head>

<body class="hold-transition login-page" style="background: rgb(228,228,228);background: linear-gradient(354deg, rgba(228,228,228,1) 0%, rgba(255,255,255,1) 100%);">

    <div class="container h-p100" style="margin-top: 20px !important;border:0 !important;background: none !important;max-width: none !important;">
        <div class="row align-items-center justify-content-md-center h-p100">
            <div class="col-lg-7 col-md-8 col-12">
                <div class="login-box">
                    <div class="login-box-body" style="border-radius: 8px;">
                        <div class="row ">

                            <div class="col-12">
                                <img style="height: 140px;margin: auto;display: block;" src="<?php echo e(asset('images/logo/logo_app_ns.svg').'?v=2'); ?>" alt="">
                            </div>
                        </div>

                        <br>
                        <h5 class="login-box-msg " style="font-family: 'Roboto';color: #7F7F7E !important;">Identifiez-vous sur votre espace</h5>
                        <br>

                        <form method="POST" action="<?php echo e(route('login')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="form-group has-feedback">
                                <input style="height: 35px !important;" id="email" type="text" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?> rounded" name="email" value="<?php echo e(old('email')); ?>" placeholder="Email" required autofocus>

                                <?php if($errors->has('email')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('email')); ?></strong>
                                </span>

                                <?php endif; ?>
                                <span class="ion ion-locked form-control-feedback"><i class="fa fa-user-circle"></i></span>

                            </div>
                            <div class="form-group has-feedback">
                                <input style="height: 35px !important;" style="font-family: 'Roboto';" id="password" type="password" class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?> rounded" placeholder="Mot de passe" name="password" required>

                                <?php if($errors->has('password')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('password')); ?></strong>
                                </span>
                                <?php endif; ?>
                                <span class="ion ion-email form-control-feedback"><i class="fa fa-key"></i></span>
                            </div>
                            <div class="row">
                                <a id="rest_pwd_a" style="font-family: 'Roboto'; color: #ca1b1b !important; font-size: 0.8rem;" href="javascript:;">Mot de passe oublié ?</a>
                            </div>
                            <div class="row">
                                <div class="col-12 text-center">
                                    <button style="border-radius: 6px !important; background: #29ABE2 !important; color: white; font-weight: 400 !important; font-family: 'Roboto'; text-decoration: none;" type="submit" class="btn "><i class="fa-solid fa-lock-open"></i>&nbspAuthentification</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.login-box-body -->
                </div>
                <!-- /.login-box -->

                <!-- <div class="row  ">
                    <h6><i class="fa-solid fa-clapperboard"></i>&nbspVideos</h6>
                    <div class="col-md col-12 mt-2">
                        <div class="video_thmb" title="Architecte" source="https://batir.co.ma/files/videos/architectes.mp4">
                            <span><i class="fa-solid fa-clapperboard"></i>&nbspArchitecte</span>
                        </div>
                    </div>
                    <div class="col-md col-12 mt-2">
                        <div class="video_thmb" title="IGT" source="https://batir.co.ma/files/videos/igt.mp4">
                            <span><i class="fa-solid fa-clapperboard"></i>&nbspIGT</span>
                        </div>
                    </div>
                    <div class="col-md col-12 mt-2">
                        <div class="video_thmb" title="Laboratoire" source="https://batir.co.ma/files/videos/labo.mp4">
                            <span><i class="fa-solid fa-clapperboard"></i>&nbspLaboratoire</span>
                        </div>
                    </div>
                </div> -->
            </div>
        </div>


    </div>

    <div class="vpopup">
        <i class="fa-solid fa-xmark popup_close"></i>
        <span id="videoTitle" style=" position: absolute;font-size: 1.2rem;color: white;left: 0px;padding: 10px;">Title</span>
        <video class="popuptext" id="videoPopup" controls autoplay style="padding-top:40px">
            <source id="videoSource" src="" type="video/mp4">
        </video>
    </div>
    <?php echo $__env->make('layouts/modals', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('inc.scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('auth/modals', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script>
        $(".video_thmb").click(function() {
            var source = $(this).attr('source');
            var title = $(this).attr('title');
            playVideo(title, source);
        });
        $(".popup_close").click(function() {
            var popup = document.getElementById("videoPopup");
            popup.classList.toggle("show");
            $("#videoSource").attr('src', '');
            popup.load();
        })

        function playVideo(title, source) {
            var popup = document.getElementById("videoPopup");
            popup.classList.toggle("show");
            $("#videoSource").attr('src', source);
            $("#videoTitle").text(title);
            popup.load();
            popup.play();

        }
        $("#rest_pwd_a").click(function() {
            $("#reset_pwd_modal").modal('show');
        });

        $("#reset_pwd_modal_save").click(function() {
            showLoading('HMR', 'Chargement...');
            var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
            $.ajax({
                url: '/send-forgotpwd-mail',
                type: 'post',
                data: {
                    _token: csrfToken,
                    email: $("#reset_pwd_modal_email").val(),
                },
                success: function(response) {
                    $("#reset_pwd_modal").modal('hide');
                    closeLoading();
                    if (response.success == 0) {


                        if (response.error == "UNKNOWN_USER") {
                            gl_alert('error', 'HMR', "Aucun compte HMR ne correspond aux informations fournies.");
                        }

                    } else {

                        $("#reset_pwd_modal").modal('hide');
                        gl_alert('success', 'HMR', `Un e-mail contenant le lien de réinitialisation du mot de passe a été envoyé à l'adresse ${$("#reset_pwd_modal_email").val()}.`);
                    }
                }
            });
        });

        $(document).keyup(function(e) {
            if (e.key === "Escape") { // escape key maps to keycode `27`
                $(".popup_close").click();
            }
        });

      
    </script>
</body>

</html><?php /**PATH /home/jobbidmng/public_html/etnb/resources/views/auth/login.blade.php ENDPATH**/ ?>