<?php if(!$terrain->hasLiquidationThisYear()): ?>
<div class="row mt-3">
    <div class="col-md-4">
        <div class="input-group input-group-sm">
            <div class="input-group mb-1">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width: 140px;font-weight : bold">Montant
                        initial:</span>
                </div>
                <input readonly class="form-control" id="montant_initial"
                    value="<?php echo e(number_format($montant_initial, 2, '.', ' ')); ?> MAD">
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="input-group input-group-sm">
            <div class="input-group mb-1">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width: 140px;font-weight : bold">Montant sanctions
                        :</span>
                </div>
                <input readonly class="form-control" id="montant_sanctions"
                    value="<?php echo e(number_format($montant_sanctions, 2, '.', ' ')); ?> MAD">
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="input-group input-group-sm">
            <div class="input-group mb-1">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width: 140px;font-weight : bold">Montant total
                        :</span>
                </div>
                <input readonly class="form-control" id="montant_total"
                    value="<?php echo e(number_format($montant_total, 2, '.', ' ')); ?> MAD">
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if(!$terrain->hasLiquidationThisYear()): ?>
<div class="col-12">
    <table class="table table-hover table-striped datatables dataTable no-footer display nowrap rtable"
        id="liquidation-table">
        <thead>
            <tr>
                <th>Année</th>
                <th>Sanction</th>
                <th>Montant</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $liquidations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $liquidation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td rowspan="<?php echo e(count($liquidation['sanctions']) + 1); ?>"
                    style="background: white !important;text-align : center"><b
                        style="font-weight: bold;color : #00b894;"><?php echo e($liquidation['year']); ?></b></td>
                <td><b>Montant de la TNB</b></td>
                <td class="montant-tnb" data-amount="<?php echo e($liquidation['montant_tnb']); ?>"><b><?php echo e(number_format($liquidation['montant_tnb'], 2, '.', ' ')); ?> MAD</b></td>
            </tr>
            <?php $__currentLoopData = $liquidation['sanctions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $sanction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr style="border-bottom : 1px solid #f1f1f1;">
                <td><input type="checkbox" class="sanction-checkbox" data-year="<?php echo e($liquidation['year']); ?>"
                        data-index="<?php echo e($index); ?>" data-amount="<?php echo e($sanction['amount']); ?>" checked>&nbsp;<?php echo e($sanction['name']); ?></td>
                <td><?php echo e(number_format($sanction['amount'], 2, '.', ' ')); ?> MAD</td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php endif; ?>
<div class="row col-12 mt-3">
    <div class="col-md-4 col-12">
        <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
            <div>
                <?php if(is_null($liquidation_document['document'])): ?>
                <i type_document="<?php echo e($liquidation_document['type_document']); ?>"
                    style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;"
                    class="fa-solid fa-file-pdf-o upload_doc_icon"></i>
                <?php else: ?>
                <i type_document="<?php echo e($liquidation_document['type_document']); ?>"
                    style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;"
                    class="fa-solid fa-file-circle-check upload_doc_icon"></i>

                <?php endif; ?>


                <b class="mt-2 upload_doc_no_file_label"
                    style="color:gray;display: block; margin: auto;text-align: center;">
                    Génération de l'avis d'imposition
                </b>

                <form action="/liquidations/generate-pdf" method="POST" target="_blank">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="sanctions" id="sanctions_input">
                    <input type="hidden" name="montant_initial" id="montant_initial_input">
                    <input type="hidden" name="montant_sanctions" id="montant_sanctions_input">
                    <input type="hidden" name="montant_total" id="montant_total_input">
                    <input type="hidden" name="terrain_id" id="terrain_id_liquidation_input" value="<?php echo e($terrain->id); ?>">

                    <div style="margin: auto; display: block;text-align: center;">
                        <?php if(!$LIQUIDATION_LOCKED): ?>
                        <button type="submit" type_document="<?php echo e($liquidation_document['type_document']); ?>"
                            file_type="<?php echo e($liquidation_document['file_type']); ?>" type="button"
                            class="btn btn-light generate_liquidation"> <i
                                class="fa-solid fa-plus"></i>&nbsp;Générer</button>
                        <?php endif; ?>
                    </div>
                </form>

            </div>
        </div>
    </div>
    <div class="col-md-4 col-12">
        <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
            <div>
                <?php if(is_null($liquidation_document['document'])): ?>
                <i type_document="<?php echo e($liquidation_document['type_document']); ?>"
                    style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;"
                    class="fa-solid fa-file-circle-xmark upload_doc_icon"></i>
                <?php else: ?>
                <i type_document="<?php echo e($liquidation_document['type_document']); ?>"
                    style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;"
                    class="fa-solid fa-file-circle-check upload_doc_icon"></i>
                <?php endif; ?>

                <?php if(is_null($liquidation_document['document'])): ?>
                <b type_document="<?php echo e($liquidation_document['type_document']); ?>" class="mt-2 upload_doc_no_file_label"
                    style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                    fichier importé </b>
                <?php endif; ?>
                <div style="margin: auto; display: block;text-align: center;">
                    <?php if(!$LIQUIDATION_LOCKED): ?>
                    <?php if( $liquidation_document['active']==1): ?>
                    <button type_document="<?php echo e($liquidation_document['type_document']); ?>"
                        file_type="<?php echo e($liquidation_document['file_type']); ?>" type="button"
                        class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                    <?php endif; ?>
                    <?php endif; ?>
                    <?php if(is_null($liquidation_document['document'])): ?>
                    <button disabled type_document="<?php echo e($liquidation_document['type_document']); ?>" file_id="" type="button"
                        class="btn btn-success download_doc_link"> <i
                            class="fa-solid fa-plus"></i>&nbsp;Télécharger</button>
                    <?php else: ?>
                    <button type_document="<?php echo e($liquidation_document['type_document']); ?>"
                        file_id="<?php echo e($liquidation_document['document']->id); ?>" type="button"
                        class="btn btn-success download_doc_link">
                        <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                    <?php endif; ?>
                </div>


            </div>
        </div>
    </div>

    <div class="col-md-4 col-12">
        <div class="row">
            <?php if($terrain->hasLiquidationThisYear()): ?>
            <div class="col-12">
                <b
                    style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Montant</b>
                <?php if($terrain->liquidations->isNotEmpty()): ?>
                <?php $__currentLoopData = $terrain->liquidations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $liquidation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <b class="mt-1" style="color:gray;display: block; margin: auto;text-align: center;"> <?php echo e(number_format($liquidation->montant, 2, '.', ' ')); ?> MAD </b>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <br>
            <?php endif; ?>
            <div class="col-12">
                <b
                    style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Numéro</b>
                <?php if(is_null($liquidation_document['document'])): ?>
                <b type_document="<?php echo e($liquidation_document['type_document']); ?>" class="mt-1 download_doc_numero"
                    style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                    fichier importé </b>
                <?php else: ?>
                <b type_document="<?php echo e($liquidation_document['type_document']); ?>" class="mt-1 download_doc_numero"
                    style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($liquidation_document['document']->numero); ?></b>
                <?php endif; ?>
            </div>
            <div class="col-12 mt-3">
                <b
                    style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date</b>
                <?php if(is_null($liquidation_document['document'])): ?>
                <b type_document="<?php echo e($liquidation_document['type_document']); ?>" class="mt-1 download_doc_date"
                    style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                    fichier importé </b>
                <?php else: ?>
                <b type_document="<?php echo e($liquidation_document['type_document']); ?>" class="mt-1 download_doc_date"
                    style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($liquidation_document['document']->formated_date_document()); ?></b>
                <?php endif; ?>
            </div>

        </div>
    </div>
</div><?php /**PATH /home/u490561298/domains/hotpink-snake-956328.hostingersite.com/public_html/resources/views/terrains/details_liquidations.blade.php ENDPATH**/ ?>