<?php $__env->startSection('added_css'); ?>
<style>
    .card-header {
        font-size: 19px;
        display: flex;
        -webkit-box-pack: justify;
        justify-content: space-between;
        -webkit-box-align: center;
        align-items: center;
        font-weight: 600;
        background-color: #f7f7f7;
        border-bottom: 1px solid rgb(79 79 79 / 19%);
        border-radius: 5px 5px 0px 0px;
    }

    .nav-link.disabled {
        position: relative;
        color: #2d2d2d !important;
        /* Darker, clearer text */
        font-weight: 500;
        /* Make text bolder */
        pointer-events: none !important;
        cursor: not-allowed !important;
    }



    .nav-item>.disabled {
        background-image: linear-gradient(45deg, #ffffff 33.33%, #e0e0e0 33.33%, #e0e0e0 50%, #ffffff 50%, #ffffff 83.33%, #e0e0e0 83.33%, #e0e0e0 100%);
        background-size: 8.49px 8.49px;
        filter: blur(0.5px);
        /* Reduced blur, only on background */
        opacity: 0.7;
        pointer-events: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div style="padding-top: 16px;margin-left: 8px;">
    <nav class="hk-breadcrumb" aria-label="breadcrumb">
        <ol class="breadcrumb breadcrumb-light bg-transparent">
            <li class="breadcrumb-item"><a href="<?php echo e(route('terrains')); ?>">Terrains</a></li>
            </li>
            <li class="breadcrumb-item " aria-current="page">Terrain N° <?php echo e($terrain->article); ?></li>


        </ol>
    </nav>

    <div class="row">
        <div class="col-12 col-md-9">
            <?php echo $__env->make('terrains.details_info_generales', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php if($terrain->type == "Terrains taxables" || $terrain->type == "Exonerations temporaires"): ?>
            <div class="card card-refresh mt-2">
                <div class="refresh-container">
                    <div class="loader-pendulums"></div>
                </div>
                <div class="card-header card-header-action">
                    <h5 style="margin: 2px !important;color: #00b894 !important;font-size: 15px;font-weight : 600">
                        Opérations (Exercice actuelle)</h5>
                    <div class="d-flex align-items-center card-action-wrap">
                        <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_operations" aria-expanded="true">
                            <i class="zmdi zmdi-chevron-down"></i>
                        </a>
                    </div>
                </div>
                <div id="collapse_operations" class="collapse show">
                    <div class="card-body">
                        <ul class="nav nav-tabs mt-3" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php echo e((request()->tab == "declaration-tab")?'':'active'); ?>"
                                    id="declaration-tab" data-toggle="tab" data-target="#declaration" type="button"
                                    role="tab" aria-controls="donnees" aria-selected="true">Déclaration</button>
                            </li>

                            
                            <li class="nav-item" role="presentation" <?php if($terrain->type != "Terrains taxables"): ?> style="display:none;" <?php endif; ?>>
                                <button class="nav-link <?php echo e((request()->tab == "declaration-changement-prop-tab")?'active':''); ?>

                                    <?php if(!$terrain->specific_document('DECLARATION_PDF')): ?> disabled <?php endif; ?>"
                                    id="declaration-changement-prop-tab" data-toggle="tab"
                                    data-target="#declaration-changement-prop" type="button" role="tab"
                                    aria-controls="verification" aria-selected="false">Déclaration changement de
                                    propriétaire</button>
                            </li>
                           

                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php echo e((request()->tab == "exoneration-temp-tab")?'active':''); ?>

                                    <?php if(!$terrain->specific_document('DECLARATION_PDF')): ?> disabled <?php endif; ?>"
                                    id="exoneration-temp-tab" data-toggle="tab" data-target="#exoneration-temp"
                                    type="button" role="tab" aria-controls="verification"
                                    aria-selected="false">Exonération temporaire</button>
                            </li>
                            <?php if($terrain->type == "Terrains taxables"): ?>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php echo e((request()->tab == "liquidation-tab")?'active':''); ?>

                                    <?php if(!$terrain->specific_document('DECLARATION_PDF')): ?> disabled <?php endif; ?>"
                                    id="liquidation-tab" data-toggle="tab" data-target="#liquidation"
                                    type="button" role="tab" aria-controls="verification"
                                    aria-selected="false">Liquidation</button>
                            </li>
                            <?php endif; ?>
                        </ul>

                        <div class="tab-content" id="myTabContentDetails">
                            <div class="tab-pane fade <?php echo e((request()->tab == "declaration-tab")?'':'active show'); ?>"
                                id="declaration" role="tabpanel" aria-labelledby="declaration-tab">
                                <?php echo $__env->make('terrains.details_declarations', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>

                            
                            <div class="tab-pane fade <?php echo e((request()->tab == "declaration-changement-prop-tab")?'active show':''); ?>"
                                id="declaration-changement-prop" role="tabpanel"
                                aria-labelledby="declaration-changement-prop-tab">
                                <?php echo $__env->make('terrains.details_declarations_changement_prop', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                           


                            <div class="tab-pane fade <?php echo e((request()->tab == "exoneration-temp-tab")? 'active show'
                                :''); ?>" id="exoneration-temp" role="tabpanel" aria-labelledby="exoneration-temp-tab">
                                <?php echo $__env->make('terrains.details_exonerations_temp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>

                            <?php if($terrain->type == "Terrains taxables"): ?>
                            <div class="tab-pane fade <?php echo e((request()->tab == "liquidation-tab")? 'active show' :''); ?>"
                                id="liquidation" role="tabpanel" aria-labelledby="liquidation-tab">
                                <?php echo $__env->make('terrains.details_liquidations', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="mb-3"></div>
            </div>
            <?php endif; ?>

            <?php echo $__env->make('terrains.details_historique', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


            <div class="card card-refresh mt-2">
                <div class="refresh-container">
                    <div class="loader-pendulums"></div>
                </div>
                <div class="card-header card-header-action">
                    <h5 style="margin: 2px !important;color: #00b894 !important;font-size: 15px;font-weight : 600">
                        Photothèque</h5>
                    <div class="d-flex align-items-center card-action-wrap">
                        <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_phototeque" aria-expanded="true">
                            <i class="zmdi zmdi-chevron-down"></i>
                        </a>
                    </div>
                </div>
                <div id="collapse_phototeque" class="collapse show">
                    <div class="card-body">
                        <div class="col-12">
                            <?php $__currentLoopData = $terrain_phototheque; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photos_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-6">
                                <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button"
                                    class="btn btn-light upload_photo_link"> <i
                                        class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                                <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" disabled
                                    class="btn btn-danger delete_photo_link"> <i
                                        class="fa-solid fa-plus"></i>&nbsp;Supprimer</button>
                            </div>
                            <div id="photos_<?php echo e($photos_group['type_document']); ?>" class="phototheque hk-gallery"
                                type_document="<?php echo e($photos_group['type_document']); ?>"
                                style="width: 100%;border-radius:6px;border:1px #949494 solid;height:120px;overflow-x: auto;white-space: nowrap;padding:4px">
                                <?php $__currentLoopData = $photos_group['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a class="costume-img" href="<?php echo e($photo->documentUrl()); ?>" style="margin: 0px;">
                                    <img data-src="<?php echo e($photo->documentUrl()); ?>"
                                        style="border: 1px #cacaca solid;padding: 0px;margin: 0px;"
                                        src="<?php echo e($photo->documentUrl()); ?>" class="gallery-img costume-img hk-gallery">
                                    </br>
                                    <input item_id="<?php echo e($photo->id); ?>"
                                        type_document="<?php echo e($photos_group['type_document']); ?>" class="select_photo_cb"
                                        style="margin: auto;display: block;position: relative;" type="checkbox">
                                </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>

                    </div>
                </div>

                <div class="mb-3"></div>
            </div>

        </div>


        <div class="col-12 col-md-3" style="padding-top: 8px;">

            <div class="row" style="background: #ffffff; border-radius: 6px; border: 1px #003366 solid;">
                <div class="header" style="background-color: 
                                    <?php echo e($terrain->type == 'Terrains taxables' ? '#ffb964' : 
                                    ($terrain->type == 'Exonerations permanentes' ? '#aed581' : 
                                    ($terrain->type == 'Exonerations temporaires' ? '#80cbc4' : '#e0e0e0'))); ?>;
                                color: #003366;
                                text-align: center;
                                padding: 10px;
                                border-radius: 6px 6px 0px 0px;;width : 100%">
                    <i style="text-align: center; margin: auto; font-size:20px; color: #003366;"
                        class="fa-regular fa-folder-open"></i>
                    <h5 class="mt-2" style="margin: 0; font-weight: bold;">
                        <?php echo e($terrain->type == 'Terrains taxables' ? 'TERRAIN TAXABLE' :
                        ($terrain->type == 'Exonerations permanentes' ? 'TERRAIN NON TAXABLE' :
                        ($terrain->type == 'Exonerations temporaires' ? 'EXONÉRATION TEMPORAIRE' : 'TERRAIN
                        LOTI/CONSTRUIT'))); ?>

                    </h5>
                </div>
                <div class="row" style="background: #ffffff; padding: 8px; border-radius: 6px;width : 100%">
                    <div class="col-12">
                        <div class="input-group input-group-sm">
                            <div class="input-group mb-1 mt-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 140px;">Article :</span>
                                </div>
                                <input disabled="" style="width: 30px;" value="<?php echo e($terrain->article); ?>" type="text"
                                    class="form-control" placeholder="" aria-label="">
                            </div>
                        </div>
                        <div class="input-group input-group-sm">
                            <div class="input-group mb-1 mt-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 140px;">Référence Foncière
                                        :</span>
                                </div>
                                <input disabled="" style="width: 30px;" value="<?php echo e($terrain->ref); ?>" type="text"
                                    class="form-control" placeholder="" aria-label="">
                            </div>
                        </div>
                        <div class="input-group input-group-sm">
                            <div class="input-group mb-1 mt-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 140px;">Surface :</span>
                                </div>
                                <input disabled="" style="width: 30px;" value="<?php echo e($terrain->surface); ?>" type="text"
                                    class="form-control" placeholder="" aria-label="">
                            </div>
                        </div>
                        <div class="input-group input-group-sm">
                            <div class="input-group mb-1 mt-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 140px;">Zoning:</span>
                                </div>
                                <input disabled="" style="width: 30px;"
                                    value="<?php echo e($terrain->zones->pluck('nom')->implode(', ')); ?>" type="text"
                                    class="form-control" placeholder="" aria-label="">
                            </div>
                        </div>
                        <div class="input-group input-group-sm">
                            <div class="input-group mb-1 mt-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 140px;">Adresse :</span>
                                </div>
                                <input disabled="" style="width: 30px;" value="<?php echo e($terrain->adresse); ?>" type="text"
                                    class="form-control" placeholder="" aria-label="">
                            </div>
                        </div>
                    </div>


                    <div class="col-12">
                        <?php if($terrain->type == "Terrains supprimés"): ?>
                        <h6 class="mt-3">Avancement</h6>
                        <div class="input-group input-group-sm">
                            <div class="input-group mb-1 mt-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 140px;"> Date achèvement
                                        :</span>
                                </div>
                                <input disabled="" style="width: 30px;" value="<?php echo e($date_avancement_travaux); ?>"
                                    type="text" class="form-control" placeholder="" aria-label="">
                            </div>
                        </div>
                        <?php endif; ?>
                        <h6 class="mt-3">Déclaration</h6>
                        <div class="input-group input-group-sm">
                            <div class="input-group mb-1 mt-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 140px;">Dernière déclaration
                                        :</span>
                                </div>
                                <input disabled="" style="width: 30px;"
                                    value="<?php echo e($derniere_declaration->date ?? 'Aucune déclaration'); ?>" type="text"
                                    class="form-control" placeholder="" aria-label="">
                            </div>
                        </div>

                        <h6 class="mt-3">Liquidation</h6>

                        <div class="input-group input-group-sm">
                            <div class="input-group mb-1 mt-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 140px;">Dernière liquidation
                                        :</span>
                                </div>
                                <input disabled="" style="width: 30px;"
                                    value="<?php echo e($derniere_liquidation->date ?? 'Aucune liquidation'); ?>" type="text"
                                    class="form-control" placeholder="" aria-label="">
                            </div>
                        </div>


                        <h6 class="mt-3">Dernières photos</h6>
                        <div class="row mt-2">


                            <?php $__empty_1 = true; $__currentLoopData = $latest_three_photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="col-12 mb-3">
                                <div class="card shadow-sm">
                                    <img src="<?php echo e($photo->documentUrl()); ?>" alt="Photo terrain" class="card-img-top"
                                        style="height: 150px; object-fit: cover; cursor: pointer;"
                                        onclick="openImageModal('<?php echo e($photo->documentUrl()); ?>')">
                                    <div class="card-body p-2">
                                        <small class="text-muted">
                                            <i class="fas fa-calendar-alt me-1"></i>
                                            <?php echo e(\Carbon\Carbon::parse($photo->created_at)->format('d/m/Y')); ?>

                                        </small>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-12">
                                <div class="alert alert-info"
                                    style="color: #2c3e50 !important;border-radius: 6px;padding: 1rem 1.25rem;">
                                    <i class="fas fa-info-circle me-2"></i>
                                    Aucune photo disponible
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>


                    <?php if($terrain != "Terrains supprimes"): ?>
                        <button id="save_terrain"
                            style="width: 100%; ; border: 1px #a1a1a1 solid !important;margin-top : 15px;color: #003366;font-weight: bold;text-decoration : unset"
                            type="button" class="btn">
                            <i class="far fa-save"></i>
                            <span style="display: none;" class="spinner-border spinner-border-sm" role="status"
                                aria-hidden="true"></span>
                            Enregistrer
                        </button>
                    <?php endif; ?>
                </div>



            </div>

        </div>
    </div>
</div>
<?php echo $__env->make('terrains.modals', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('added_scripts'); ?>


<script>
    var zones_pa = <?php echo json_encode($zones_pa, JSON_PRETTY_PRINT, 512) ?>;
    var terrain = <?php echo json_encode($terrain, JSON_PRETTY_PRINT, 512) ?>;
    var active_proprietaires = <?php echo json_encode($active_proprietaires, JSON_PRETTY_PRINT, 512) ?>;

</script>


<script src="<?php echo e(asset('js/terrains/show.js') . '?t=' . time()); ?>"></script>
<script src="<?php echo e(asset('js/terrains/details_info_generales.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/terrains/proprietaires.js').'?t='.time()); ?>"></script>
<?php if($terrain->type == "Terrains taxables"): ?>
<script src="<?php echo e(asset('js/terrains/liquidations.js').'?t='.time()); ?>"></script>
<?php endif; ?>

<script>
    $(document).ready(function() {
        for (var i = 0; i < active_proprietaires.length; i++) {
            console.log('active prop add')
            proprietaires_add(active_proprietaires[i]);
        }
    });

    function scrollToSection(sectionId) {
        const element = document.getElementById(sectionId);
        if (element) {
            element.scrollIntoView({
                behavior: 'smooth'
                , block: 'start'
            });
        }
    }

</script>


<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/jobbidmng/public_html/etnb/resources/views/terrains/show.blade.php ENDPATH**/ ?>