<div class="row mt-3" id="declarations">
    <div class="col-12">
        <table class="table rtable datatables table-striped no-footer display nowrap">
            <thead>
                <th>Document</th>
                <th>Type du fichier</th>
                <th>Date dépôt</th>
                <th>Date document</th>
                <th></th>
                <th></th>
            </thead>
            <tbody>
                <?php $__currentLoopData = $declaration_documents_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $declaration_doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($declaration_doc['name']); ?>

                        <?php if($declaration_doc['document']!=null &&
                        $declaration_doc['validation']==1): ?>
                        <span style="font-weight:bold;color:<?php echo e($declaration_doc['document']->decision_color()); ?>">
                            -
                            <?php echo e($declaration_doc['document']->decision_full()); ?></span>
                        <?php endif; ?>
                    </td>
                    <td>Fichier <?php echo e(strtoupper($declaration_doc['file_type'])); ?></td>
                    <td>
                        <?php if(is_null($declaration_doc['document'])): ?>
                        <span type_document="<?php echo e($declaration_doc['type_document']); ?>" class="download_depot_date"
                            style="color:gray">Aucun fichier
                            importé</span>
                        <?php else: ?>
                        <span type_document="<?php echo e($declaration_doc['type_document']); ?>" class="download_depot_date"
                            style="color:black"><?php echo e($declaration_doc['document']->formated_created_at()); ?>

                            - <span style="color:coral"><?php echo e($declaration_doc['document']->user->nom.'
                                '.$declaration_doc['document']->user->prenom); ?>


                                <?php endif; ?>
                    </td>

                    <td>
                        <?php if(!is_null($declaration_doc['document'])): ?>
                        <span><?php echo e($declaration_doc['document']->formated_date_document()); ?>

                        </span>
                        <?php else: ?>
                        <span type_document="<?php echo e($declaration_doc['type_document']); ?>" style="color:gray">Aucun fichier
                            importé</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if(is_null($declaration_doc['document'])): ?>
                        <button type_document="<?php echo e($declaration_doc['type_document']); ?>"
                            file_type="<?php echo e($declaration_doc['file_type']); ?>" type="button"
                            class="btn btn-light upload_doc_link"> <i
                                class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if(is_null($declaration_doc['document'])): ?>
                        <button type_document="<?php echo e($declaration_doc['type_document']); ?>" file_id="" disabled type="button"
                            class="btn btn-success download_doc_link"><i
                                class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                        <?php else: ?>
                        <button type_document="<?php echo e($declaration_doc['type_document']); ?>"
                            file_id="<?php echo e($declaration_doc['document']->id); ?>" type="button"
                            class="btn btn-success download_doc_link"><i
                                class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
        </table>
    </div>



    <div class="col-12 mt-2">
        <div class="row">
            <div class="col-md-4 col-12">
                <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                    <div>
                        <?php if(is_null($declaration_document['document'])): ?>
                        <i type_document="<?php echo e($declaration_document['type_document']); ?>"
                            style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;"
                            class="fa-solid fa-file-pdf-o upload_doc_icon"></i>
                        <?php else: ?>
                        <i type_document="<?php echo e($declaration_document['type_document']); ?>"
                            style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;"
                            class="fa-solid fa-file-circle-check upload_doc_icon"></i>

                        <?php endif; ?>


                        <b class="mt-2 upload_doc_no_file_label"
                            style="color:gray;display: block; margin: auto;text-align: center;">
                            Génération de la déclaration
                        </b>

                        <div style="margin: auto; display: block;text-align: center;">
                            <form action="/declarations/generate-pdf" method="POST" target="_blank">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="terrain_id" id="terrain_id_liquidation_input"
                                    value="<?php echo e($terrain->id); ?>">

                                <div style="margin: auto; display: block;text-align: center;">

                                    <?php if($terrain->specific_document('PLAN_CADASTRAL_SITUATION_PDF') &&
                                    $terrain->specific_document('CERTIFICAT_ATTESTATION_PROPRIETE_PDF')): ?>
                                    <?php if(!$terrain->specific_document('DECLARATION_PDF')): ?>
                                    <button type="submit" type="button" class="btn btn-light"> <i
                                            class="fa-solid fa-plus"></i>&nbsp;Générer</button>
                                    <?php else: ?>
                                    <b class="mt-2 upload_doc_no_file_label"
                                        style="color:#0F91C8;display: block; margin: auto;text-align: center;">Générée
                                        par <?php echo e($terrain->specific_document('DECLARATION_PDF')->user->nom.'
                                        '.$terrain->specific_document('DECLARATION_PDF')->user->prenom); ?> -
                                        <?php echo e($terrain->specific_document('DECLARATION_PDF')->formated_created_at()); ?></b>
                                    <?php endif; ?>
                                    <?php else: ?>
                                    <b class="mt-2 upload_doc_no_file_label"
                                        style="color:#0F91C8;display: block; margin: auto;text-align: center;">Les
                                        documents nécessaires non importés</b>
                                    <?php endif; ?>
                                </div>
                            </form>
                        </div>


                    </div>
                </div>
            </div>
            <div class="col-md-4 col-12">
                <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                    <div>
                        <?php if(is_null($declaration_document['document'])): ?>
                        <i type_document="<?php echo e($declaration_document['type_document']); ?>"
                            style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;"
                            class="fa-solid fa-file-circle-xmark upload_doc_icon"></i>
                        <?php else: ?>
                        <i type_document="<?php echo e($declaration_document['type_document']); ?>"
                            style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;"
                            class="fa-solid fa-file-circle-check upload_doc_icon"></i>
                        <?php endif; ?>

                        <?php if(is_null($declaration_document['document'])): ?>
                        <b type_document="<?php echo e($declaration_document['type_document']); ?>"
                            class="mt-2 upload_doc_no_file_label"
                            style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                            fichier importé </b>
                        <?php endif; ?>
                        <div style="margin: auto; display: block;text-align: center;">
                            <?php if($terrain->specific_document('PLAN_CADASTRAL_SITUATION_PDF') &&
                            $terrain->specific_document('CERTIFICAT_ATTESTATION_PROPRIETE_PDF')): ?>

                            <?php if( $declaration_document['active']==1): ?>
                            <?php if(!$terrain->specific_document('DECLARATION_PDF')): ?>
                            <button type_document="<?php echo e($declaration_document['type_document']); ?>"
                                file_type="<?php echo e($declaration_document['file_type']); ?>" type="button"
                                class="btn btn-light upload_doc_link"> <i
                                    class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                            <?php else: ?>
                            <b class="mt-2 upload_doc_no_file_label"
                                style="color:#0F91C8;display: block; margin: auto;text-align: center;">Déclaration
                                Importée</b>
                            <?php endif; ?>
                            <?php endif; ?>
                            <?php endif; ?>
                            <?php if(is_null($declaration_document['document'])): ?>
                            <button disabled type_document="<?php echo e($declaration_document['type_document']); ?>" file_id=""
                                type="button" class="btn btn-success download_doc_link"> <i
                                    class="fa-solid fa-plus"></i>&nbsp;Télécharger</button>
                            <?php else: ?>
                            <button type_document="<?php echo e($declaration_document['type_document']); ?>"
                                file_id="<?php echo e($declaration_document['document']->id); ?>" type="button"
                                class="btn btn-success download_doc_link">
                                <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-4 col-12">
                <div class="row">
                    <div class="col-12">
                        <b
                            style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Numéro
                            déclaration</b>
                        <?php if(is_null($declaration_document['document'])): ?>
                        <b type_document="<?php echo e($declaration_document['type_document']); ?>" class="mt-1 download_doc_numero"
                            style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                            fichier importé </b>
                        <?php else: ?>
                        <b type_document="<?php echo e($declaration_document['type_document']); ?>" class="mt-1 download_doc_numero"
                            style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($declaration_document['document']->numero); ?></b>
                        <?php endif; ?>
                    </div>
                    <div class="col-12 mt-3">
                        <b
                            style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date
                            déclaration</b>
                        <?php if(is_null($declaration_document['document'])): ?>
                        <b type_document="<?php echo e($declaration_document['type_document']); ?>" class="mt-1 download_doc_date"
                            style="color:gray;display: block; margin: auto;text-align: center;">Aucun
                            fichier importé </b>
                        <?php else: ?>
                        <b type_document="<?php echo e($declaration_document['type_document']); ?>" class="mt-1 download_doc_date"
                            style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($declaration_document['document']->formated_date_document()); ?></b>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/jobbidmng/public_html/ettnb.ma/resources/views/terrains/details_declarations.blade.php ENDPATH**/ ?>