<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Liquidation</title>
    <style>
   @font-face {
            font-family: 'droidarabic';
            src: url('<?php echo e(storage_path('fonts/droid-arabic/Droid-Arabic.ttf')); ?>') format('truetype');
            font-weight: normal;
            font-style: normal;
        }
        /* General styles */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            font-size: 11px;
        }

        h1,
        h3 {
            text-align: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid black;
            padding: 5px;
            text-align: center;
        }

        th {
            background-color: #f9f9f9;
        }


        .outside-border-table {
            border-collapse: collapse !important;
            border: 1px solid #000 !important;
            width: 100% !important;
        }

        .outside-border-table td {
            border: none;
            padding: 8px;
        }

        .outside-border-table .bold {
            font-weight: bold;
        }

        .outside-border-table .left {
            text-align: left;
        }

       

    </style>
</head>

<body>
    <table style="width:100%">
        <tbody>
            <tr style="border :  0px solid;">
                <td style="width:25%;font-size : 1em;font-weight : bold;border :  0px solid">
                    Royaume du Maroc <br>
                    Ministère de l’Intérieur<br>
                    Commune M'diq<br>
                    Régie municipale<br>
                    Division du Développement des Ressources Financières<br>
                </td>
                <td style="width:50%;border :  0px solid"></td>
                <td style="width:25%;border :  0px solid;text-align : right;font-family : droidarabic;">البريد الإلكتروني : ---- <br></td>
            </tr>
        </tbody>
    </table>
    <br>
    <table>
        <tbody>
            <tr>
                <td style="background-color : #e6e6e6">
                    <h1>Taxe sur les terrains urbains non bâtis</h1>
                    <h2>Déclaration d’un terrain urbain non bâti</h2>
                </td>
            </tr>
        </tbody>
    </table>    
    <br>
  
    <h2 style="text-align: center">Terrain</h2>
    <table class="outside-border-table">
        <tbody>
            <tr>
                <td class="left bold">Article :</td>
                <td class="left"><?php echo e($terrain->article); ?></td>
                <td class="left bold">Référence foncière :</td>
                <td class="left"><?php echo e($terrain->ref); ?></td>
            </tr>
            <tr>
                <td class="left bold">Localisation :</td>
                <td class="left"><?php echo e($terrain->adresse); ?></td>
                <td class="left bold">Zoning :</td>
                <td class="left"><?php echo e($terrain->zones->pluck('nom')->implode(', ')); ?></td>
            </tr>
        </tbody>
    </table>
    <br>
    <hr style="border-top : 1px dashed gray;border-bottom : 0px">
    <h2 style="text-align: center">Redevables</h2>   
    <table>
        <thead>
            <thead>
                <th style="width : 30%">Nom/ Raison sociale</th>
                <th style="width : 10%">CIN/RC</th>                
                <th style="width : 5%">Q.P</th>
                <th style="width : 10%">Téléphone</th>
                <th style="width : 30%">Adresse</th>
            </thead>
            <tbody>
                <?php $__currentLoopData = $terrain->proprietaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proprietaire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($proprietaire->nom); ?> <?php echo e($proprietaire->prenom); ?></td>
                        <?php if($proprietaire->type === "physique"): ?>
                        <td><?php echo e($proprietaire->cine); ?></td>
                        <?php elseif($proprietaire->type === "morale"): ?>
                        <td><?php echo e($proprietaire->rc); ?>-<?php echo e($proprietaire->ville_rc); ?></td>
                        <?php else: ?>
                        <?php endif; ?>                        
                        <td><?php echo e($proprietaire->pivot->quote_part ?? '—'); ?></td>
                        <td><?php echo e($proprietaire->tel); ?></td>
                        <td><?php echo e($proprietaire->adresse_redevable); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>              
            </tbody>
        </thead>
    </table>
    <br> 
    <br> 
    
    <table class="outside-border-table">
        <tbody>
            <tr>
                <td colspan="4" class="bold">Je, soussigné, déclare exacte les informations contenues dans cette déclaration</td>
            </tr>
            <tr>
                <td class="left bold"></td>
                <td class="left"></td>
                <td class="left bold">Lieu :</td>
                <td class="left">---</td>
            </tr>
            <tr>
                <td class="left bold"></td>
                <td class="left"></td>
                <td class="left bold">Date :</td>
                <td class="left">----</td>
            </tr>
        </tbody>
    </table>
    <br>
    <br>
    <br>
    <br>
    <table>
        <tbody>
            <tr>
                <td style="text-align: right;border :  0px solid">Signature de déclarant :</td>
            </tr>
        </tbody>
    </table>
</body>

</html>
<?php /**PATH /home/u490561298/domains/hotpink-snake-956328.hostingersite.com/public_html/resources/views/terrains/declaration_pdf.blade.php ENDPATH**/ ?>